/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider.kafka;

import java.util.Collection;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;

public class KafkaAuditProvider
extends AuditDestination {
    private static final Log LOG = LogFactory.getLog(KafkaAuditProvider.class);
    public static final String AUDIT_MAX_QUEUE_SIZE_PROP = "xasecure.audit.kafka.async.max.queue.size";
    public static final String AUDIT_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.kafka.async.max.flush.interval.ms";
    public static final String AUDIT_KAFKA_BROKER_LIST = "xasecure.audit.kafka.broker_list";
    public static final String AUDIT_KAFKA_TOPIC_NAME = "xasecure.audit.kafka.topic_name";
    boolean initDone = false;
    Producer<String, String> producer = null;
    String topic = null;

    @Override
    public void init(Properties props) {
        LOG.info((Object)"init() called");
        super.init(props);
        this.topic = MiscUtil.getStringProperty(props, AUDIT_KAFKA_TOPIC_NAME);
        if (this.topic == null || this.topic.isEmpty()) {
            this.topic = "ranger_audits";
        }
        try {
            if (!this.initDone) {
                String brokerList = MiscUtil.getStringProperty(props, AUDIT_KAFKA_BROKER_LIST);
                if (brokerList == null || brokerList.isEmpty()) {
                    brokerList = "localhost:9092";
                }
                Properties kakfaProps = new Properties();
                kakfaProps.put("metadata.broker.list", brokerList);
                kakfaProps.put("serializer.class", "kafka.serializer.StringEncoder");
                kakfaProps.put("request.required.acks", "1");
                LOG.info((Object)("Connecting to Kafka producer using properties:" + kakfaProps.toString()));
                ProducerConfig kafkaConfig = new ProducerConfig(kakfaProps);
                this.producer = new Producer(kafkaConfig);
                this.initDone = true;
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error initializing kafka:", t);
        }
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (event instanceof AuthzAuditEvent) {
            AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
            if (authzEvent.getAgentHostname() == null) {
                authzEvent.setAgentHostname(MiscUtil.getHostname());
            }
            if (authzEvent.getLogType() == null) {
                authzEvent.setLogType("RangerAudit");
            }
            if (authzEvent.getEventId() == null) {
                authzEvent.setEventId(MiscUtil.generateUniqueId());
            }
        }
        String message = MiscUtil.stringify(event);
        try {
            if (this.producer != null) {
                KeyedMessage keyedMessage = new KeyedMessage(this.topic, (Object)message);
                this.producer.send(keyedMessage);
            } else {
                LOG.info((Object)("AUDIT LOG (Kafka Down):" + message));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Error sending message to Kafka topic. topic=" + this.topic + ", message=" + message), t);
            return false;
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        for (String event : events) {
            this.logJSON(event);
        }
        return false;
    }

    @Override
    public void start() {
        LOG.info((Object)"start() called");
    }

    @Override
    public void stop() {
        LOG.info((Object)"stop() called");
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Throwable t) {
                LOG.error((Object)"Error closing Kafka producer");
            }
        }
    }

    @Override
    public void waitToComplete() {
        LOG.info((Object)"waitToComplete() called");
    }

    @Override
    public void waitToComplete(long timeout) {
    }

    @Override
    public void flush() {
        LOG.info((Object)"flush() called");
    }

    public boolean isAsync() {
        return true;
    }
}

