/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.queue.AuditQueue;

public class AuditFileSpool
implements Runnable {
    private static final Log logger = LogFactory.getLog(AuditFileSpool.class);
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "filespool.dir";
    public static final String PROP_FILE_SPOOL_LOCAL_FILE_NAME = "filespool.filename.format";
    public static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "filespool.archive.dir";
    public static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "filespool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILENAME_PREFIX = "filespool.file.prefix";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER = "filespool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_INDEX_FILE = "filespool.index.filename";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "filespool.destination.retry.ms";
    AuditQueue queueProvider = null;
    AuditHandler consumerProvider = null;
    BlockingQueue<AuditIndexRecord> indexQueue = new LinkedBlockingQueue<AuditIndexRecord>();
    File logFolder = null;
    String logFileNameFormat = null;
    File archiveFolder = null;
    String fileNamePrefix = null;
    String indexFileName = null;
    File indexFile = null;
    String indexDoneFileName = null;
    File indexDoneFile = null;
    int retryDestinationMS = 30000;
    int fileRolloverSec = 86400;
    int maxArchiveFiles = 100;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS = 0L;
    List<AuditIndexRecord> indexRecords = new ArrayList<AuditIndexRecord>();
    boolean isPending = false;
    long lastAttemptTime = 0L;
    boolean initDone = false;
    PrintWriter logWriter = null;
    AuditIndexRecord currentWriterIndexRecord = null;
    AuditIndexRecord currentConsumerIndexRecord = null;
    BufferedReader logReader = null;
    Thread destinationThread = null;
    boolean isWriting = true;
    boolean isDrain = false;
    boolean isDestDown = false;
    private Gson gson = null;

    public AuditFileSpool(AuditQueue queueProvider, AuditHandler consumerProvider) {
        this.queueProvider = queueProvider;
        this.consumerProvider = consumerProvider;
    }

    public void init(Properties prop) {
        this.init(prop, null);
    }

    public boolean init(Properties props, String basePropertyName) {
        if (this.initDone) {
            logger.error((Object)("init() called more than once. queueProvider=" + this.queueProvider.getName() + ", consumerProvider=" + this.consumerProvider.getName()));
            return true;
        }
        String propPrefix = "xasecure.audit.filespool";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        try {
            boolean ret;
            boolean ret2;
            this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").create();
            String logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR);
            this.logFileNameFormat = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_FILE_SPOOL_LOCAL_FILE_NAME);
            String archiveFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_DIR);
            this.fileNamePrefix = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILENAME_PREFIX);
            this.indexFileName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_INDEX_FILE);
            this.retryDestinationMS = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_DEST_RETRY_MS, this.retryDestinationMS);
            this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILE_ROLLOVER, this.fileRolloverSec);
            this.maxArchiveFiles = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, this.maxArchiveFiles);
            logger.info((Object)("retryDestinationMS=" + this.retryDestinationMS + ", queueName=" + this.queueProvider.getName()));
            logger.info((Object)("fileRolloverSec=" + this.fileRolloverSec + ", queueName=" + this.queueProvider.getName()));
            logger.info((Object)("maxArchiveFiles=" + this.maxArchiveFiles + ", queueName=" + this.queueProvider.getName()));
            if (logFolderProp == null || logFolderProp.isEmpty()) {
                logger.fatal((Object)("Audit spool folder is not configured. Please set " + propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR + ". queueName=" + this.queueProvider.getName()));
                return false;
            }
            this.logFolder = new File(logFolderProp);
            if (!this.logFolder.isDirectory()) {
                this.logFolder.mkdirs();
                if (!this.logFolder.isDirectory()) {
                    logger.fatal((Object)("File Spool folder not found and can't be created. folder=" + this.logFolder.getAbsolutePath() + ", queueName=" + this.queueProvider.getName()));
                    return false;
                }
            }
            logger.info((Object)("logFolder=" + this.logFolder + ", queueName=" + this.queueProvider.getName()));
            if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
                this.logFileNameFormat = "spool_%app-type%_%time:yyyyMMdd-HHmm.ss%.log";
            }
            logger.info((Object)("logFileNameFormat=" + this.logFileNameFormat + ", queueName=" + this.queueProvider.getName()));
            this.archiveFolder = archiveFolderProp == null || archiveFolderProp.isEmpty() ? new File(this.logFolder, "archive") : new File(archiveFolderProp);
            if (!this.archiveFolder.isDirectory()) {
                this.archiveFolder.mkdirs();
                if (!this.archiveFolder.isDirectory()) {
                    logger.error((Object)("File Spool archive folder not found and can't be created. folder=" + this.archiveFolder.getAbsolutePath() + ", queueName=" + this.queueProvider.getName()));
                    return false;
                }
            }
            logger.info((Object)("archiveFolder=" + this.archiveFolder + ", queueName=" + this.queueProvider.getName()));
            if (this.indexFileName == null || this.indexFileName.isEmpty()) {
                if (this.fileNamePrefix == null || this.fileNamePrefix.isEmpty()) {
                    this.fileNamePrefix = this.queueProvider.getName() + "_" + this.consumerProvider.getName();
                }
                this.indexFileName = "index_" + this.fileNamePrefix + "_" + "%app-type%" + ".json";
                this.indexFileName = MiscUtil.replaceTokens(this.indexFileName, System.currentTimeMillis());
            }
            this.indexFile = new File(this.logFolder, this.indexFileName);
            if (!this.indexFile.exists() && !(ret2 = this.indexFile.createNewFile())) {
                logger.fatal((Object)("Error creating index file. fileName=" + this.indexDoneFile.getPath()));
                return false;
            }
            logger.info((Object)("indexFile=" + this.indexFile + ", queueName=" + this.queueProvider.getName()));
            int lastDot = this.indexFileName.lastIndexOf(46);
            if (lastDot < 0) {
                lastDot = this.indexFileName.length() - 1;
            }
            this.indexDoneFileName = this.indexFileName.substring(0, lastDot) + "_closed.json";
            this.indexDoneFile = new File(this.logFolder, this.indexDoneFileName);
            if (!this.indexDoneFile.exists() && !(ret = this.indexDoneFile.createNewFile())) {
                logger.fatal((Object)("Error creating index done file. fileName=" + this.indexDoneFile.getPath()));
                return false;
            }
            logger.info((Object)("indexDoneFile=" + this.indexDoneFile + ", queueName=" + this.queueProvider.getName()));
            this.loadIndexFile();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.done)) {
                    this.isPending = true;
                }
                if (auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.write_inprogress)) {
                    this.currentWriterIndexRecord = auditIndexRecord;
                    logger.info((Object)("currentWriterIndexRecord=" + this.currentWriterIndexRecord.filePath + ", queueName=" + this.queueProvider.getName()));
                }
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.read_inprogress)) continue;
                this.indexQueue.add(auditIndexRecord);
            }
            this.printIndex();
            for (int i = 0; i < this.indexRecords.size(); ++i) {
                AuditIndexRecord auditIndexRecord;
                auditIndexRecord = this.indexRecords.get(i);
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.pending)) continue;
                File consumerFile = new File(auditIndexRecord.filePath);
                if (!consumerFile.exists()) {
                    logger.error((Object)("INIT: Consumer file=" + consumerFile.getPath() + " not found."));
                    continue;
                }
                this.indexQueue.add(auditIndexRecord);
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)("Error initializing File Spooler. queue=" + this.queueProvider.getName()), t);
            return false;
        }
        this.initDone = true;
        return true;
    }

    public void start() {
        if (!this.initDone) {
            logger.error((Object)("Cannot start Audit File Spooler. Initilization not done yet. queueName=" + this.queueProvider.getName()));
            return;
        }
        logger.info((Object)("Starting writerThread, queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
        this.destinationThread = new Thread((Runnable)this, this.queueProvider.getName() + "_" + this.consumerProvider.getName() + "_destWriter");
        this.destinationThread.setDaemon(true);
        this.destinationThread.start();
    }

    public void stop() {
        if (!this.initDone) {
            logger.error((Object)("Cannot stop Audit File Spooler. Initilization not done. queueName=" + this.queueProvider.getName()));
            return;
        }
        logger.info((Object)("Stop called, queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
        this.isDrain = true;
        this.flush();
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.isWriting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    logger.info((Object)("Closing open file, queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
                    out.flush();
                    out.close();
                    break;
                }
                catch (Throwable t) {
                    logger.debug((Object)"Error closing spool out file.", t);
                }
            }
        }
        try {
            if (this.destinationThread != null) {
                this.destinationThread.interrupt();
            }
            this.destinationThread = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.initDone) {
            logger.error((Object)("Cannot flush Audit File Spooler. Initilization not done. queueName=" + this.queueProvider.getName()));
            return;
        }
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            out.flush();
        }
    }

    public boolean isPending() {
        if (!this.initDone) {
            this.logError("isPending(): File Spooler not initialized. queueName=" + this.queueProvider.getName());
            return false;
        }
        return this.isPending;
    }

    public long getLastAttemptTimeDelta() {
        if (this.lastAttemptTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAttemptTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stashLogs(AuditEventBase event) {
        if (this.isDrain) {
            logger.error((Object)("stashLogs() is called after stop is called. event=" + event));
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            String jsonStr = MiscUtil.stringify(event);
            logOut.println(jsonStr);
            this.isPending = true;
        }
        catch (Exception ex) {
            logger.error((Object)("Error writing to file. event=" + event), (Throwable)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogs(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.stashLogs(event);
        }
        this.flush();
    }

    public synchronized void stashLogsString(String event) {
        if (this.isDrain) {
            logger.error((Object)("stashLogs() is called after stop is called. event=" + event));
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            logOut.println(event);
        }
        catch (Exception ex) {
            logger.error((Object)("Error writing to file. event=" + event), (Throwable)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogsString(Collection<String> events) {
        for (String event : events) {
            this.stashLogsString(event);
        }
        this.flush();
    }

    private synchronized PrintWriter getOpenLogFileStream() {
        return this.logWriter;
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.currentWriterIndexRecord == null) {
            String fileName;
            Date currentTime = new Date();
            String newFileName = fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            File outLogFile = null;
            int i = 0;
            while (true) {
                outLogFile = new File(this.logFolder, newFileName);
                File archiveLogFile = new File(this.archiveFolder, newFileName);
                if (!outLogFile.exists() && !archiveLogFile.exists()) break;
                int lastDot = fileName.lastIndexOf(46);
                String baseName = fileName.substring(0, lastDot);
                String extension = fileName.substring(lastDot);
                newFileName = baseName + "." + ++i + extension;
            }
            fileName = newFileName;
            logger.info((Object)("Creating new file. queueName=" + this.queueProvider.getName() + ", fileName=" + fileName));
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLogFile)));
            AuditIndexRecord tmpIndexRecord = new AuditIndexRecord();
            tmpIndexRecord.id = MiscUtil.generateUniqueId();
            tmpIndexRecord.filePath = outLogFile.getPath();
            tmpIndexRecord.status = SPOOL_FILE_STATUS.write_inprogress;
            tmpIndexRecord.fileCreateTime = currentTime;
            tmpIndexRecord.lastAttempt = true;
            this.currentWriterIndexRecord = tmpIndexRecord;
            this.indexRecords.add(this.currentWriterIndexRecord);
            this.saveIndexFile();
        } else if (this.logWriter == null) {
            logger.info((Object)("Opening existing file for append. queueName=" + this.queueProvider.getName() + ", fileName=" + this.currentWriterIndexRecord.filePath));
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.currentWriterIndexRecord.filePath, true)));
        }
        return this.logWriter;
    }

    private synchronized void closeFileIfNeeded() throws FileNotFoundException, IOException {
        if (this.currentWriterIndexRecord != null) {
            boolean closeFile = false;
            if (this.indexRecords.size() == 1) {
                closeFile = true;
                logger.info((Object)("Closing file. Only one open file. queueName=" + this.queueProvider.getName() + ", fileName=" + this.currentWriterIndexRecord.filePath));
            } else if (System.currentTimeMillis() - this.currentWriterIndexRecord.fileCreateTime.getTime() > (long)(this.fileRolloverSec * 1000)) {
                closeFile = true;
                logger.info((Object)("Closing file. Rolling over. queueName=" + this.queueProvider.getName() + ", fileName=" + this.currentWriterIndexRecord.filePath));
            }
            if (closeFile) {
                if (this.logWriter != null) {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                }
                this.currentWriterIndexRecord.status = SPOOL_FILE_STATUS.pending;
                this.currentWriterIndexRecord.writeCompleteTime = new Date();
                this.saveIndexFile();
                logger.info((Object)("Adding file to queue. queueName=" + this.queueProvider.getName() + ", fileName=" + this.currentWriterIndexRecord.filePath));
                this.indexQueue.add(this.currentWriterIndexRecord);
                this.currentWriterIndexRecord = null;
            }
        }
    }

    void loadIndexFile() throws IOException {
        String line;
        logger.info((Object)("Loading index file. fileName=" + this.indexFile.getPath()));
        BufferedReader br = new BufferedReader(new FileReader(this.indexFile));
        this.indexRecords.clear();
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            AuditIndexRecord record = (AuditIndexRecord)this.gson.fromJson(line, AuditIndexRecord.class);
            this.indexRecords.add(record);
        }
        br.close();
    }

    synchronized void printIndex() {
        logger.info((Object)"INDEX printIndex() ==== START");
        for (AuditIndexRecord record : this.indexRecords) {
            logger.info((Object)("INDEX=" + record + ", isFileExist=" + new File(record.filePath).exists()));
        }
        logger.info((Object)"INDEX printIndex() ==== END");
    }

    synchronized void removeIndexRecord(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        Iterator<AuditIndexRecord> iter = this.indexRecords.iterator();
        while (iter.hasNext()) {
            AuditIndexRecord record = iter.next();
            if (!record.id.equals(indexRecord.id)) continue;
            logger.info((Object)("Removing file from index. file=" + record.filePath + ", queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
            iter.remove();
            this.appendToDoneFile(record);
        }
        this.saveIndexFile();
        if (this.indexRecords.size() == 0) {
            this.isPending = false;
        }
    }

    synchronized void saveIndexFile() throws FileNotFoundException, IOException {
        PrintWriter out = new PrintWriter(this.indexFile);
        for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
            out.println(this.gson.toJson((Object)auditIndexRecord));
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendToDoneFile(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        block9: {
            logger.info((Object)("Moving to done file. " + indexRecord.filePath + ", queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
            String line = this.gson.toJson((Object)indexRecord);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.indexDoneFile, true)));
            out.println(line);
            out.flush();
            out.close();
            File logFile = null;
            File archiveFile = null;
            try {
                logFile = new File(indexRecord.filePath);
                String fileName = logFile.getName();
                archiveFile = new File(this.archiveFolder, fileName);
                logger.info((Object)("Moving logFile " + logFile + " to " + archiveFile));
                logFile.renameTo(archiveFile);
            }
            catch (Throwable t) {
                logger.error((Object)("Error moving log file to archive folder. logFile=" + logFile + ", archiveFile=" + archiveFile), t);
            }
            archiveFile = null;
            try {
                File[] logFiles = this.archiveFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().toLowerCase().endsWith(".log");
                    }
                });
                if (logFiles.length <= this.maxArchiveFiles) break block9;
                int filesToDelete = logFiles.length - this.maxArchiveFiles;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        AuditIndexRecord record = (AuditIndexRecord)this.gson.fromJson(line, AuditIndexRecord.class);
                        logFile = new File(record.filePath);
                        String fileName = logFile.getName();
                        archiveFile = new File(this.archiveFolder, fileName);
                        if (!archiveFile.exists()) continue;
                        logger.info((Object)("Deleting archive file " + archiveFile));
                        boolean ret = archiveFile.delete();
                        if (!ret) {
                            logger.error((Object)("Error deleting archive file. archiveFile=" + archiveFile));
                        }
                        if (++filesDeletedCount < filesToDelete) continue;
                        logger.info((Object)("Deleted " + filesDeletedCount + " files"));
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)("Error deleting older archive file. archiveFile=" + archiveFile), t);
            }
        }
    }

    void logError(String msg) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            logger.error((Object)msg);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    @Override
    public void run() {
        try {
            if (MiscUtil.getUGILoginUser() != null) {
                PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        AuditFileSpool.this.runDoAs();
                        return null;
                    }
                };
                logger.info((Object)("Running fileSpool " + this.consumerProvider.getName() + " as user " + MiscUtil.getUGILoginUser()));
                MiscUtil.getUGILoginUser().doAs((PrivilegedAction)action);
            } else {
                this.runDoAs();
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)("Exited thread without abnormaly. queue=" + this.consumerProvider.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDoAs() {
        block8: while (true) {
            try {
                while (true) {
                    if (this.isDestDown) {
                        logger.info((Object)("Destination is down. sleeping for " + this.retryDestinationMS + " milli seconds. indexQueue=" + this.indexQueue.size() + ", queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.currentConsumerIndexRecord == null) {
                        this.currentConsumerIndexRecord = this.indexQueue.poll(this.retryDestinationMS, TimeUnit.MILLISECONDS);
                    } else {
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.isDrain) break block8;
                    if (this.currentConsumerIndexRecord == null) {
                        this.closeFileIfNeeded();
                        continue;
                    }
                    boolean isRemoveIndex = false;
                    File consumerFile = new File(this.currentConsumerIndexRecord.filePath);
                    if (!consumerFile.exists()) {
                        logger.error((Object)("Consumer file=" + consumerFile.getPath() + " not found."));
                        this.printIndex();
                        isRemoveIndex = true;
                    } else {
                        try (BufferedReader br = new BufferedReader(new FileReader(this.currentConsumerIndexRecord.filePath));){
                            boolean ret;
                            String line;
                            int startLine = this.currentConsumerIndexRecord.linePosition;
                            int currLine = 0;
                            ArrayList<String> lines = new ArrayList<String>();
                            while ((line = br.readLine()) != null) {
                                if (++currLine < startLine) continue;
                                lines.add(line);
                                if (lines.size() != this.queueProvider.getMaxBatchSize()) continue;
                                ret = this.sendEvent(lines, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                lines.clear();
                            }
                            if (lines.size() > 0) {
                                ret = this.sendEvent(lines, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                lines.clear();
                            }
                            logger.info((Object)("Done reading file. file=" + this.currentConsumerIndexRecord.filePath + ", queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
                            this.currentConsumerIndexRecord.status = SPOOL_FILE_STATUS.done;
                            this.currentConsumerIndexRecord.doneCompleteTime = new Date();
                            this.currentConsumerIndexRecord.lastAttempt = true;
                            isRemoveIndex = true;
                        }
                    }
                    if (!isRemoveIndex) continue;
                    this.removeIndexRecord(this.currentConsumerIndexRecord);
                    this.currentConsumerIndexRecord = null;
                    this.closeFileIfNeeded();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Caught exception in consumer thread. Shutdown might be in progress");
                continue;
            }
            catch (Throwable t) {
                logger.error((Object)"Exception in destination writing thread.", t);
                continue;
            }
            break;
        }
        logger.info((Object)("Exiting file spooler. provider=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
    }

    private boolean sendEvent(List<String> lines, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        try {
            ret = this.consumerProvider.logJSON(lines);
            if (!ret) {
                this.logError("Error sending logs to consumer. provider=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName());
            } else {
                indexRecord.linePosition = currLine;
                indexRecord.status = SPOOL_FILE_STATUS.read_inprogress;
                indexRecord.lastSuccessTime = new Date();
                indexRecord.lastAttempt = true;
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info((Object)("Destination up now. " + indexRecord.filePath + ", queueName=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName()));
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error while sending logs to consumer. provider=" + this.queueProvider.getName() + ", consumer=" + this.consumerProvider.getName() + ", log=" + lines), t);
        }
        return ret;
    }

    class AuditFileSpoolAttempt {
        Date attemptTime;
        String status;

        AuditFileSpoolAttempt() {
        }
    }

    class AuditIndexRecord {
        String id;
        String filePath;
        int linePosition = 0;
        SPOOL_FILE_STATUS status = SPOOL_FILE_STATUS.write_inprogress;
        Date fileCreateTime;
        Date writeCompleteTime;
        Date doneCompleteTime;
        Date lastSuccessTime;
        Date lastFailedTime;
        int failedAttemptCount = 0;
        boolean lastAttempt = false;

        AuditIndexRecord() {
        }

        public String toString() {
            return "AuditIndexRecord [id=" + this.id + ", filePath=" + this.filePath + ", linePosition=" + this.linePosition + ", status=" + (Object)((Object)this.status) + ", fileCreateTime=" + this.fileCreateTime + ", writeCompleteTime=" + this.writeCompleteTime + ", doneCompleteTime=" + this.doneCompleteTime + ", lastSuccessTime=" + this.lastSuccessTime + ", lastFailedTime=" + this.lastFailedTime + ", failedAttemptCount=" + this.failedAttemptCount + ", lastAttempt=" + this.lastAttempt + "]";
        }
    }

    public static enum SPOOL_FILE_STATUS {
        pending,
        write_inprogress,
        read_inprogress,
        done;

    }
}

