/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.dao.DaoManager;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.entity.AuthzAuditEventDbObj;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;

public class DBAuditDestination
extends AuditDestination {
    private static final Log logger = LogFactory.getLog(DBAuditDestination.class);
    public static final String PROP_DB_JDBC_DRIVER = "jdbc.driver";
    public static final String PROP_DB_JDBC_URL = "jdbc.url";
    public static final String PROP_DB_USER = "user";
    public static final String PROP_DB_PASSWORD = "password";
    public static final String PROP_DB_PASSWORD_ALIAS = "password.alias";
    private EntityManagerFactory entityManagerFactory;
    private DaoManager daoManager;
    private String jdbcDriver = null;
    private String jdbcURL = null;
    private String dbUser = null;
    private String dbPasswordAlias = "auditDBCred";

    public DBAuditDestination() {
        logger.info((Object)"DBAuditDestination() called");
    }

    @Override
    public void init(Properties props, String propPrefix) {
        logger.info((Object)"init() called");
        super.init(props, propPrefix);
        this.connect();
        AuthzAuditEventDbObj.init(props);
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        boolean retValue = false;
        this.logStatusIfRequired();
        this.addTotalCount(events.size());
        if (this.beginTransaction()) {
            boolean isFailed = false;
            for (AuditEventBase event : events) {
                try {
                    event.persist(this.daoManager);
                }
                catch (Throwable t) {
                    logger.error((Object)("Error persisting data. event=" + event), t);
                    isFailed = true;
                    break;
                }
            }
            if (isFailed) {
                retValue = false;
                this.rollbackTransaction();
            } else {
                retValue = this.commitTransaction();
            }
        }
        if (retValue) {
            this.addSuccessCount(events.size());
        } else {
            this.addDeferredCount(events.size());
        }
        return retValue;
    }

    @Override
    public void stop() {
        this.cleanUp();
        super.stop();
    }

    protected void connect() {
        if (this.isDbConnected()) {
            return;
        }
        try {
            this.jdbcDriver = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_DB_JDBC_DRIVER);
            this.jdbcURL = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_DB_JDBC_URL);
            this.dbUser = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_DB_USER);
            String dbPasswordFromProp = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_DB_PASSWORD);
            String tmpAlias = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_DB_PASSWORD_ALIAS);
            this.dbPasswordAlias = tmpAlias != null ? tmpAlias : this.dbPasswordAlias;
            String credFile = MiscUtil.getStringProperty(this.props, "xasecure.audit.credential.provider.file");
            if (this.jdbcDriver == null || this.jdbcDriver.isEmpty()) {
                logger.fatal((Object)("JDBC driver not provided. Set property name " + this.propPrefix + "." + PROP_DB_JDBC_DRIVER));
                return;
            }
            if (this.jdbcURL == null || this.jdbcURL.isEmpty()) {
                logger.fatal((Object)("JDBC URL not provided. Set property name " + this.propPrefix + "." + PROP_DB_JDBC_URL));
                return;
            }
            if (this.dbUser == null || this.dbUser.isEmpty()) {
                logger.fatal((Object)("DB user not provided. Set property name " + this.propPrefix + "." + PROP_DB_USER));
                return;
            }
            String dbPassword = MiscUtil.getCredentialString(credFile, this.dbPasswordAlias);
            if (dbPassword == null || dbPassword.isEmpty()) {
                dbPassword = dbPasswordFromProp;
            }
            if (dbPassword == null || dbPassword.isEmpty()) {
                logger.warn((Object)"DB password not provided. Will assume it is empty and continue");
            }
            logger.info((Object)("JDBC Driver=" + this.jdbcDriver + ", JDBC URL=" + this.jdbcURL + ", dbUser=" + this.dbUser + ", passwordAlias=" + this.dbPasswordAlias + ", credFile=" + credFile + ", usingPassword=" + (dbPassword == null ? "no" : "yes")));
            HashMap<String, String> dbProperties = new HashMap<String, String>();
            dbProperties.put("javax.persistence.jdbc.driver", this.jdbcDriver);
            dbProperties.put("javax.persistence.jdbc.url", this.jdbcURL);
            dbProperties.put("javax.persistence.jdbc.user", this.dbUser);
            if (dbPassword != null) {
                dbProperties.put("javax.persistence.jdbc.password", dbPassword);
            }
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"xa_server", dbProperties);
            logger.info((Object)("entityManagerFactory=" + this.entityManagerFactory));
            this.daoManager = new DaoManager();
            this.daoManager.setEntityManagerFactory(this.entityManagerFactory);
            if (this.daoManager.getEntityManager() == null) {
                logger.error((Object)("Error connecting audit database. EntityManager is null. dbURL=" + this.jdbcURL + ", dbUser=" + this.dbUser));
            } else {
                logger.info((Object)("Connected to audit database. dbURL=" + this.jdbcURL + ", dbUser=" + this.dbUser));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error connecting audit database. dbURL=" + this.jdbcURL + ", dbUser=" + this.dbUser), t);
        }
    }

    private synchronized void cleanUp() {
        logger.info((Object)"DBAuditDestination: cleanUp()");
        try {
            if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
                this.entityManagerFactory.close();
            }
        }
        catch (Exception excp) {
            logger.error((Object)"DBAuditDestination.cleanUp(): failed", (Throwable)excp);
        }
        finally {
            this.entityManagerFactory = null;
            this.daoManager = null;
        }
        this.logStatus();
    }

    private EntityManager getEntityManager() {
        DaoManager daoMgr = this.daoManager;
        if (daoMgr != null) {
            try {
                return daoMgr.getEntityManager();
            }
            catch (Exception excp) {
                logger.error((Object)"DBAuditDestination.getEntityManager(): failed", (Throwable)excp);
                this.cleanUp();
            }
        }
        return null;
    }

    private boolean isDbConnected() {
        EntityManager em = this.getEntityManager();
        return em != null && em.isOpen();
    }

    private void clearEntityManager() {
        try {
            EntityManager em = this.getEntityManager();
            if (em != null) {
                em.clear();
            }
        }
        catch (Exception excp) {
            logger.warn((Object)"DBAuditDestination.clearEntityManager(): failed", (Throwable)excp);
        }
    }

    private EntityTransaction getTransaction() {
        EntityManager em;
        if (!this.isDbConnected()) {
            this.connect();
        }
        return (em = this.getEntityManager()) != null ? em.getTransaction() : null;
    }

    private boolean beginTransaction() {
        EntityTransaction trx = this.getTransaction();
        if (trx != null && !trx.isActive()) {
            trx.begin();
        }
        if (trx == null) {
            logger.warn((Object)"DBAuditDestination.beginTransaction(): trx is null");
        }
        return trx != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitTransaction() {
        boolean ret;
        block6: {
            ret = false;
            EntityTransaction trx = null;
            try {
                trx = this.getTransaction();
                if (trx != null && trx.isActive()) {
                    trx.commit();
                    ret = true;
                    break block6;
                }
                throw new Exception("trx is null or not active");
            }
            catch (Throwable excp) {
                logger.error((Object)"DBAuditDestination.commitTransaction(): failed", excp);
                this.cleanUp();
            }
            finally {
                this.clearEntityManager();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollbackTransaction() {
        boolean ret;
        block6: {
            ret = false;
            EntityTransaction trx = null;
            try {
                trx = this.getTransaction();
                if (trx != null && trx.isActive()) {
                    trx.rollback();
                    ret = true;
                    break block6;
                }
                throw new Exception("trx is null or not active");
            }
            catch (Throwable excp) {
                logger.error((Object)"DBAuditDestination.rollbackTransaction(): failed", excp);
                this.cleanUp();
            }
            finally {
                this.clearEntityManager();
            }
        }
        return ret;
    }
}

