/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.ranger.audit.destination.DBAuditDestination;
import org.apache.ranger.audit.destination.FileAuditDestination;
import org.apache.ranger.audit.destination.HDFSAuditDestination;
import org.apache.ranger.audit.destination.Log4JAuditDestination;
import org.apache.ranger.audit.destination.SolrAuditDestination;
import org.apache.ranger.audit.provider.AsyncAuditProvider;
import org.apache.ranger.audit.provider.AuditFileCacheProvider;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.DbAuditProvider;
import org.apache.ranger.audit.provider.DummyAuditProvider;
import org.apache.ranger.audit.provider.Log4jAuditProvider;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.provider.MultiDestAuditProvider;
import org.apache.ranger.audit.provider.hdfs.HdfsAuditProvider;
import org.apache.ranger.audit.provider.kafka.KafkaAuditProvider;
import org.apache.ranger.audit.provider.solr.SolrAuditProvider;
import org.apache.ranger.audit.queue.AuditAsyncQueue;
import org.apache.ranger.audit.queue.AuditBatchQueue;
import org.apache.ranger.audit.queue.AuditQueue;
import org.apache.ranger.audit.queue.AuditSummaryQueue;

public class AuditProviderFactory {
    private static final Log LOG = LogFactory.getLog(AuditProviderFactory.class);
    public static final String AUDIT_IS_ENABLED_PROP = "xasecure.audit.is.enabled";
    public static final String AUDIT_DB_IS_ENABLED_PROP = "xasecure.audit.db.is.enabled";
    public static final String AUDIT_HDFS_IS_ENABLED_PROP = "xasecure.audit.hdfs.is.enabled";
    public static final String AUDIT_LOG4J_IS_ENABLED_PROP = "xasecure.audit.log4j.is.enabled";
    public static final String AUDIT_KAFKA_IS_ENABLED_PROP = "xasecure.audit.kafka.is.enabled";
    public static final String AUDIT_SOLR_IS_ENABLED_PROP = "xasecure.audit.solr.is.enabled";
    public static final String AUDIT_DEST_BASE = "xasecure.audit.destination";
    public static final String AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC = "xasecure.audit.shutdown.hook.max.wait.seconds";
    public static final String AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP = "xasecure.audit.provider.filecache.is.enabled";
    public static final int AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC_DEFAULT = 30;
    public static final int AUDIT_ASYNC_MAX_QUEUE_SIZE_DEFAULT = 10240;
    public static final int AUDIT_ASYNC_MAX_FLUSH_INTERVAL_DEFAULT = 5000;
    private static final int RANGER_AUDIT_SHUTDOWN_HOOK_PRIORITY = 30;
    private static volatile AuditProviderFactory sFactory = null;
    private AuditHandler mProvider = null;
    private String componentAppType = "";
    private boolean mInitDone = false;
    private JVMShutdownHook jvmShutdownHook = null;

    private AuditProviderFactory() {
        LOG.info((Object)"AuditProviderFactory: creating..");
        this.mProvider = this.getDefaultProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditProviderFactory getInstance() {
        AuditProviderFactory ret = sFactory;
        if (ret != null) return ret;
        Class<AuditProviderFactory> clazz = AuditProviderFactory.class;
        synchronized (AuditProviderFactory.class) {
            ret = sFactory;
            if (ret != null) return ret;
            sFactory = new AuditProviderFactory();
            return sFactory;
        }
    }

    public static AuditHandler getAuditProvider() {
        return AuditProviderFactory.getInstance().getProvider();
    }

    public AuditHandler getProvider() {
        return this.mProvider;
    }

    public boolean isInitDone() {
        return this.mInitDone;
    }

    public void shutdown() {
        if (this.isInitDone() && this.jvmShutdownHook != null) {
            this.jvmShutdownHook.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void init(Properties props, String appType) {
        LOG.info((Object)"AuditProviderFactory: initializing..");
        if (this.mInitDone) {
            LOG.warn((Object)"AuditProviderFactory.init(): already initialized! Will try to re-initialize");
        }
        this.mInitDone = true;
        this.componentAppType = appType;
        MiscUtil.setApplicationType(appType);
        boolean isEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_ENABLED_PROP, false);
        boolean isAuditToDbEnabled = MiscUtil.getBooleanProperty(props, AUDIT_DB_IS_ENABLED_PROP, false);
        boolean isAuditToHdfsEnabled = MiscUtil.getBooleanProperty(props, AUDIT_HDFS_IS_ENABLED_PROP, false);
        boolean isAuditToLog4jEnabled = MiscUtil.getBooleanProperty(props, AUDIT_LOG4J_IS_ENABLED_PROP, false);
        boolean isAuditToKafkaEnabled = MiscUtil.getBooleanProperty(props, AUDIT_KAFKA_IS_ENABLED_PROP, false);
        boolean isAuditToSolrEnabled = MiscUtil.getBooleanProperty(props, AUDIT_SOLR_IS_ENABLED_PROP, false);
        boolean isAuditFileCacheProviderEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP, false);
        ArrayList<AuditHandler> providers = new ArrayList<AuditHandler>();
        for (Object object : props.keySet()) {
            LOG.info((Object)("AUDIT PROPERTY: " + object.toString() + "=" + props.getProperty(object.toString())));
        }
        ArrayList<String> destNameList = new ArrayList<String>();
        for (Object propNameObj : props.keySet()) {
            String value;
            String destName;
            List<String> splits;
            String propName = propNameObj.toString();
            if (!propName.startsWith(AUDIT_DEST_BASE) || (splits = MiscUtil.toArray(destName = propName.substring(AUDIT_DEST_BASE.length() + 1), ".")).size() > 1 || !(value = props.getProperty(propName)).equalsIgnoreCase("enable") && !value.equalsIgnoreCase("enabled") && !value.equalsIgnoreCase("true")) continue;
            destNameList.add(destName);
            LOG.info((Object)("Audit destination " + propName + " is set to " + value));
        }
        for (String destName : destNameList) {
            String destPropPrefix = "xasecure.audit.destination." + destName;
            AuditHandler destProvider = this.getProviderFromConfig(props, destPropPrefix, destName, null);
            if (destProvider == null) continue;
            destProvider.init(props, destPropPrefix);
            String queueName = MiscUtil.getStringProperty(props, destPropPrefix + "." + "queue");
            if (queueName == null || queueName.isEmpty()) {
                LOG.info((Object)(destPropPrefix + "." + "queue" + " is not set. Setting queue to batch for " + destName));
                queueName = "batch";
            }
            LOG.info((Object)("queue for " + destName + " is " + queueName));
            if (queueName != null && !queueName.isEmpty() && !queueName.equalsIgnoreCase("none")) {
                String queuePropPrefix = destPropPrefix + "." + queueName;
                AuditHandler queueProvider = this.getProviderFromConfig(props, queuePropPrefix, queueName, destProvider);
                if (queueProvider != null) {
                    if (queueProvider instanceof AuditQueue) {
                        AuditQueue qProvider = (AuditQueue)queueProvider;
                        qProvider.init(props, queuePropPrefix);
                        providers.add(queueProvider);
                        continue;
                    }
                    LOG.fatal((Object)("Provider queue doesn't extend AuditQueue. Destination=" + destName + " can't be created. queueName=" + queueName));
                    continue;
                }
                LOG.fatal((Object)("Queue provider for destination " + destName + " can't be created. queueName=" + queueName));
                continue;
            }
            LOG.info((Object)("Audit destination " + destProvider.getName() + " added to provider list"));
            providers.add(destProvider);
        }
        if (providers.size() > 0) {
            void var12_19;
            LOG.info((Object)"Using v3 audit configuration");
            AuditHandler auditHandler = (AuditHandler)providers.get(0);
            if (providers.size() > 1) {
                LOG.info((Object)("MultiDestAuditProvider is used. Destination count=" + providers.size()));
                MultiDestAuditProvider multiDestProvider = new MultiDestAuditProvider();
                multiDestProvider.init(props);
                multiDestProvider.addAuditProviders(providers);
                MultiDestAuditProvider multiDestAuditProvider = multiDestProvider;
            }
            String propPrefix = "xasecure.audit.provider";
            boolean summaryEnabled = MiscUtil.getBooleanProperty(props, propPrefix + ".summary.enabled", false);
            AuditSummaryQueue summaryQueue = null;
            if (summaryEnabled) {
                void var12_17;
                LOG.info((Object)"AuditSummaryQueue is enabled");
                summaryQueue = new AuditSummaryQueue((AuditHandler)var12_17);
                summaryQueue.init(props, propPrefix);
                AuditSummaryQueue auditSummaryQueue = summaryQueue;
            } else {
                LOG.info((Object)"AuditSummaryQueue is disabled");
            }
            if (!isAuditFileCacheProviderEnabled) {
                AuditAsyncQueue asyncQueue = new AuditAsyncQueue((AuditHandler)var12_19);
                propPrefix = "xasecure.audit.provider.async";
                asyncQueue.init(props, propPrefix);
                asyncQueue.setParentPath(this.componentAppType);
                this.mProvider = asyncQueue;
                LOG.info((Object)("Starting audit queue " + this.mProvider.getName()));
                this.mProvider.start();
            } else {
                AuditFileCacheProvider auditFileCacheProvider = new AuditFileCacheProvider((AuditHandler)var12_19);
                propPrefix = "xasecure.audit.provider.filecache";
                auditFileCacheProvider.init(props, propPrefix);
                auditFileCacheProvider.setParentPath(this.componentAppType);
                this.mProvider = auditFileCacheProvider;
                LOG.info((Object)("Starting Audit File Cache Provider " + this.mProvider.getName()));
                this.mProvider.start();
            }
        } else {
            AsyncAuditProvider asyncProvider;
            LOG.info((Object)"No v3 audit configuration found. Trying v2 audit configurations");
            if (!(isEnabled && (isAuditToDbEnabled || isAuditToHdfsEnabled || isAuditToKafkaEnabled || isAuditToLog4jEnabled || isAuditToSolrEnabled || providers.size() == 0))) {
                LOG.info((Object)"AuditProviderFactory: Audit not enabled..");
                this.mProvider = this.getDefaultProvider();
                return;
            }
            if (isAuditToDbEnabled) {
                LOG.info((Object)"DbAuditProvider is enabled");
                DbAuditProvider dbAuditProvider = new DbAuditProvider();
                boolean isAuditToDbAsync = MiscUtil.getBooleanProperty(props, "xasecure.audit.db.is.async", false);
                if (isAuditToDbAsync) {
                    int maxQueueSize = MiscUtil.getIntProperty(props, "xasecure.audit.db.async.max.queue.size", 10240);
                    int maxFlushInterval = MiscUtil.getIntProperty(props, "xasecure.audit.db.async.max.flush.interval.ms", 5000);
                    asyncProvider = new AsyncAuditProvider("DbAuditProvider", maxQueueSize, maxFlushInterval, dbAuditProvider);
                    providers.add(asyncProvider);
                } else {
                    providers.add(dbAuditProvider);
                }
            }
            if (isAuditToHdfsEnabled) {
                LOG.info((Object)"HdfsAuditProvider is enabled");
                HdfsAuditProvider hdfsAuditProvider = new HdfsAuditProvider();
                boolean isAuditToHdfsAsync = MiscUtil.getBooleanProperty(props, "xasecure.audit.hdfs.is.async", false);
                if (isAuditToHdfsAsync) {
                    int maxQueueSize = MiscUtil.getIntProperty(props, "xasecure.audit.hdfs.async.max.queue.size", 10240);
                    int maxFlushInterval = MiscUtil.getIntProperty(props, "xasecure.audit.hdfs.async.max.flush.interval.ms", 5000);
                    asyncProvider = new AsyncAuditProvider("HdfsAuditProvider", maxQueueSize, maxFlushInterval, hdfsAuditProvider);
                    providers.add(asyncProvider);
                } else {
                    providers.add(hdfsAuditProvider);
                }
            }
            if (isAuditToKafkaEnabled) {
                LOG.info((Object)"KafkaAuditProvider is enabled");
                KafkaAuditProvider kafkaAuditProvider = new KafkaAuditProvider();
                kafkaAuditProvider.init(props);
                if (kafkaAuditProvider.isAsync()) {
                    AsyncAuditProvider asyncProvider2 = new AsyncAuditProvider("MyKafkaAuditProvider", 1000, 1000, kafkaAuditProvider);
                    providers.add(asyncProvider2);
                } else {
                    providers.add(kafkaAuditProvider);
                }
            }
            if (isAuditToSolrEnabled) {
                LOG.info((Object)"SolrAuditProvider is enabled");
                SolrAuditProvider solrAuditProvider = new SolrAuditProvider();
                solrAuditProvider.init(props);
                if (solrAuditProvider.isAsync()) {
                    AsyncAuditProvider asyncProvider3 = new AsyncAuditProvider("MySolrAuditProvider", 1000, 1000, solrAuditProvider);
                    providers.add(asyncProvider3);
                } else {
                    providers.add(solrAuditProvider);
                }
            }
            if (isAuditToLog4jEnabled) {
                Log4jAuditProvider log4jAuditProvider = new Log4jAuditProvider();
                boolean isAuditToLog4jAsync = MiscUtil.getBooleanProperty(props, "xasecure.audit.log4j.is.async", false);
                if (isAuditToLog4jAsync) {
                    int maxQueueSize = MiscUtil.getIntProperty(props, "xasecure.audit.log4j.async.max.queue.size", 10240);
                    int maxFlushInterval = MiscUtil.getIntProperty(props, "xasecure.audit.log4j.async.max.flush.interval.ms", 5000);
                    asyncProvider = new AsyncAuditProvider("Log4jAuditProvider", maxQueueSize, maxFlushInterval, log4jAuditProvider);
                    providers.add(asyncProvider);
                } else {
                    providers.add(log4jAuditProvider);
                }
            }
            if (providers.size() == 0) {
                this.mProvider = this.getDefaultProvider();
            } else if (providers.size() == 1) {
                this.mProvider = (AuditHandler)providers.get(0);
            } else {
                MultiDestAuditProvider multiDestAuditProvider = new MultiDestAuditProvider();
                multiDestAuditProvider.addAuditProviders(providers);
                this.mProvider = multiDestAuditProvider;
            }
            this.mProvider.init(props);
            this.mProvider.start();
        }
        this.installJvmSutdownHook(props);
    }

    private AuditHandler getProviderFromConfig(Properties props, String propPrefix, String providerName, AuditHandler consumer) {
        AuditHandler provider;
        block22: {
            provider = null;
            String className = MiscUtil.getStringProperty(props, propPrefix + "." + "classname");
            if (className != null && !className.isEmpty()) {
                try {
                    Class<AuditQueue> handlerClass = Class.forName(className);
                    if (handlerClass.isAssignableFrom(AuditQueue.class)) {
                        handlerClass.getDeclaredConstructor(AuditHandler.class).newInstance(consumer);
                        break block22;
                    }
                    provider = (AuditHandler)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Can't instantiate audit class for providerName=" + providerName + ", className=" + className + ", propertyPrefix=" + propPrefix), (Throwable)e);
                }
            } else if (providerName.equals("file")) {
                provider = new FileAuditDestination();
            } else if (providerName.equalsIgnoreCase("hdfs")) {
                provider = new HDFSAuditDestination();
            } else if (providerName.equals("solr")) {
                provider = new SolrAuditDestination();
            } else if (providerName.equals("kafka")) {
                provider = new KafkaAuditProvider();
            } else if (providerName.equals("db")) {
                provider = new DBAuditDestination();
            } else if (providerName.equals("log4j")) {
                provider = new Log4JAuditDestination();
            } else if (providerName.equals("batch")) {
                provider = new AuditBatchQueue(consumer);
            } else if (providerName.equals("async")) {
                provider = new AuditAsyncQueue(consumer);
            } else {
                LOG.error((Object)("Provider name doesn't have any class associated with it. providerName=" + providerName + ", propertyPrefix=" + propPrefix));
            }
        }
        if (provider != null && provider instanceof AuditQueue && consumer == null) {
            LOG.fatal((Object)("consumer can't be null for AuditQueue. queue=" + provider.getName() + ", propertyPrefix=" + propPrefix));
            provider = null;
        }
        return provider;
    }

    private AuditHandler getDefaultProvider() {
        return new DummyAuditProvider();
    }

    private void installJvmSutdownHook(Properties props) {
        int shutdownHookMaxWaitSeconds = MiscUtil.getIntProperty(props, AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC, 30);
        this.jvmShutdownHook = new JVMShutdownHook(this.mProvider, shutdownHookMaxWaitSeconds);
        ShutdownHookManager.get().addShutdownHook((Runnable)this.jvmShutdownHook, 30);
    }

    private static class JVMShutdownHook
    extends Thread {
        final Semaphore startCleanup = new Semaphore(0);
        final Semaphore doneCleanup = new Semaphore(0);
        final Thread cleanupThread;
        final int maxWait;
        final AtomicBoolean done = new AtomicBoolean(false);

        public JVMShutdownHook(AuditHandler provider, int maxWait) {
            this.maxWait = maxWait;
            RangerAsyncAuditCleanup runnable = new RangerAsyncAuditCleanup(provider, this.startCleanup, this.doneCleanup);
            this.cleanupThread = new Thread((Runnable)runnable, "Ranger async Audit cleanup");
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }

        @Override
        public void run() {
            if (!this.done.compareAndSet(false, true)) {
                LOG.info((Object)"==> JVMShutdownHook.run() already done by another thread");
                return;
            }
            LOG.info((Object)"==> JVMShutdownHook.run()");
            LOG.info((Object)"JVMShutdownHook: Signalling async audit cleanup to start.");
            this.startCleanup.release();
            try {
                Long start = System.currentTimeMillis();
                LOG.info((Object)("JVMShutdownHook: Waiting up to " + this.maxWait + " seconds for audit cleanup to finish."));
                boolean cleanupFinishedInTime = this.doneCleanup.tryAcquire(this.maxWait, TimeUnit.SECONDS);
                if (cleanupFinishedInTime) {
                    LOG.info((Object)("JVMShutdownHook: Audit cleanup finished after " + (System.currentTimeMillis() - start) + " milli seconds"));
                } else {
                    LOG.warn((Object)("JVMShutdownHook: could not detect finishing of audit cleanup even after waiting for " + this.maxWait + " seconds!"));
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)"JVMShutdownHook: Interrupted while waiting for completion of Async executor!", (Throwable)e);
            }
            LOG.info((Object)"JVMShutdownHook: Interrupting ranger async audit cleanup thread");
            this.cleanupThread.interrupt();
            LOG.info((Object)"<== JVMShutdownHook.run()");
        }
    }

    private static class RangerAsyncAuditCleanup
    implements Runnable {
        final Semaphore startCleanup;
        final Semaphore doneCleanup;
        final AuditHandler mProvider;

        RangerAsyncAuditCleanup(AuditHandler provider, Semaphore startCleanup, Semaphore doneCleanup) {
            this.startCleanup = startCleanup;
            this.doneCleanup = doneCleanup;
            this.mProvider = provider;
        }

        @Override
        public void run() {
            while (true) {
                LOG.info((Object)"RangerAsyncAuditCleanup: Waiting to audit cleanup start signal");
                try {
                    this.startCleanup.acquire();
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"RangerAsyncAuditCleanup: Interrupted while waiting for audit startCleanup signal!  Exiting the thread...", (Throwable)e);
                    break;
                }
                LOG.info((Object)"RangerAsyncAuditCleanup: Starting cleanup");
                this.mProvider.waitToComplete();
                this.mProvider.stop();
                this.doneCleanup.release();
                LOG.info((Object)"RangerAsyncAuditCleanup: Done cleanup");
            }
        }
    }
}

