/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.queue.AuditQueue;

public class AuditAsyncQueue
extends AuditQueue
implements Runnable {
    private static final Log logger = LogFactory.getLog(AuditAsyncQueue.class);
    LinkedBlockingQueue<AuditEventBase> queue = new LinkedBlockingQueue();
    Thread consumerThread = null;
    static final int MAX_DRAIN = 1000;
    static int threadCount = 0;
    static final String DEFAULT_NAME = "async";

    public AuditAsyncQueue(AuditHandler consumer) {
        super(consumer);
        this.setName(DEFAULT_NAME);
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (this.queue.size() >= this.getMaxQueueSize()) {
            return false;
        }
        this.queue.add(event);
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.log(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public void start() {
        if (this.consumer != null) {
            this.consumer.start();
        } else {
            logger.error((Object)("consumer is not set. Nothing will be sent to any consumer. name=" + this.getName()));
        }
        this.consumerThread = new Thread((Runnable)this, this.getClass().getName() + threadCount++);
        this.consumerThread.setDaemon(true);
        this.consumerThread.start();
    }

    @Override
    public void stop() {
        logger.info((Object)("Stop called. name=" + this.getName()));
        this.setDrain(true);
        try {
            if (this.consumerThread != null) {
                logger.info((Object)("Interrupting consumerThread. name=" + this.getName() + ", consumer=" + (this.consumer == null ? null : this.consumer.getName())));
                this.consumerThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.consumerThread = null;
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.fatal((Object)("Exited thread abnormaly. queue=" + this.getName()), t);
        }
    }

    public void runLogAudit() {
        while (true) {
            try {
                AuditEventBase event = null;
                event = !this.isDrain() ? this.queue.take() : this.queue.poll();
                if (event != null) {
                    ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>();
                    eventList.add(event);
                    this.queue.drainTo(eventList, 999);
                    this.consumer.log(eventList);
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Caught exception in consumer thread. Shutdown might be in progress");
            }
            catch (Throwable t) {
                logger.error((Object)"Caught error during processing request.", t);
            }
            if (!this.isDrain()) continue;
            if (this.queue.isEmpty()) break;
            if (!this.isDrainMaxTimeElapsed()) continue;
            logger.warn((Object)("Exiting polling loop because max time allowed reached. name=" + this.getName() + ", waited for " + (this.stopTime - System.currentTimeMillis()) + " ms"));
        }
        logger.info((Object)("Exiting polling loop. name=" + this.getName()));
        try {
            logger.info((Object)("Calling to stop consumer. name=" + this.getName() + ", consumer.name=" + this.consumer.getName()));
            this.consumer.stop();
        }
        catch (Throwable t) {
            logger.error((Object)"Error while calling stop on consumer.", t);
        }
        logger.info((Object)("Exiting consumerThread.run() method. name=" + this.getName()));
    }
}

