/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.security.KrbPasswordSaverLoginModule;
import org.apache.hadoop.security.authentication.util.KerberosUtil;

class SecureClientLoginConfiguration
extends Configuration {
    private Map<String, String> kerberosOptions = new HashMap<String, String>();
    private boolean usePassword = false;

    public SecureClientLoginConfiguration(boolean useKeyTab, String principal, String credential) {
        this.kerberosOptions.put("principal", principal);
        this.kerberosOptions.put("debug", "false");
        if (useKeyTab) {
            this.kerberosOptions.put("useKeyTab", "true");
            this.kerberosOptions.put("keyTab", credential);
            this.kerberosOptions.put("doNotPrompt", "true");
        } else {
            this.usePassword = true;
            this.kerberosOptions.put("useKeyTab", "false");
            this.kerberosOptions.put("javax.security.auth.login.name", principal);
            this.kerberosOptions.put("javax.security.auth.login.password", credential);
            this.kerberosOptions.put("doNotPrompt", "false");
            this.kerberosOptions.put("useFirstPass", "true");
            this.kerberosOptions.put("tryFirstPass", "false");
        }
        this.kerberosOptions.put("storeKey", "true");
        this.kerberosOptions.put("refreshKrb5Config", "true");
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        AppConfigurationEntry KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.kerberosOptions);
        if (this.usePassword) {
            AppConfigurationEntry KERBEROS_PWD_SAVER = new AppConfigurationEntry(KrbPasswordSaverLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.kerberosOptions);
            return new AppConfigurationEntry[]{KERBEROS_PWD_SAVER, KEYTAB_KERBEROS_LOGIN};
        }
        return new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
    }
}

