/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;

public class RangerServiceValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerServiceValidator.class);

    public RangerServiceValidator(ServiceStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerService service, RangerValidator.Action action) throws Exception {
        String message;
        boolean valid;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerServiceValidator.validate(%s, %s)", new Object[]{service, action}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(service, action, failures);
            message = "";
            try {
                if (valid) break block5;
                message = this.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerServiceValidator.validate(%s, %s): %s, reason[%s]", new Object[]{service, action, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceValidator.validate(%s, %s): %s, reason[%s]", new Object[]{service, action, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceValidator.isValid(" + id + ")"));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[]{action})).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            valid = false;
        } else if (this.getService(id) == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No service found for id[" + id + "]! ok!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceValidator.isValid(" + id + "): " + valid));
        }
        return valid;
    }

    boolean isValid(RangerService service, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceValidator.isValid(" + service + ")"));
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerService, ...) is only supported for CREATE/UPDATE");
        }
        boolean valid = true;
        if (service == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_NULL_SERVICE_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().field("service").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
            valid = false;
        } else {
            RangerService maybeTagService;
            String tagServiceName;
            Set<String> inputParameters;
            Set<String> reqiredParameters;
            Sets.SetView missingParameters;
            ValidationErrorCode error;
            Long id = service.getId();
            if (action == RangerValidator.Action.UPDATE) {
                ValidationErrorCode error2;
                if (id == null) {
                    error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_EMPTY_SERVICE_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(new Object[0])).build());
                    valid = false;
                } else if (this.getService(id) == null) {
                    error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(id)).build());
                    valid = false;
                }
            }
            String name = service.getName();
            boolean nameSpecified = StringUtils.isNotBlank((String)name);
            RangerServiceDef serviceDef = null;
            if (!nameSpecified) {
                ValidationErrorCode error3 = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_NAME;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().errorCode(error3.getErrorCode()).becauseOf(error3.getMessage(name)).build());
                valid = false;
            } else {
                ValidationErrorCode error4;
                RangerService otherService = this.getService(name);
                if (otherService != null && action == RangerValidator.Action.CREATE) {
                    error4 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SERVICE_NAME_CONFICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("name").isSemanticallyIncorrect().errorCode(error4.getErrorCode()).becauseOf(error4.getMessage(name)).build());
                    valid = false;
                } else if (otherService != null && otherService.getId() != null && !otherService.getId().equals(id)) {
                    error4 = ValidationErrorCode.SERVICE_VALIDATION_ERR_ID_NAME_CONFLICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("id/name").isSemanticallyIncorrect().errorCode(error4.getErrorCode()).becauseOf(error4.getMessage(name, otherService.getId())).build());
                    valid = false;
                }
            }
            String type = service.getType();
            boolean typeSpecified = StringUtils.isNotBlank((String)type);
            if (!typeSpecified) {
                error = ValidationErrorCode.SERVICE_VALIDATION_ERR_MISSING_SERVICE_DEF;
                failures.add(new ValidationFailureDetailsBuilder().field("type").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(type)).build());
                valid = false;
            } else {
                serviceDef = this.getServiceDef(type);
                if (serviceDef == null) {
                    error = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("type").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(type)).build());
                    valid = false;
                }
            }
            if (nameSpecified && serviceDef != null && !(missingParameters = Sets.difference(reqiredParameters = this.getRequiredParameters(serviceDef), inputParameters = this.getServiceConfigParameters(service))).isEmpty()) {
                ValidationErrorCode error5 = ValidationErrorCode.SERVICE_VALIDATION_ERR_REQUIRED_PARM_MISSING;
                failures.add(new ValidationFailureDetailsBuilder().field("configuration").subField((String)missingParameters.iterator().next()).isMissing().errorCode(error5.getErrorCode()).becauseOf(error5.getMessage(missingParameters)).build());
                valid = false;
            }
            if (StringUtils.isNotBlank((String)(tagServiceName = service.getTagService())) && StringUtils.equals((String)type, (String)"tag")) {
                failures.add(new ValidationFailureDetailsBuilder().field("tag_service").isSemanticallyIncorrect().becauseOf("tag service cannot be part of any other service").build());
                valid = false;
            }
            boolean needToEnsureServiceType = false;
            if (action == RangerValidator.Action.UPDATE) {
                String otherTagServiceName;
                RangerService otherService = this.getService(name);
                String string = otherTagServiceName = otherService == null ? null : otherService.getTagService();
                if (StringUtils.isNotBlank((String)tagServiceName) && !StringUtils.equals((String)tagServiceName, (String)otherTagServiceName)) {
                    needToEnsureServiceType = true;
                }
            } else if (StringUtils.isNotBlank((String)tagServiceName)) {
                needToEnsureServiceType = true;
            }
            if (needToEnsureServiceType && ((maybeTagService = this.getService(tagServiceName)) == null || !StringUtils.equals((String)maybeTagService.getType(), (String)"tag"))) {
                failures.add(new ValidationFailureDetailsBuilder().field("tag_service").isSemanticallyIncorrect().becauseOf("tag service name does not refer to existing tag service:" + tagServiceName).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceValidator.isValid(" + service + "): " + valid));
        }
        return valid;
    }
}

