/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerAccessResult {
    private final String serviceName;
    private final RangerServiceDef serviceDef;
    private final RangerAccessRequest request;
    private boolean isAccessDetermined = false;
    private boolean isAllowed = false;
    private boolean isAuditedDetermined = false;
    private boolean isAudited = false;
    private long auditPolicyId = -1L;
    private long policyId = -1L;
    private long evaluatedPoliciesCount = 0L;
    private String reason = null;

    public RangerAccessResult(String serviceName, RangerServiceDef serviceDef, RangerAccessRequest request) {
        this.serviceName = serviceName;
        this.serviceDef = serviceDef;
        this.request = request;
        this.isAccessDetermined = false;
        this.isAllowed = false;
        this.isAuditedDetermined = false;
        this.isAudited = false;
        this.auditPolicyId = -1L;
        this.policyId = -1L;
        this.evaluatedPoliciesCount = 0L;
        this.reason = null;
    }

    public void setAccessResultFrom(RangerAccessResult other) {
        this.isAccessDetermined = other.getIsAccessDetermined();
        this.isAllowed = other.getIsAllowed();
        this.policyId = other.getPolicyId();
        this.evaluatedPoliciesCount = other.evaluatedPoliciesCount;
        this.reason = other.getReason();
    }

    public void setAuditResultFrom(RangerAccessResult other) {
        this.isAuditedDetermined = other.getIsAuditedDetermined();
        this.isAudited = other.getIsAudited();
        this.auditPolicyId = other.getAuditPolicyId();
        this.evaluatedPoliciesCount += other.getEvaluatedPoliciesCount();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public RangerAccessRequest getAccessRequest() {
        return this.request;
    }

    public boolean getIsAccessDetermined() {
        return this.isAccessDetermined;
    }

    public void setIsAccessDetermined(boolean value) {
        this.isAccessDetermined = value;
    }

    public boolean getIsAllowed() {
        return this.isAllowed;
    }

    public void setIsAllowed(boolean isAllowed) {
        if (!isAllowed) {
            this.setIsAccessDetermined(true);
        }
        this.isAllowed = isAllowed;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean getIsAuditedDetermined() {
        return this.isAuditedDetermined;
    }

    private void setIsAuditedDetermined(boolean value) {
        this.isAuditedDetermined = value;
    }

    public boolean getIsAudited() {
        return this.isAudited;
    }

    public void setIsAudited(boolean isAudited) {
        this.setIsAuditedDetermined(true);
        this.isAudited = isAudited;
    }

    public String getReason() {
        return this.reason;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public long getAuditPolicyId() {
        return this.auditPolicyId;
    }

    public long getEvaluatedPoliciesCount() {
        return this.evaluatedPoliciesCount;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    public void setAuditPolicyId(long policyId) {
        this.auditPolicyId = policyId;
    }

    public void incrementEvaluatedPoliciesCount() {
        ++this.evaluatedPoliciesCount;
    }

    public int getServiceType() {
        int ret = -1;
        if (this.serviceDef != null && this.serviceDef.getId() != null) {
            ret = this.serviceDef.getId().intValue();
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAccessResult={");
        sb.append("isAccessDetermined={").append(this.isAccessDetermined).append("} ");
        sb.append("isAllowed={").append(this.isAllowed).append("} ");
        sb.append("isAuditedDetermined={").append(this.isAuditedDetermined).append("} ");
        sb.append("isAudited={").append(this.isAudited).append("} ");
        sb.append("policyId={").append(this.policyId).append("} ");
        sb.append("auditPolicyId={").append(this.auditPolicyId).append("} ");
        sb.append("evaluatedPoliciesCount={").append(this.evaluatedPoliciesCount).append("} ");
        sb.append("reason={").append(this.reason).append("} ");
        sb.append("}");
        return sb;
    }
}

