/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerDataMaskResult;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerRowFilterResult;

public interface RangerPolicyEngine {
    public static final String GROUP_PUBLIC = "public";
    public static final String ANY_ACCESS = "_any";
    public static final String ADMIN_ACCESS = "_admin";
    public static final String AUDIT_ALL = "audit-all";
    public static final String AUDIT_NONE = "audit-none";
    public static final String AUDIT_DEFAULT = "audit-default";

    public String getServiceName();

    public RangerServiceDef getServiceDef();

    public long getPolicyVersion();

    public RangerAccessResult createAccessResult(RangerAccessRequest var1);

    public void preProcess(RangerAccessRequest var1);

    public void preProcess(Collection<RangerAccessRequest> var1);

    public RangerAccessResult isAccessAllowed(RangerAccessRequest var1, RangerAccessResultProcessor var2);

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> var1, RangerAccessResultProcessor var2);

    public RangerDataMaskResult evalDataMaskPolicies(RangerAccessRequest var1, RangerAccessResultProcessor var2);

    public RangerRowFilterResult evalRowFilterPolicies(RangerAccessRequest var1, RangerAccessResultProcessor var2);

    public boolean isAccessAllowed(RangerAccessResource var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> var1, String var2, Set<String> var3, String var4);

    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource var1);

    public List<RangerPolicy> getExactMatchPolicies(Map<String, RangerPolicy.RangerPolicyResource> var1);

    public List<RangerPolicy> getAllowedPolicies(String var1, Set<String> var2, String var3);

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest var1);

    public void reorderPolicyEvaluators();

    public boolean preCleanup();

    public void setUseForwardedIPAddress(boolean var1);

    public void setTrustedProxyAddresses(String[] var1);

    public void cleanup();
}

