/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveEndsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveEndsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;

public abstract class RangerAbstractResourceMatcher
implements RangerResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerAbstractResourceMatcher.class);
    public static final String WILDCARD_ASTERISK = "*";
    public static final String WILDCARDS = "*?";
    public static final String OPTIONS_SEP = ";";
    public static final String OPTION_NV_SEP = "=";
    public static final String OPTION_IGNORE_CASE = "ignoreCase";
    public static final String OPTION_WILD_CARD = "wildCard";
    protected RangerServiceDef.RangerResourceDef resourceDef = null;
    protected RangerPolicy.RangerPolicyResource policyResource = null;
    protected boolean optIgnoreCase = false;
    protected boolean optWildCard = false;
    protected List<String> policyValues = null;
    protected boolean policyIsExcludes = false;
    protected boolean isMatchAny = false;
    protected List<ResourceMatcher> resourceMatchers = null;

    @Override
    public void setResourceDef(RangerServiceDef.RangerResourceDef resourceDef) {
        this.resourceDef = resourceDef;
    }

    @Override
    public void setPolicyResource(RangerPolicy.RangerPolicyResource policyResource) {
        this.policyResource = policyResource;
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractResourceMatcher.init()");
        }
        this.optIgnoreCase = this.getBooleanOption(OPTION_IGNORE_CASE, true);
        this.optWildCard = this.getBooleanOption(OPTION_WILD_CARD, true);
        this.policyValues = new ArrayList<String>();
        boolean bl = this.policyIsExcludes = this.policyResource == null ? false : this.policyResource.getIsExcludes();
        if (this.policyResource != null && this.policyResource.getValues() != null) {
            for (String policyValue : this.policyResource.getValues()) {
                if (StringUtils.isEmpty((String)policyValue)) continue;
                this.policyValues.add(policyValue);
            }
        }
        this.resourceMatchers = this.buildResourceMatchers();
        this.isMatchAny = CollectionUtils.isEmpty(this.resourceMatchers);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAbstractResourceMatcher.init()");
        }
    }

    @Override
    public boolean isMatchAny() {
        return this.isMatchAny;
    }

    protected List<ResourceMatcher> buildResourceMatchers() {
        ArrayList<ResourceMatcher> ret = new ArrayList<ResourceMatcher>();
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher = this.getMatcher(policyValue);
            if (matcher == null) continue;
            if (matcher.isMatchAny()) {
                ret.clear();
                break;
            }
            ret.add(matcher);
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public boolean isCompleteMatch(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractResourceMatcher.isCompleteMatch(" + resource + ")"));
        }
        boolean ret = false;
        if (CollectionUtils.isEmpty(this.policyValues)) {
            ret = StringUtils.isEmpty((String)resource);
        } else if (this.policyValues.size() == 1) {
            String policyValue = this.policyValues.get(0);
            if (this.isMatchAny) {
                ret = StringUtils.containsOnly((String)resource, (String)WILDCARD_ASTERISK);
            } else {
                boolean bl = ret = this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
            }
            if (this.policyIsExcludes) {
                boolean bl = ret = !ret;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractResourceMatcher.isCompleteMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    public String getOption(String name) {
        Map<String, String> options;
        String ret = null;
        Map<String, String> map = options = this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
        if (options != null && name != null) {
            ret = options.get(name);
        }
        return ret;
    }

    public String getOption(String name, String defaultValue) {
        String ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public boolean getBooleanOption(String name, boolean defaultValue) {
        boolean ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Boolean.parseBoolean(val);
        }
        return ret;
    }

    public char getCharOption(String name, char defaultValue) {
        char ret = defaultValue;
        String val = this.getOption(name);
        if (!StringUtils.isEmpty((String)val)) {
            ret = val.charAt(0);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractResourceMatcher={");
        sb.append("resourceDef={");
        if (this.resourceDef != null) {
            this.resourceDef.toString(sb);
        }
        sb.append("} ");
        sb.append("policyResource={");
        if (this.policyResource != null) {
            this.policyResource.toString(sb);
        }
        sb.append("} ");
        sb.append("optIgnoreCase={").append(this.optIgnoreCase).append("} ");
        sb.append("optWildCard={").append(this.optWildCard).append("} ");
        sb.append("policyValues={");
        if (this.policyValues != null) {
            for (String string : this.policyValues) {
                sb.append(string).append(",");
            }
        }
        sb.append("} ");
        sb.append("policyIsExcludes={").append(this.policyIsExcludes).append("} ");
        sb.append("isMatchAny={").append(this.isMatchAny).append("} ");
        sb.append("options={");
        if (this.resourceDef != null && this.resourceDef.getMatcherOptions() != null) {
            for (Map.Entry entry : this.resourceDef.getMatcherOptions().entrySet()) {
                sb.append((String)entry.getKey()).append(OPTION_NV_SEP).append((String)entry.getValue()).append(OPTIONS_SEP);
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    boolean isAllValuesRequested(String resource) {
        boolean result;
        boolean bl = result = StringUtils.isEmpty((String)resource) || WILDCARD_ASTERISK.equals(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllValuesRequested(" + resource + "): " + result));
        }
        return result;
    }

    public boolean applyExcludes(boolean allValuesRequested, boolean resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return !resultWithoutExcludes;
    }

    ResourceMatcher getMatcher(String policyValue) {
        ResourceMatcher ret;
        int len;
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        int wildcardStartIdx = -1;
        int wildcardEndIdx = -1;
        boolean needWildcardMatch = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c == '?') {
                    needWildcardMatch = true;
                    break;
                }
                if (c != '*') continue;
                if (wildcardEndIdx == -1 || wildcardEndIdx == i - 1) {
                    wildcardEndIdx = i;
                    if (wildcardStartIdx != -1) continue;
                    wildcardStartIdx = i;
                    continue;
                }
                needWildcardMatch = true;
                break;
            }
        }
        if (needWildcardMatch) {
            ret = this.optIgnoreCase ? new CaseInsensitiveWildcardMatcher(policyValue) : new CaseSensitiveWildcardMatcher(policyValue);
        } else if (wildcardStartIdx == -1) {
            ret = this.optIgnoreCase ? new CaseInsensitiveStringMatcher(policyValue) : new CaseSensitiveStringMatcher(policyValue);
        } else if (wildcardStartIdx == 0) {
            String matchStr = policyValue.substring(wildcardEndIdx + 1);
            ret = this.optIgnoreCase ? new CaseInsensitiveEndsWithMatcher(matchStr) : new CaseSensitiveEndsWithMatcher(matchStr);
        } else {
            String matchStr = policyValue.substring(0, wildcardStartIdx);
            ret = this.optIgnoreCase ? new CaseInsensitiveStartsWithMatcher(matchStr) : new CaseSensitiveStartsWithMatcher(matchStr);
        }
        return ret;
    }
}

