/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;

public class RangerDefaultResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerDefaultResourceMatcher.class);

    @Override
    public boolean isMatch(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultResourceMatcher.isMatch(" + resource + ")"));
        }
        boolean ret = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        if (allValuesRequested || this.isMatchAny) {
            ret = this.isMatchAny;
        } else if (CollectionUtils.isNotEmpty((Collection)this.resourceMatchers)) {
            ResourceMatcher resourceMatcher;
            Iterator iterator = this.resourceMatchers.iterator();
            while (iterator.hasNext() && !(ret = (resourceMatcher = (ResourceMatcher)iterator.next()).isMatch(resource))) {
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        if (!ret && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : this.policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug((Object)("RangerDefaultResourceMatcher.isMatch returns FALSE, (resource=" + resource + ", policyValues=" + sb.toString() + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultResourceMatcher.isMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultResourceMatcher={");
        super.toString(sb);
        sb.append("}");
        return sb;
    }
}

