/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.store.TagStore;

public abstract class AbstractTagStore
implements TagStore {
    private static final Log LOG = LogFactory.getLog(AbstractTagStore.class);
    protected ServiceStore svcStore;

    @Override
    public void init() throws Exception {
    }

    @Override
    public final void setServiceStore(ServiceStore svcStore) {
        this.svcStore = svcStore;
    }

    protected void preCreate(RangerBaseModelObject obj) throws Exception {
        obj.setId(0L);
        if (obj.getGuid() == null) {
            obj.setGuid(UUID.randomUUID().toString());
        }
        obj.setCreateTime(new Date());
        obj.setUpdateTime(obj.getCreateTime());
        obj.setVersion(1L);
    }

    protected void postCreate(RangerBaseModelObject obj) throws Exception {
    }

    protected void preUpdate(RangerBaseModelObject obj) throws Exception {
        Long version;
        if (obj.getId() == null) {
            obj.setId(0L);
        }
        if (obj.getGuid() == null) {
            obj.setGuid(UUID.randomUUID().toString());
        }
        if (obj.getCreateTime() == null) {
            obj.setCreateTime(new Date());
        }
        version = (version = obj.getVersion()) == null ? Long.valueOf(1L) : Long.valueOf(version + 1L);
        obj.setVersion(version);
        obj.setUpdateTime(new Date());
    }

    protected void postUpdate(RangerBaseModelObject obj) throws Exception {
    }

    protected void preDelete(RangerBaseModelObject obj) throws Exception {
    }

    protected void postDelete(RangerBaseModelObject obj) throws Exception {
    }

    protected long getMaxId(List<? extends RangerBaseModelObject> objs) {
        long ret = -1L;
        if (objs != null) {
            for (RangerBaseModelObject rangerBaseModelObject : objs) {
                if (rangerBaseModelObject.getId() <= ret) continue;
                ret = rangerBaseModelObject.getId();
            }
        }
        return ret;
    }

    @Override
    public void deleteAllTagObjectsForService(String serviceName) throws Exception {
        List<RangerServiceResource> serviceResources;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> AbstractTagStore.deleteAllTagObjectsForService(serviceName=" + serviceName + ")"));
        }
        if ((serviceResources = this.getServiceResourcesByService(serviceName)) != null) {
            for (RangerServiceResource serviceResource : serviceResources) {
                Long resourceId = serviceResource.getId();
                List<RangerTagResourceMap> tagResourceMapsForService = this.getTagResourceMapsForResourceId(resourceId);
                for (RangerTagResourceMap tagResourceMap : tagResourceMapsForService) {
                    this.deleteTagResourceMap(tagResourceMap.getId());
                }
            }
            for (RangerServiceResource serviceResource : serviceResources) {
                this.deleteServiceResource(serviceResource.getId());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== AbstractTagStore.deleteAllTagObjectsForService(serviceName=" + serviceName + ")"));
        }
    }
}

