/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerServiceResourceMatcher;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceTrie;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerTagEnricher
extends RangerAbstractContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerTagEnricher.class);
    private static final Log PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    public static final String TAG_REFRESHER_POLLINGINTERVAL_OPTION = "tagRefresherPollingInterval";
    public static final String TAG_RETRIEVER_CLASSNAME_OPTION = "tagRetrieverClassName";
    public static final String TAG_DISABLE_TRIE_PREFILTER_OPTION = "disableTrieLookupPrefilter";
    private RangerTagRefresher tagRefresher = null;
    private RangerTagRetriever tagRetriever = null;
    private ServiceTags serviceTags = null;
    private List<RangerServiceResourceMatcher> serviceResourceMatchers = null;
    private Map<String, RangerResourceTrie> serviceResourceTrie = null;
    private boolean disableTrieLookupPrefilter = false;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerTagEnricher.init()");
        }
        super.init();
        String tagRetrieverClassName = this.getOption(TAG_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(TAG_REFRESHER_POLLINGINTERVAL_OPTION, 60000L);
        this.disableTrieLookupPrefilter = this.getBooleanOption(TAG_DISABLE_TRIE_PREFILTER_OPTION, false);
        if (StringUtils.isNotBlank((String)tagRetrieverClassName)) {
            try {
                Class<?> tagRetriverClass = Class.forName(tagRetrieverClassName);
                this.tagRetriever = (RangerTagRetriever)tagRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " not found, exception=" + exception));
            }
            catch (ClassCastException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " is not a type of RangerTagRetriever, exception=" + exception));
            }
            catch (IllegalAccessException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " could not be instantiated, exception=" + exception));
            }
            catch (InstantiationException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " could not be instantiated, exception=" + exception));
            }
            if (this.tagRetriever != null) {
                String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
                String cacheDir = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.cache.dir");
                String cacheFilename = String.format("%s_%s_tag.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.tagRetriever.setServiceName(this.serviceName);
                this.tagRetriever.setServiceDef(this.serviceDef);
                this.tagRetriever.setAppId(this.appId);
                this.tagRetriever.init(this.enricherDef.getEnricherOptions());
                this.tagRefresher = new RangerTagRefresher(this.tagRetriever, this, -1L, cacheFile, pollingIntervalMs);
                try {
                    this.tagRefresher.populateTags();
                }
                catch (Throwable exception) {
                    LOG.error((Object)"Exception when retrieving tag for the first time for this enricher", exception);
                }
                this.tagRefresher.setDaemon(true);
                this.tagRefresher.startRefresher();
            }
        } else {
            LOG.error((Object)"No value specified for tagRetrieverClassName in the RangerTagEnricher options");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerTagEnricher.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.enrich(" + request + ")"));
        }
        List<RangerTag> matchedTags = this.findMatchingTags(request.getResource(), request.getContext());
        RangerAccessRequestUtil.setRequestTagsInContext(request.getContext(), matchedTags);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.enrich(" + request + "): tags count=" + (matchedTags == null ? 0 : matchedTags.size())));
        }
    }

    public void setServiceTags(ServiceTags serviceTags) {
        ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
        List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
        if (CollectionUtils.isNotEmpty(serviceResources)) {
            for (RangerServiceResource serviceResource : serviceResources) {
                RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
                matcher.setServiceDef(this.serviceDef);
                matcher.setPolicyResources(serviceResource.getResourceElements());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerTagEnricher.setServiceTags() - Initializing matcher with (resource=" + serviceResource + ", serviceDef=" + this.serviceDef.getName() + ")"));
                }
                matcher.init();
                RangerServiceResourceMatcher serviceResourceMatcher = new RangerServiceResourceMatcher(serviceResource, matcher);
                resourceMatchers.add(serviceResourceMatcher);
            }
        }
        HashMap<String, RangerResourceTrie> serviceResourceTrie = null;
        if (!this.disableTrieLookupPrefilter) {
            serviceResourceTrie = new HashMap<String, RangerResourceTrie>();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                serviceResourceTrie.put(resourceDef.getName(), new RangerResourceTrie<RangerServiceResourceMatcher>(resourceDef, resourceMatchers));
            }
        }
        this.serviceResourceMatchers = resourceMatchers;
        this.serviceResourceTrie = serviceResourceTrie;
        this.serviceTags = serviceTags;
    }

    @Override
    public boolean preCleanup() {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerTagEnricher.preCleanup()");
        }
        if (this.tagRefresher != null) {
            this.tagRefresher.cleanup();
            this.tagRefresher = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.preCleanup() : result=" + ret));
        }
        return ret;
    }

    private List<RangerTag> findMatchingTags(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.findMatchingTags(" + resource + ", " + evalContext + ")"));
        }
        ArrayList<RangerTag> ret = null;
        List<RangerServiceResourceMatcher> serviceResourceMatchers = this.getEvaluators(resource);
        if (CollectionUtils.isNotEmpty(serviceResourceMatchers)) {
            ServiceTags serviceTags = this.serviceTags;
            for (RangerServiceResourceMatcher resourceMatcher : serviceResourceMatchers) {
                boolean matchResult = resourceMatcher.isMatch(resource, evalContext);
                if (!matchResult) continue;
                if (ret == null) {
                    ret = new ArrayList<RangerTag>();
                }
                ret.addAll(RangerTagEnricher.getTagsForServiceResource(serviceTags, resourceMatcher.getServiceResource()));
            }
        }
        if (LOG.isDebugEnabled()) {
            if (CollectionUtils.isEmpty(ret)) {
                LOG.debug((Object)("RangerTagEnricher.findMatchingTags(" + resource + ") - No tags Found "));
            } else {
                LOG.debug((Object)("RangerTagEnricher.findMatchingTags(" + resource + ") - " + ret.size() + " tags Found "));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.findMatchingTags(" + resource + ", " + evalContext + ")"));
        }
        return ret;
    }

    private List<RangerServiceResourceMatcher> getEvaluators(RangerAccessResource resource) {
        List<RangerServiceResourceMatcher> ret = null;
        if (this.serviceResourceTrie == null) {
            ret = this.serviceResourceMatchers;
        } else {
            Set<String> resourceKeys;
            Set<String> set = resourceKeys = resource == null ? null : resource.getKeys();
            if (CollectionUtils.isNotEmpty(resourceKeys)) {
                boolean isRetModifiable = false;
                for (String resourceName : resourceKeys) {
                    RangerResourceTrie trie = this.serviceResourceTrie.get(resourceName);
                    if (trie == null) continue;
                    List resourceEvaluators = trie.getEvaluatorsForResource(resource.getValue(resourceName));
                    if (CollectionUtils.isEmpty(resourceEvaluators)) {
                        ret = null;
                    } else if (ret == null) {
                        ret = resourceEvaluators;
                    } else if (isRetModifiable) {
                        ret.retainAll(resourceEvaluators);
                    } else {
                        List<Object> longerList;
                        List<RangerServiceResourceMatcher> shorterList;
                        if (ret.size() < resourceEvaluators.size()) {
                            shorterList = ret;
                            longerList = resourceEvaluators;
                        } else {
                            shorterList = resourceEvaluators;
                            longerList = ret;
                        }
                        ret = new ArrayList<RangerServiceResourceMatcher>(shorterList);
                        ret.retainAll(longerList);
                        isRetModifiable = true;
                    }
                    if (!CollectionUtils.isEmpty(ret)) continue;
                    ret = null;
                    break;
                }
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.getEvaluators(" + resource.getAsString() + "): evaluatorCount=" + ret.size()));
        }
        return ret;
    }

    private static List<RangerTag> getTagsForServiceResource(ServiceTags serviceTags, RangerServiceResource serviceResource) {
        List<Long> tagIds;
        ArrayList<RangerTag> ret = new ArrayList<RangerTag>();
        Long resourceId = serviceResource.getId();
        Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
        Map<Long, RangerTag> tags = serviceTags.getTags();
        if (resourceId != null && MapUtils.isNotEmpty(resourceToTagIds) && MapUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(tagIds = resourceToTagIds.get(resourceId))) {
            for (Long tagId : tagIds) {
                RangerTag tag = tags.get(tagId);
                if (tag == null) continue;
                ret.add(tag);
            }
        }
        return ret;
    }

    static class RangerTagRefresher
    extends Thread {
        private static final Log LOG = LogFactory.getLog(RangerTagRefresher.class);
        private final RangerTagRetriever tagRetriever;
        private final RangerTagEnricher tagEnricher;
        private long lastKnownVersion = -1L;
        private final long pollingIntervalMs;
        private final String cacheFile;
        private boolean hasProvidedTagsToReceiver = false;
        private Gson gson;

        final long getPollingIntervalMs() {
            return this.pollingIntervalMs;
        }

        RangerTagRefresher(RangerTagRetriever tagRetriever, RangerTagEnricher tagEnricher, long lastKnownVersion, String cacheFile, long pollingIntervalMs) {
            this.tagRetriever = tagRetriever;
            this.tagEnricher = tagEnricher;
            this.lastKnownVersion = lastKnownVersion;
            this.cacheFile = cacheFile;
            this.pollingIntervalMs = pollingIntervalMs;
            try {
                this.gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
            }
            catch (Throwable excp) {
                LOG.fatal((Object)"failed to create GsonBuilder object", excp);
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerTagRefresher(pollingIntervalMs=" + this.pollingIntervalMs + ").run()"));
            }
            try {
                while (this.pollingIntervalMs > 0L) {
                    Thread.sleep(this.pollingIntervalMs);
                    RangerPerfTracer perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerTagRefresher.populateTags(serviceName=" + this.tagRetriever.getServiceName() + ",lastKnownVersion=" + this.lastKnownVersion + ")");
                    }
                    this.populateTags();
                    RangerPerfTracer.log(perf);
                }
            }
            catch (InterruptedException excp) {
                LOG.debug((Object)("RangerTagRefresher(pollingIntervalMs=" + this.pollingIntervalMs + ").run() : interrupted! Exiting thread"), (Throwable)excp);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== RangerTagRefresher().run()");
            }
        }

        private void populateTags() throws InterruptedException {
            if (this.tagEnricher != null) {
                ServiceTags serviceTags = null;
                serviceTags = this.tagRetriever.retrieveTags(this.lastKnownVersion);
                if (serviceTags == null) {
                    if (!this.hasProvidedTagsToReceiver) {
                        serviceTags = this.loadFromCache();
                    }
                } else {
                    this.saveToCache(serviceTags);
                }
                if (serviceTags != null) {
                    this.tagEnricher.setServiceTags(serviceTags);
                    this.lastKnownVersion = serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion();
                    LOG.info((Object)("RangerTagRefresher.populateTags() - Updated tags-cache to new version of tags, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + serviceTags.getTagVersion()));
                    this.hasProvidedTagsToReceiver = true;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerTagRefresher.populateTags() - No need to update tags-cache. lastKnownVersion=" + this.lastKnownVersion));
                }
            } else {
                LOG.error((Object)"RangerTagRefresher.populateTags() - no tag receiver to update tag-cache");
            }
        }

        void cleanup() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"==> RangerTagRefresher.cleanup()");
            }
            this.stopRefresher();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== RangerTagRefresher.cleanup()");
            }
        }

        final void startRefresher() {
            try {
                super.start();
            }
            catch (Exception excp) {
                LOG.error((Object)("RangerTagRefresher.startRetriever() - failed to start, exception=" + excp));
            }
        }

        private void stopRefresher() {
            if (super.isAlive()) {
                super.interrupt();
                try {
                    super.join();
                }
                catch (InterruptedException excp) {
                    LOG.error((Object)"RangerTagRefresher(): error while waiting for thread to exit", (Throwable)excp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        final ServiceTags loadFromCache() {
            serviceTags = null;
            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug((Object)("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()"));
            }
            v0 = cacheFile = StringUtils.isEmpty((String)this.cacheFile) != false ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                reader = null;
                try {
                    reader = new FileReader(cacheFile);
                    serviceTags = (ServiceTags)this.gson.fromJson((Reader)reader, ServiceTags.class);
                    if (serviceTags == null || StringUtils.equals((String)this.tagEnricher.getServiceName(), (String)serviceTags.getServiceName())) ** GOTO lbl26
                    RangerTagRefresher.LOG.warn((Object)("ignoring unexpected serviceName '" + serviceTags.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'"));
                    serviceTags.setServiceName(this.tagEnricher.getServiceName());
                }
                catch (Exception excp) {
                    RangerTagRefresher.LOG.error((Object)("failed to load service-tags from cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception excp) {
                            RangerTagRefresher.LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                        }
                    }
                }
            } else {
                RangerTagRefresher.LOG.warn((Object)("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'"));
            }
lbl26:
            // 4 sources

            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug((Object)("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()"));
            }
            return serviceTags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void saveToCache(ServiceTags serviceTags) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()"));
            }
            if (serviceTags != null) {
                File cacheFile;
                File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
                if (cacheFile != null) {
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(cacheFile);
                        this.gson.toJson((Object)serviceTags, (Appendable)writer);
                    }
                    catch (Exception excp) {
                        LOG.error((Object)("failed to save service-tags to cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Exception excp) {
                                LOG.error((Object)("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                            }
                        }
                    }
                }
            } else {
                LOG.info((Object)"service-tags is null. Nothing to save in cache");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()"));
            }
        }
    }
}

