/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyItemEvaluator;

public abstract class RangerAbstractPolicyItemEvaluator
implements RangerPolicyItemEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerAbstractPolicyItemEvaluator.class);
    private static final int RANGER_POLICY_ITEM_EVAL_ORDER_DEFAULT = 1000;
    private static final int RANGER_POLICY_ITEM_EVAL_ORDER_MAX_DISCOUNT_USERSGROUPS = 25;
    private static final int RANGER_POLICY_ITEM_EVAL_ORDER_MAX_DISCOUNT_ACCESS_TYPES = 25;
    private static final int RANGER_POLICY_ITEM_EVAL_ORDER_MAX_DISCOUNT_CUSTOM_CONDITIONS = 25;
    private static final int RANGER_POLICY_ITEM_EVAL_ORDER_CUSTOM_CONDITION_PENALTY = 5;
    final RangerPolicyEngineOptions options;
    final RangerServiceDef serviceDef;
    final RangerPolicy.RangerPolicyItem policyItem;
    final int policyItemType;
    final int policyItemIndex;
    final long policyId;
    final int evalOrder;
    List<RangerConditionEvaluator> conditionEvaluators = Collections.emptyList();

    RangerAbstractPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerPolicy.RangerPolicyItem policyItem, int policyItemType, int policyItemIndex, RangerPolicyEngineOptions options) {
        this.serviceDef = serviceDef;
        this.policyItem = policyItem;
        this.policyItemType = policyItemType;
        this.policyItemIndex = policyItemIndex;
        this.options = options;
        this.policyId = policy != null && policy.getId() != null ? policy.getId() : -1L;
        this.evalOrder = this.computeEvalOrder();
    }

    @Override
    public List<RangerConditionEvaluator> getConditionEvaluators() {
        return this.conditionEvaluators;
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public RangerPolicy.RangerPolicyItem getPolicyItem() {
        return this.policyItem;
    }

    @Override
    public int getPolicyItemType() {
        return this.policyItemType;
    }

    @Override
    public int getPolicyItemIndex() {
        return this.policyItemIndex;
    }

    @Override
    public String getComments() {
        return null;
    }

    @Override
    public int compareTo(RangerPolicyItemEvaluator other) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractPolicyItemEvaluator.compareTo()");
        }
        int result = Integer.compare(this.getEvalOrder(), other.getEvalOrder());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyItemEvaluator.compareTo(), result:" + result));
        }
        return result;
    }

    protected String getServiceType() {
        return this.serviceDef != null ? this.serviceDef.getName() : null;
    }

    protected boolean getConditionsDisabledOption() {
        return this.options != null ? this.options.disableCustomConditions : false;
    }

    private int computeEvalOrder() {
        int evalOrder = 1000;
        if (this.policyItem != null) {
            int customConditionsDiscount;
            if (CollectionUtils.isNotEmpty(this.policyItem.getGroups()) && this.policyItem.getGroups().contains("public") || CollectionUtils.isNotEmpty(this.policyItem.getUsers()) && this.policyItem.getUsers().contains("{USER}")) {
                evalOrder -= 25;
            } else {
                int userGroupCount = 0;
                if (!CollectionUtils.isEmpty(this.policyItem.getUsers())) {
                    userGroupCount += this.policyItem.getUsers().size();
                }
                if (!CollectionUtils.isEmpty(this.policyItem.getGroups())) {
                    userGroupCount += this.policyItem.getGroups().size();
                }
                evalOrder -= Math.min(25, userGroupCount);
            }
            if (CollectionUtils.isNotEmpty(this.policyItem.getAccesses())) {
                evalOrder -= Math.round(25.0f * (float)this.policyItem.getAccesses().size() / (float)this.serviceDef.getAccessTypes().size());
            }
            int customConditionsPenalty = 0;
            if (CollectionUtils.isNotEmpty(this.policyItem.getConditions())) {
                customConditionsPenalty = 5 * this.policyItem.getConditions().size();
            }
            if ((customConditionsDiscount = 25 - customConditionsPenalty) > 0) {
                evalOrder -= customConditionsDiscount;
            }
        }
        return evalOrder;
    }
}

