/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyresourcematcher;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;

public class RangerDefaultPolicyResourceMatcher
implements RangerPolicyResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerDefaultPolicyResourceMatcher.class);
    protected RangerServiceDef serviceDef = null;
    protected RangerPolicy policy = null;
    protected Map<String, RangerPolicy.RangerPolicyResource> policyResources = null;
    private Map<String, RangerResourceMatcher> matchers = null;
    private boolean needsDynamicEval = false;
    private List<RangerServiceDef.RangerResourceDef> firstValidResourceDefHierarchy;

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
    }

    @Override
    public void setPolicy(RangerPolicy policy) {
        this.policy = policy;
        this.setPolicyResources(policy == null ? null : policy.getResources());
    }

    @Override
    public void setPolicyResources(Map<String, RangerPolicy.RangerPolicyResource> policyResources) {
        this.policyResources = policyResources;
    }

    @Override
    public boolean getNeedsDynamicEval() {
        return this.needsDynamicEval;
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerDefaultPolicyResourceMatcher.init()");
        }
        String errorText = "";
        if (this.policyResources != null && this.policyResources.size() > 0 && this.serviceDef != null) {
            Set<String> policyResourceKeySet = this.policyResources.keySet();
            RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
            int policyType = this.policy != null && this.policy.getPolicyType() != null ? this.policy.getPolicyType() : 0;
            Set<List<RangerServiceDef.RangerResourceDef>> validResourceHierarchies = serviceDefHelper.getResourceHierarchies(policyType);
            for (List<RangerServiceDef.RangerResourceDef> validResourceHierarchy : validResourceHierarchies) {
                Set<String> resourceDefNameSet = serviceDefHelper.getAllResourceNames(validResourceHierarchy);
                if (!Sets.difference(policyResourceKeySet, resourceDefNameSet).isEmpty()) continue;
                this.firstValidResourceDefHierarchy = validResourceHierarchy;
                break;
            }
            if (this.firstValidResourceDefHierarchy != null) {
                List<String> resourceDefNameOrderedList = serviceDefHelper.getAllResourceNamesOrdered(this.firstValidResourceDefHierarchy);
                boolean foundGapsInResourceSpecs = false;
                boolean skipped = false;
                for (String resourceDefName : resourceDefNameOrderedList) {
                    RangerPolicy.RangerPolicyResource policyResource = this.policyResources.get(resourceDefName);
                    if (policyResource == null) {
                        skipped = true;
                        continue;
                    }
                    if (!skipped) continue;
                    foundGapsInResourceSpecs = true;
                    break;
                }
                if (foundGapsInResourceSpecs) {
                    errorText = "policyResources does not specify contiguous sequence in any valid resourcedef hiearchy.";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.init() failed: Gaps found in policyResources, internal error, skipping..");
                    }
                    this.firstValidResourceDefHierarchy = null;
                } else {
                    this.matchers = new HashMap<String, RangerResourceMatcher>();
                    for (RangerServiceDef.RangerResourceDef resourceDef : this.firstValidResourceDefHierarchy) {
                        String resourceName = resourceDef.getName();
                        RangerPolicy.RangerPolicyResource policyResource = this.policyResources.get(resourceName);
                        if (policyResource != null) {
                            RangerResourceMatcher matcher = RangerDefaultPolicyResourceMatcher.createResourceMatcher(resourceDef, policyResource);
                            if (matcher != null) {
                                if (!this.needsDynamicEval && matcher.getNeedsDynamicEval()) {
                                    this.needsDynamicEval = true;
                                }
                                this.matchers.put(resourceName, matcher);
                                continue;
                            }
                            LOG.error((Object)("failed to find matcher for resource " + resourceName));
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("RangerDefaultPolicyResourceMatcher.init() - no matcher created for " + resourceName + ". Continuing ..."));
                    }
                }
            } else {
                errorText = "policyResources elements are not part of any valid resourcedef hierarchy.";
            }
        } else {
            errorText = " policyResources is null or empty, or serviceDef is null.";
        }
        if (this.matchers == null) {
            Set<String> policyResourceKeys = this.policyResources == null ? null : this.policyResources.keySet();
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty(policyResourceKeys)) {
                for (String policyResourceKeyName : policyResourceKeys) {
                    sb.append(" ").append(policyResourceKeyName).append(" ");
                }
            }
            String keysString = sb.toString();
            String serviceDefName = this.serviceDef == null ? "" : this.serviceDef.getName();
            String validHierarchy = "";
            if (this.serviceDef != null && CollectionUtils.isNotEmpty(this.firstValidResourceDefHierarchy)) {
                RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
                List<String> resourceDefNameOrderedList = serviceDefHelper.getAllResourceNamesOrdered(this.firstValidResourceDefHierarchy);
                for (String resourceDefName : resourceDefNameOrderedList) {
                    validHierarchy = validHierarchy + " " + resourceDefName + " ";
                }
            }
            LOG.warn((Object)("RangerDefaultPolicyResourceMatcher.init() failed: " + errorText + " (serviceDef=" + serviceDefName + ", policyResourceKeys=" + keysString + ", validHierarchy=" + validHierarchy + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerDefaultPolicyResourceMatcher.init()");
        }
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.matchers != null ? this.matchers.get(resourceName) : null;
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isMatch(" + resource + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.serviceDef != null && this.serviceDef.getResources() != null) {
            boolean keysMatch;
            Set<String> resourceKeys = resource == null ? null : resource.getKeys();
            Set<String> policyKeys = this.matchers == null ? null : this.matchers.keySet();
            boolean bl = keysMatch = CollectionUtils.isEmpty(resourceKeys) || policyKeys != null && policyKeys.containsAll(resourceKeys);
            if (keysMatch) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    RangerResourceMatcher matcher;
                    String resourceName = resourceDef.getName();
                    String resourceValue = resource == null ? null : resource.getValue(resourceName);
                    RangerResourceMatcher rangerResourceMatcher = matcher = this.matchers == null ? null : this.matchers.get(resourceName);
                    if (StringUtils.isEmpty((String)resourceValue)) {
                        ret = matcher == null || matcher.isMatch(resourceValue, evalContext);
                    } else {
                        boolean bl2 = ret = matcher != null && matcher.isMatch(resourceValue, evalContext);
                    }
                    if (ret) continue;
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isMatch(): keysMatch=false. isMatch=" + resourceKeys + "; policyKeys=" + policyKeys));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.isMatch(" + resource + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isMatch(" + resources + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.serviceDef != null && this.serviceDef.getResources() != null) {
            boolean keysMatch;
            Set<String> resourceKeys = resources == null ? null : resources.keySet();
            Set<String> policyKeys = this.matchers == null ? null : this.matchers.keySet();
            boolean bl = keysMatch = CollectionUtils.isEmpty(resourceKeys) || policyKeys != null && policyKeys.containsAll(resourceKeys);
            if (keysMatch) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    RangerResourceMatcher matcher;
                    String resourceName = resourceDef.getName();
                    RangerPolicy.RangerPolicyResource resourceValues = resources == null ? null : resources.get(resourceName);
                    RangerResourceMatcher rangerResourceMatcher = matcher = this.matchers == null ? null : this.matchers.get(resourceName);
                    if (resourceValues == null || CollectionUtils.isEmpty(resourceValues.getValues())) {
                        ret = matcher == null || matcher.isMatch(null, null);
                    } else if (matcher != null) {
                        String resourceValue;
                        Iterator<String> iterator = resourceValues.getValues().iterator();
                        while (iterator.hasNext() && (ret = matcher.isMatch(resourceValue = iterator.next(), evalContext))) {
                        }
                    }
                    if (ret) continue;
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.isMatch(" + resources + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.serviceDef != null && this.serviceDef.getResources() != null) {
            Set<String> resourceKeys = resource == null ? null : resource.getKeys();
            Set<String> policyKeys = this.matchers == null ? null : this.matchers.keySet();
            boolean keysMatch = false;
            if (resourceKeys != null && policyKeys != null) {
                keysMatch = CollectionUtils.isEqualCollection(resourceKeys, policyKeys);
            }
            if (keysMatch) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    RangerResourceMatcher matcher;
                    String resourceName = resourceDef.getName();
                    String resourceValue = resource == null ? null : resource.getValue(resourceName);
                    RangerResourceMatcher rangerResourceMatcher = matcher = this.matchers == null ? null : this.matchers.get(resourceName);
                    if (StringUtils.isEmpty((String)resourceValue)) {
                        ret = matcher == null || matcher.isCompleteMatch(resourceValue, evalContext);
                    } else {
                        boolean bl = ret = matcher != null && matcher.isCompleteMatch(resourceValue, evalContext);
                    }
                    if (ret) continue;
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isCompleteMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resource + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isHeadMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isHeadMatch(" + resource + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.matchers == null) {
            LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.isHeadMatch(): PolicyResourceMatcher not initialized correctly!!!");
            ret = false;
        } else if (resource == null || CollectionUtils.isEmpty(resource.getKeys())) {
            LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.isHeadMatch: resource was null/empty!");
            ret = true;
        } else {
            ret = this.newIsHeadMatch(resource, evalContext);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.matchResourceHead(" + resource + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isExactHeadMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isExactHeadMatch(" + resource + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.matchers == null) {
            LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.isExactHeadMatch(): PolicyResourceMatcher not initialized correctly!!!");
            ret = false;
        } else if (resource == null || CollectionUtils.isEmpty(resource.getKeys())) {
            LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.isExactHeadMatch: resource was null/empty!");
            ret = false;
        } else if (this.matchers.size() > resource.getKeys().size()) {
            LOG.debug((Object)"RangerDefaultPolicyResourceMatcher.isExactHeadMatch: more levels specified in PolicyResourceMatcher than in resource being matched!!");
            ret = false;
        } else {
            ret = this.newIsHeadMatch(resource, evalContext);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.isExactHeadMatch(" + resource + ", " + evalContext + ")" + ret));
        }
        return ret;
    }

    private boolean newIsHeadMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.newIsHeadMatch(" + resource + ", " + evalContext + ")"));
        }
        boolean skipped = false;
        boolean matched = true;
        for (RangerServiceDef.RangerResourceDef resourceDef : this.firstValidResourceDefHierarchy) {
            String resourceName = resourceDef.getName();
            String resourceValue = resource.getValue(resourceName);
            RangerResourceMatcher matcher = this.matchers.get(resourceName);
            if (matcher != null) {
                if (StringUtils.isNotBlank((String)resourceValue)) {
                    matched = !skipped ? matcher.isMatch(resourceValue, evalContext) : false;
                } else {
                    skipped = true;
                }
            }
            if (matched) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.newIsHeadMatch(" + resource + ", " + evalContext + "): " + matched));
        }
        return matched;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultPolicyResourceMatcher={");
        sb.append("matchers={");
        if (this.matchers != null) {
            for (RangerResourceMatcher matcher : this.matchers.values()) {
                sb.append("{").append(matcher).append("} ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    protected static RangerResourceMatcher createResourceMatcher(RangerServiceDef.RangerResourceDef resourceDef, RangerPolicy.RangerPolicyResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.createResourceMatcher(" + resourceDef + ", " + resource + ")"));
        }
        RangerResourceMatcher ret = null;
        if (resourceDef != null) {
            String resName = resourceDef.getName();
            String clsName = resourceDef.getMatcher();
            if (!StringUtils.isEmpty((String)clsName)) {
                try {
                    Class<?> matcherClass = Class.forName(clsName);
                    ret = (RangerResourceMatcher)matcherClass.newInstance();
                }
                catch (Exception excp) {
                    LOG.error((Object)("failed to instantiate resource matcher '" + clsName + "' for '" + resName + "'. Default resource matcher will be used"), (Throwable)excp);
                }
            }
            if (ret == null) {
                ret = new RangerDefaultResourceMatcher();
            }
            if (ret != null) {
                ret.setResourceDef(resourceDef);
                ret.setPolicyResource(resource);
                ret.init();
            }
        } else {
            LOG.error((Object)"RangerDefaultPolicyResourceMatcher: RangerResourceDef is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.createResourceMatcher(" + resourceDef + ", " + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resources + ", " + evalContext + ")"));
        }
        boolean ret = false;
        if (this.serviceDef != null && this.serviceDef.getResources() != null) {
            Set<String> resourceKeys = resources == null ? null : resources.keySet();
            Set<String> policyKeys = this.matchers == null ? null : this.matchers.keySet();
            boolean keysMatch = false;
            if (resourceKeys != null && policyKeys != null) {
                keysMatch = CollectionUtils.isEqualCollection(resourceKeys, policyKeys);
            }
            if (keysMatch) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    RangerPolicy.RangerPolicyResource policyValues;
                    String resourceName = resourceDef.getName();
                    RangerPolicy.RangerPolicyResource resourceValues = resources == null ? null : resources.get(resourceName);
                    RangerPolicy.RangerPolicyResource rangerPolicyResource = policyValues = this.policyResources == null ? null : this.policyResources.get(resourceName);
                    if (resourceValues == null || CollectionUtils.isEmpty(resourceValues.getValues())) {
                        ret = policyValues == null || CollectionUtils.isEmpty(policyValues.getValues());
                    } else if (policyValues != null && CollectionUtils.isNotEmpty(policyValues.getValues())) {
                        ret = CollectionUtils.isEqualCollection(resourceValues.getValues(), policyValues.getValues());
                    }
                    if (ret) continue;
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isCompleteMatch(): keysMatch=false. resourceKeys=" + resourceKeys + "; policyKeys=" + policyKeys));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyResourceMatcher.isCompleteMatch(" + resources + ", " + evalContext + "): " + ret));
        }
        return ret;
    }
}

