/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.ServiceStore;

public class EmbeddedServiceDefsUtil {
    private static final Log LOG = LogFactory.getLog(EmbeddedServiceDefsUtil.class);
    private static final String DEFAULT_BOOTSTRAP_SERVICEDEF_LIST = "tag,hdfs,hbase,hive,kms,knox,storm,yarn,kafka,solr,atlas";
    private static final String PROPERTY_SUPPORTED_SERVICE_DEFS = "ranger.supportedcomponents";
    private Set<String> supportedServiceDefs;
    public static final String EMBEDDED_SERVICEDEF_TAG_NAME = "tag";
    public static final String EMBEDDED_SERVICEDEF_HDFS_NAME = "hdfs";
    public static final String EMBEDDED_SERVICEDEF_HBASE_NAME = "hbase";
    public static final String EMBEDDED_SERVICEDEF_HIVE_NAME = "hive";
    public static final String EMBEDDED_SERVICEDEF_KMS_NAME = "kms";
    public static final String EMBEDDED_SERVICEDEF_KNOX_NAME = "knox";
    public static final String EMBEDDED_SERVICEDEF_STORM_NAME = "storm";
    public static final String EMBEDDED_SERVICEDEF_YARN_NAME = "yarn";
    public static final String EMBEDDED_SERVICEDEF_KAFKA_NAME = "kafka";
    public static final String EMBEDDED_SERVICEDEF_SOLR_NAME = "solr";
    public static final String EMBEDDED_SERVICEDEF_NIFI_NAME = "nifi";
    public static final String EMBEDDED_SERVICEDEF_ATLAS_NAME = "atlas";
    public static final String PROPERTY_CREATE_EMBEDDED_SERVICE_DEFS = "ranger.service.store.create.embedded.service-defs";
    public static final String HDFS_IMPL_CLASS_NAME = "org.apache.ranger.services.hdfs.RangerServiceHdfs";
    public static final String HBASE_IMPL_CLASS_NAME = "org.apache.ranger.services.hbase.RangerServiceHBase";
    public static final String HIVE_IMPL_CLASS_NAME = "org.apache.ranger.services.hive.RangerServiceHive";
    public static final String KMS_IMPL_CLASS_NAME = "org.apache.ranger.services.kms.RangerServiceKMS";
    public static final String KNOX_IMPL_CLASS_NAME = "org.apache.ranger.services.knox.RangerServiceKnox";
    public static final String STORM_IMPL_CLASS_NAME = "org.apache.ranger.services.storm.RangerServiceStorm";
    public static final String YARN_IMPL_CLASS_NAME = "org.apache.ranger.services.yarn.RangerServiceYarn";
    public static final String KAFKA_IMPL_CLASS_NAME = "org.apache.ranger.services.kafka.RangerServiceKafka";
    public static final String SOLR_IMPL_CLASS_NAME = "org.apache.ranger.services.solr.RangerServiceSolr";
    public static final String NIFI_IMPL_CLASS_NAME = "org.apache.ranger.services.nifi.RangerServiceNiFi";
    public static final String ATLAS_IMPL_CLASS_NAME = "org.apache.ranger.services.atlas.RangerServiceAtlas";
    private static EmbeddedServiceDefsUtil instance = new EmbeddedServiceDefsUtil();
    private boolean createEmbeddedServiceDefs = true;
    private RangerServiceDef hdfsServiceDef = null;
    private RangerServiceDef hBaseServiceDef = null;
    private RangerServiceDef hiveServiceDef = null;
    private RangerServiceDef kmsServiceDef = null;
    private RangerServiceDef knoxServiceDef = null;
    private RangerServiceDef stormServiceDef = null;
    private RangerServiceDef yarnServiceDef = null;
    private RangerServiceDef kafkaServiceDef = null;
    private RangerServiceDef solrServiceDef = null;
    private RangerServiceDef nifiServiceDef = null;
    private RangerServiceDef atlasServiceDef = null;
    private RangerServiceDef tagServiceDef = null;
    private Gson gsonBuilder = null;

    private EmbeddedServiceDefsUtil() {
    }

    public static EmbeddedServiceDefsUtil instance() {
        return instance;
    }

    public void init(ServiceStore store) {
        LOG.info((Object)"==> EmbeddedServiceDefsUtil.init()");
        try {
            this.createEmbeddedServiceDefs = RangerConfiguration.getInstance().getBoolean(PROPERTY_CREATE_EMBEDDED_SERVICE_DEFS, true);
            this.gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
            this.supportedServiceDefs = this.getSupportedServiceDef();
            this.hdfsServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HDFS_NAME);
            this.hBaseServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HBASE_NAME);
            this.hiveServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_HIVE_NAME);
            this.kmsServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KMS_NAME);
            this.knoxServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KNOX_NAME);
            this.stormServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_STORM_NAME);
            this.yarnServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_YARN_NAME);
            this.kafkaServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_KAFKA_NAME);
            this.solrServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_SOLR_NAME);
            this.nifiServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_NIFI_NAME);
            this.atlasServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_ATLAS_NAME);
            this.tagServiceDef = this.getOrCreateServiceDef(store, EMBEDDED_SERVICEDEF_TAG_NAME);
            store.updateTagServiceDefForAccessTypes();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"EmbeddedServiceDefsUtil.init(): failed", excp);
        }
        LOG.info((Object)"<== EmbeddedServiceDefsUtil.init()");
    }

    public long getHdfsServiceDefId() {
        return this.getId(this.hdfsServiceDef);
    }

    public long getHBaseServiceDefId() {
        return this.getId(this.hBaseServiceDef);
    }

    public long getHiveServiceDefId() {
        return this.getId(this.hiveServiceDef);
    }

    public long getKmsServiceDefId() {
        return this.getId(this.kmsServiceDef);
    }

    public long getKnoxServiceDefId() {
        return this.getId(this.knoxServiceDef);
    }

    public long getStormServiceDefId() {
        return this.getId(this.stormServiceDef);
    }

    public long getYarnServiceDefId() {
        return this.getId(this.yarnServiceDef);
    }

    public long getKafkaServiceDefId() {
        return this.getId(this.kafkaServiceDef);
    }

    public long getSolrServiceDefId() {
        return this.getId(this.solrServiceDef);
    }

    public long getNiFiServiceDefId() {
        return this.getId(this.nifiServiceDef);
    }

    public long getAtlasServiceDefId() {
        return this.getId(this.atlasServiceDef);
    }

    public long getTagServiceDefId() {
        return this.getId(this.tagServiceDef);
    }

    private long getId(RangerServiceDef serviceDef) {
        return serviceDef == null || serviceDef.getId() == null ? -1L : serviceDef.getId();
    }

    private RangerServiceDef getOrCreateServiceDef(ServiceStore store, String serviceDefName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> EmbeddedServiceDefsUtil.getOrCreateServiceDef(" + serviceDefName + ")"));
        }
        RangerServiceDef ret = null;
        boolean createServiceDef = CollectionUtils.isEmpty(this.supportedServiceDefs) || this.supportedServiceDefs.contains(serviceDefName);
        try {
            ret = store.getServiceDefByName(serviceDefName);
            if (ret == null && this.createEmbeddedServiceDefs && createServiceDef) {
                ret = this.loadEmbeddedServiceDef(serviceDefName);
                LOG.info((Object)("creating embedded service-def " + serviceDefName));
                if (ret.getId() != null) {
                    store.setPopulateExistingBaseFields(true);
                    ret = store.createServiceDef(ret);
                    store.setPopulateExistingBaseFields(false);
                } else {
                    ret = store.createServiceDef(ret);
                }
                LOG.info((Object)("created embedded service-def " + serviceDefName));
            }
        }
        catch (Exception excp) {
            LOG.fatal((Object)("EmbeddedServiceDefsUtil.getOrCreateServiceDef(): failed to load/create serviceType " + serviceDefName), (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== EmbeddedServiceDefsUtil.getOrCreateServiceDef(" + serviceDefName + "): " + ret));
        }
        return ret;
    }

    private RangerServiceDef loadEmbeddedServiceDef(String serviceType) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> EmbeddedServiceDefsUtil.loadEmbeddedServiceDef(" + serviceType + ")"));
        }
        RangerServiceDef ret = null;
        String resource = "/service-defs/ranger-servicedef-" + serviceType + ".json";
        InputStream inStream = this.getClass().getResourceAsStream(resource);
        InputStreamReader reader = new InputStreamReader(inStream);
        ret = (RangerServiceDef)this.gsonBuilder.fromJson((Reader)reader, RangerServiceDef.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> EmbeddedServiceDefsUtil.loadEmbeddedServiceDef(" + serviceType + ")"));
        }
        return ret;
    }

    private Set<String> getSupportedServiceDef() {
        HashSet<String> supportedServiceDef = new HashSet<String>();
        try {
            String[] supportedComponents;
            String ranger_supportedcomponents = RangerConfiguration.getInstance().get(PROPERTY_SUPPORTED_SERVICE_DEFS, DEFAULT_BOOTSTRAP_SERVICEDEF_LIST);
            if (StringUtils.isBlank((String)ranger_supportedcomponents) || "all".equalsIgnoreCase(ranger_supportedcomponents)) {
                ranger_supportedcomponents = DEFAULT_BOOTSTRAP_SERVICEDEF_LIST;
            }
            if ((supportedComponents = ranger_supportedcomponents.split(",")) != null && supportedComponents.length > 0) {
                for (String element : supportedComponents) {
                    if (StringUtils.isBlank((String)element) || supportedServiceDef.contains(element = element.toLowerCase())) continue;
                    supportedServiceDef.add(element);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportedServiceDef;
    }
}

