/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.AbstractServiceStore;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.SearchFilter;
import org.apache.ranger.plugin.util.ServicePolicies;

public class ServiceRESTStore
extends AbstractServiceStore {
    private static final Log LOG = LogFactory.getLog(ServiceRESTStore.class);
    public final String REST_URL_SERVICEDEF_CREATE = "/service/plugins/definitions";
    public final String REST_URL_SERVICEDEF_UPDATE = "/service/plugins/definitions/";
    public final String REST_URL_SERVICEDEF_DELETE = "/service/plugins/definitions/";
    public final String REST_URL_SERVICEDEF_GET = "/service/plugins/definitions/";
    public final String REST_URL_SERVICEDEF_GET_BY_NAME = "/service/plugins/definitions/name/";
    public final String REST_URL_SERVICEDEF_GET_ALL = "/service/plugins/definitions";
    public final String REST_URL_SERVICE_CREATE = "/service/plugins/services";
    public final String REST_URL_SERVICE_UPDATE = "/service/plugins/services/";
    public final String REST_URL_SERVICE_DELETE = "/service/plugins/services/";
    public final String REST_URL_SERVICE_GET = "/service/plugins/services/";
    public final String REST_URL_SERVICE_GET_BY_NAME = "/service/plugins/services/name/";
    public final String REST_URL_SERVICE_GET_ALL = "/service/plugins/services";
    public final String REST_URL_POLICY_CREATE = "/service/plugins/policies";
    public final String REST_URL_POLICY_UPDATE = "/service/plugins/policies/";
    public final String REST_URL_POLICY_DELETE = "/service/plugins/policies/";
    public final String REST_URL_POLICY_GET = "/service/plugins/policies/";
    public final String REST_URL_POLICY_GET_BY_NAME = "/service/plugins/policies/name/";
    public final String REST_URL_POLICY_GET_ALL = "/service/plugins/policies";
    public final String REST_URL_POLICY_GET_FOR_SERVICE = "/service/plugins/policies/service/";
    public final String REST_URL_POLICY_GET_FOR_SERVICE_BY_NAME = "/service/plugins/policies/service/name/";
    public final String REST_URL_POLICY_GET_FOR_SERVICE_IF_UPDATED = "/service/plugins/policies/download/";
    public final String REST_URL_POLICY_GET_FOR_SECURE_SERVICE_IF_UPDATED = "/service/plugins/secure/policies/download/";
    public static final String REST_MIME_TYPE_JSON = "application/json";
    private Boolean populateExistingBaseFields = false;
    private RangerRESTClient restClient;

    public ServiceRESTStore() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceRESTStore.ServiceRESTStore()");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== ServiceRESTStore.ServiceRESTStore()");
        }
    }

    @Override
    public void init() throws Exception {
        String restUrl = RangerConfiguration.getInstance().get("ranger.service.store.rest.url");
        String sslConfigFile = RangerConfiguration.getInstance().get("ranger.service.store.rest.ssl.config.file");
        String userName = RangerConfiguration.getInstance().get("ranger.service.store.rest.basicauth.username");
        String password = RangerConfiguration.getInstance().get("ranger.service.store.rest.basicauth.password");
        this.restClient = new RangerRESTClient(restUrl, sslConfigFile);
        this.restClient.setBasicAuthInfo(userName, password);
    }

    @Override
    public RangerServiceDef createServiceDef(RangerServiceDef serviceDef) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.createServiceDef(" + serviceDef + ")"));
        }
        RangerServiceDef ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/definitions");
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).post(ClientResponse.class, (Object)this.restClient.toJson(serviceDef));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerServiceDef)response.getEntity(RangerServiceDef.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.createServiceDef(" + serviceDef + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerServiceDef updateServiceDef(RangerServiceDef serviceDef) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.updateServiceDef(" + serviceDef + ")"));
        }
        RangerServiceDef ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/definitions/" + serviceDef.getId());
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).put(ClientResponse.class, (Object)this.restClient.toJson(serviceDef));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerServiceDef)response.getEntity(RangerServiceDef.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.updateServiceDef(" + serviceDef + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteServiceDef(Long id) throws Exception {
        WebResource webResource;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.deleteServiceDef(" + id + ")"));
        }
        if ((response = (ClientResponse)(webResource = this.createWebResource("/service/plugins/definitions/" + id)).accept(new String[]{REST_MIME_TYPE_JSON}).delete(ClientResponse.class)) == null || response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.deleteServiceDef(" + id + ")"));
        }
    }

    @Override
    public RangerServiceDef getServiceDef(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServiceDef(" + id + ")"));
        }
        RangerServiceDef ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/definitions/" + id);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerServiceDef)response.getEntity(RangerServiceDef.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServiceDef(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerServiceDef getServiceDefByName(String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServiceDefByName(" + name + ")"));
        }
        RangerServiceDef ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/definitions/name/" + name);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerServiceDef)response.getEntity(RangerServiceDef.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServiceDefByName(" + name + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerServiceDef> getServiceDefs(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceRESTStore.getServiceDefs()");
        }
        List ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/definitions", filter);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity((GenericType)new GenericType<List<RangerServiceDef>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getAllServiceDefs(): " + ret));
        }
        return ret;
    }

    @Override
    public RangerService createService(RangerService service) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.createService(" + service + ")"));
        }
        RangerService ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/services");
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).post(ClientResponse.class, (Object)this.restClient.toJson(service));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerService)response.getEntity(RangerService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.createService(" + service + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerService updateService(RangerService service) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.updateService(" + service + ")"));
        }
        RangerService ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/services/" + service.getId());
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).put(ClientResponse.class, (Object)this.restClient.toJson(service));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerService)response.getEntity(RangerService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.updateService(" + service + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteService(Long id) throws Exception {
        WebResource webResource;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.deleteService(" + id + ")"));
        }
        if ((response = (ClientResponse)(webResource = this.createWebResource("/service/plugins/services/" + id)).accept(new String[]{REST_MIME_TYPE_JSON}).delete(ClientResponse.class)) == null || response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.deleteService(" + id + ")"));
        }
    }

    @Override
    public RangerService getService(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getService(" + id + ")"));
        }
        RangerService ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/services/" + id);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerService)response.getEntity(RangerService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getService(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerService getServiceByName(String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServiceByName(" + name + ")"));
        }
        RangerService ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/services/name/" + name);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerService)response.getEntity(RangerService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServiceByName(" + name + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerService> getServices(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceRESTStore.getServices()");
        }
        List ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/services", filter);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity((GenericType)new GenericType<List<RangerService>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServices(): " + ret));
        }
        return ret;
    }

    @Override
    public RangerPolicy createPolicy(RangerPolicy policy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.createPolicy(" + policy + ")"));
        }
        RangerPolicy ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies");
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).post(ClientResponse.class, (Object)this.restClient.toJson(policy));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerPolicy)response.getEntity(RangerPolicy.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.createPolicy(" + policy + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerPolicy updatePolicy(RangerPolicy policy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.updatePolicy(" + policy + ")"));
        }
        RangerPolicy ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies/" + policy.getId());
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).type(REST_MIME_TYPE_JSON)).put(ClientResponse.class, (Object)this.restClient.toJson(policy));
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerPolicy)response.getEntity(RangerPolicy.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.updatePolicy(" + policy + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deletePolicy(Long id) throws Exception {
        WebResource webResource;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.deletePolicy(" + id + ")"));
        }
        if ((response = (ClientResponse)(webResource = this.createWebResource("/service/plugins/policies/" + id)).accept(new String[]{REST_MIME_TYPE_JSON}).delete(ClientResponse.class)) == null || response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.deletePolicy(" + id + ")"));
        }
    }

    @Override
    public RangerPolicy getPolicy(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getPolicy(" + id + ")"));
        }
        RangerPolicy ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies/" + id);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (RangerPolicy)response.getEntity(RangerPolicy.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getPolicy(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getPolicies(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceRESTStore.getPolicies()");
        }
        List ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies", filter);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity((GenericType)new GenericType<List<RangerPolicy>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getPolicies(): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getServicePolicies(Long serviceId, SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServicePolicies(" + serviceId + ")"));
        }
        List ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies/service/" + serviceId, filter);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity((GenericType)new GenericType<List<RangerPolicy>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServicePolicies(" + serviceId + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getServicePolicies(String serviceName, SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServicePolicies(" + serviceName + ")"));
        }
        List ret = null;
        WebResource webResource = this.createWebResource("/service/plugins/policies/service/name/" + serviceName, filter);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity((GenericType)new GenericType<List<RangerPolicy>>(){});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServicePolicies(" + serviceName + "): " + ret));
        }
        return ret;
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(final String serviceName, final Long lastKnownVersion) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceRESTStore.getServicePoliciesIfUpdated(" + serviceName + ", " + lastKnownVersion + ")"));
        }
        ServicePolicies ret = null;
        ClientResponse response = null;
        if (MiscUtil.getUGILoginUser() != null && UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)("Checking Service policy if updated as user : " + MiscUtil.getUGILoginUser()));
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = ServiceRESTStore.this.createWebResource("/service/plugins/secure/policies/download/" + serviceName + "/" + lastKnownVersion);
                    return (ClientResponse)secureWebResource.accept(new String[]{ServiceRESTStore.REST_MIME_TYPE_JSON}).get(ClientResponse.class);
                }
            };
            response = (ClientResponse)MiscUtil.getUGILoginUser().doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/policies/download/" + serviceName + "/" + lastKnownVersion);
            response = (ClientResponse)webResource.accept(new String[]{REST_MIME_TYPE_JSON}).get(ClientResponse.class);
        }
        if (response != null && response.getStatus() == 200) {
            ret = (ServicePolicies)response.getEntity(ServicePolicies.class);
        } else if (response == null || response.getStatus() != 304) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceRESTStore.getServicePoliciesIfUpdated(" + serviceName + ", " + lastKnownVersion + "): " + ret));
        }
        return ret;
    }

    @Override
    public ServicePolicies getServicePolicies(String serviceName) throws Exception {
        return this.getServicePoliciesIfUpdated(serviceName, -1L);
    }

    private WebResource createWebResource(String url) {
        return this.createWebResource(url, null);
    }

    private WebResource createWebResource(String url, SearchFilter filter) {
        WebResource ret = this.restClient.getResource(url);
        if (filter != null && !MapUtils.isEmpty(filter.getParams())) {
            for (Map.Entry<String, String> e : filter.getParams().entrySet()) {
                String name = e.getKey();
                String value = e.getValue();
                ret.queryParam(name, value);
            }
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getPoliciesByResourceSignature(String serviceName, String policySignature, Boolean isPolicyEnabled) throws Exception {
        throw new UnsupportedOperationException("Querying policies by resource signature is not supported!");
    }

    @Override
    public void setPopulateExistingBaseFields(Boolean populateExistingBaseFields) {
        this.populateExistingBaseFields = populateExistingBaseFields;
    }

    @Override
    public Boolean getPopulateExistingBaseFields() {
        return this.populateExistingBaseFields;
    }
}

