/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;

public class RangerPolicyResourceSignature {
    static final int _SignatureVersion = 1;
    private static final Log LOG = LogFactory.getLog(RangerPolicyResourceSignature.class);
    static final RangerPolicyResourceSignature _EmptyResourceSignature = new RangerPolicyResourceSignature((RangerPolicy)null);
    private final String _string;
    private final String _hash;
    private final RangerPolicy _policy;

    public RangerPolicyResourceSignature(RangerPolicy policy) {
        this._policy = policy;
        PolicySerializer serializer = new PolicySerializer(this._policy);
        this._string = serializer.toString();
        this._hash = DigestUtils.sha256Hex((String)this._string);
    }

    RangerPolicyResourceSignature(String string) {
        this._policy = null;
        this._string = string == null ? "" : string;
        this._hash = DigestUtils.sha256Hex((String)this._string);
    }

    String asString() {
        return this._string;
    }

    public String getSignature() {
        return this._hash;
    }

    public int hashCode() {
        return Objects.hashCode(this._hash);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RangerPolicyResourceSignature)) {
            return false;
        }
        RangerPolicyResourceSignature that = (RangerPolicyResourceSignature)object;
        return Objects.equals(this._hash, that._hash);
    }

    public String toString() {
        return String.format("%s: %s", this._hash, this._string);
    }

    static class ResourceSerializer {
        final RangerPolicy.RangerPolicyResource _policyResource;

        ResourceSerializer(RangerPolicy.RangerPolicyResource policyResource) {
            this._policyResource = policyResource;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            if (this._policyResource != null) {
                builder.append("values=");
                if (this._policyResource.getValues() != null) {
                    ArrayList<String> values = new ArrayList<String>(this._policyResource.getValues());
                    Collections.sort(values);
                    builder.append(values);
                }
                builder.append(",excludes=");
                if (this._policyResource.getIsExcludes() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this._policyResource.getIsExcludes());
                }
                builder.append(",recursive=");
                if (this._policyResource.getIsRecursive() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this._policyResource.getIsRecursive());
                }
            }
            builder.append("}");
            return builder.toString();
        }
    }

    static class PolicySerializer {
        final RangerPolicy _policy;

        PolicySerializer(RangerPolicy policy) {
            this._policy = policy;
        }

        boolean isPolicyValidForResourceSignatureComputation() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation(%s)", this._policy));
            }
            boolean valid = false;
            if (this._policy == null) {
                LOG.debug((Object)"isPolicyValidForResourceSignatureComputation: policy was null!");
            } else if (this._policy.getResources() == null) {
                LOG.debug((Object)"isPolicyValidForResourceSignatureComputation: resources collection on policy was null!");
            } else if (this._policy.getResources().containsKey(null)) {
                LOG.debug((Object)"isPolicyValidForResourceSignatureComputation: resources collection has resource with null name!");
            } else {
                valid = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("<== RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation(%s): %s", this._policy, valid));
            }
            return valid;
        }

        public String toString() {
            if (!this.isPolicyValidForResourceSignatureComputation()) {
                return "";
            }
            int type = 0;
            if (this._policy.getPolicyType() != null) {
                type = this._policy.getPolicyType();
            }
            TreeMap<String, ResourceSerializer> resources = new TreeMap<String, ResourceSerializer>();
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : this._policy.getResources().entrySet()) {
                String resourceName = entry.getKey();
                ResourceSerializer resourceView = new ResourceSerializer(entry.getValue());
                resources.put(resourceName, resourceView);
            }
            String resource = ((Object)resources).toString();
            if (CollectionUtils.isNotEmpty(this._policy.getValiditySchedules())) {
                resource = resource + this._policy.getValiditySchedules().toString();
            }
            if (this._policy.getPolicyPriority() != null && this._policy.getPolicyPriority() != 0) {
                resource = resource + this._policy.getPolicyPriority();
            }
            String result = String.format("{version=%d,type=%d,resource=%s}", 1, type, resource);
            return result;
        }
    }
}

