/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;

public interface RangerPolicyEvaluator
extends RangerPolicyResourceEvaluator {
    public static final Comparator<RangerPolicyEvaluator> EVAL_ORDER_COMPARATOR = new PolicyEvalOrderComparator();
    public static final Comparator<RangerPolicyEvaluator> NAME_COMPARATOR = new PolicyNameComparator();
    public static final Integer ACCESS_DENIED = -1;
    public static final Integer ACCESS_UNDETERMINED = 0;
    public static final Integer ACCESS_ALLOWED = 1;
    public static final Integer ACCESS_CONDITIONAL = 2;
    public static final String EVALUATOR_TYPE_AUTO = "auto";
    public static final String EVALUATOR_TYPE_OPTIMIZED = "optimized";
    public static final String EVALUATOR_TYPE_CACHED = "cached";

    public void init(RangerPolicy var1, RangerServiceDef var2, RangerPolicyEngineOptions var3);

    public RangerPolicy getPolicy();

    public RangerServiceDef getServiceDef();

    public boolean hasAllow();

    public boolean hasDeny();

    public int getPolicyPriority();

    public boolean isApplicable(Date var1);

    public int getEvalOrder();

    public long getUsageCount();

    public void incrementUsageCount(int var1);

    public void setUsageCountImmutable();

    public void resetUsageCount();

    public int getCustomConditionsCount();

    public int getValidityScheduleEvaluatorsCount();

    public boolean isAuditEnabled();

    public void evaluate(RangerAccessRequest var1, RangerAccessResult var2);

    public boolean isMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isCompleteMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> var1, Map<String, Object> var2);

    public boolean isAccessAllowed(RangerAccessResource var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(RangerPolicy var1, String var2, Set<String> var3, String var4);

    public void updateAccessResult(RangerAccessResult var1, RangerPolicyResourceMatcher.MatchType var2, boolean var3, String var4);

    public void getResourceAccessInfo(RangerAccessRequest var1, RangerResourceAccessInfo var2);

    public PolicyACLSummary getPolicyACLSummary();

    default public boolean hasContextSensitiveSpecification() {
        RangerPolicy policy = this.getPolicy();
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getPolicyItems()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyPolicyItems()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getAllowExceptions()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyExceptions()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasContextSensitiveSpecification(RangerPolicy.RangerPolicyItem policyItem) {
        return CollectionUtils.isNotEmpty(policyItem.getConditions()) || policyItem.getUsers().contains("{OWNER}");
    }

    public static class PolicyACLSummary {
        private final Map<String, Map<String, AccessResult>> usersAccessInfo = new HashMap<String, Map<String, AccessResult>>();
        private final Map<String, Map<String, AccessResult>> groupsAccessInfo = new HashMap<String, Map<String, AccessResult>>();

        PolicyACLSummary() {
        }

        public Map<String, Map<String, AccessResult>> getUsersAccessInfo() {
            return this.usersAccessInfo;
        }

        public Map<String, Map<String, AccessResult>> getGroupsAccessInfo() {
            return this.groupsAccessInfo;
        }

        void processPolicyItem(RangerPolicy.RangerPolicyItem policyItem, int policyItemType, boolean isConditional) {
            Integer result;
            boolean hasContextSensitiveSpecification = RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem);
            switch (policyItemType) {
                case 0: {
                    result = hasContextSensitiveSpecification || isConditional ? ACCESS_CONDITIONAL : ACCESS_ALLOWED;
                    break;
                }
                case 2: {
                    result = hasContextSensitiveSpecification || isConditional ? null : ACCESS_DENIED;
                    break;
                }
                case 1: {
                    result = hasContextSensitiveSpecification || isConditional ? ACCESS_CONDITIONAL : ACCESS_DENIED;
                    break;
                }
                case 3: {
                    result = hasContextSensitiveSpecification || isConditional ? null : ACCESS_ALLOWED;
                    break;
                }
                default: {
                    result = null;
                }
            }
            if (result != null) {
                List<RangerPolicy.RangerPolicyItemAccess> accesses;
                if (policyItem.getDelegateAdmin().booleanValue()) {
                    accesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
                    accesses.add(new RangerPolicy.RangerPolicyItemAccess("_admin", policyItem.getDelegateAdmin()));
                    accesses.addAll(policyItem.getAccesses());
                } else {
                    accesses = policyItem.getAccesses();
                }
                List<String> groups = policyItem.getGroups();
                List<String> users = policyItem.getUsers();
                boolean hasPublicGroup = false;
                for (RangerPolicy.RangerPolicyItemAccess access : accesses) {
                    for (String user : users) {
                        if (StringUtils.equals((String)user, (String)"{USER}")) {
                            hasPublicGroup = true;
                            continue;
                        }
                        if (StringUtils.isBlank((String)user)) continue;
                        this.addAccess(user, AccessorType.USER, access.getType(), result, policyItemType);
                    }
                    for (String group : groups) {
                        if (StringUtils.equals((String)group, (String)"public")) {
                            hasPublicGroup = true;
                            continue;
                        }
                        this.addAccess(group, AccessorType.GROUP, access.getType(), result, policyItemType);
                    }
                    if (!hasPublicGroup) continue;
                    this.addAccess("public", AccessorType.GROUP, access.getType(), result, policyItemType);
                }
            }
        }

        void finalizeAcls() {
            Map<String, AccessResult> publicGroupAccessInfo = this.groupsAccessInfo.get("public");
            if (publicGroupAccessInfo != null) {
                for (Map.Entry<String, AccessResult> entry : publicGroupAccessInfo.entrySet()) {
                    Map<String, AccessResult> mapValue;
                    String accessType = entry.getKey();
                    AccessResult accessResult = entry.getValue();
                    int access = accessResult.getResult();
                    if (access != ACCESS_DENIED && access != ACCESS_ALLOWED) continue;
                    ArrayList<String> keysToRemove = null;
                    for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.usersAccessInfo.entrySet()) {
                        mapValue = mapEntry.getValue();
                        mapValue.remove(accessType);
                        if (!mapValue.isEmpty()) continue;
                        if (keysToRemove == null) {
                            keysToRemove = new ArrayList<String>();
                        }
                        keysToRemove.add(mapEntry.getKey());
                    }
                    if (keysToRemove != null) {
                        for (String keyToRemove : keysToRemove) {
                            this.usersAccessInfo.remove(keyToRemove);
                        }
                        keysToRemove.clear();
                    }
                    for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.groupsAccessInfo.entrySet()) {
                        if (StringUtils.equals((String)mapEntry.getKey(), (String)"public")) continue;
                        mapValue = mapEntry.getValue();
                        mapValue.remove(accessType);
                        if (!mapValue.isEmpty()) continue;
                        if (keysToRemove == null) {
                            keysToRemove = new ArrayList();
                        }
                        keysToRemove.add(mapEntry.getKey());
                    }
                    if (keysToRemove == null) continue;
                    for (String keyToRemove : keysToRemove) {
                        this.groupsAccessInfo.remove(keyToRemove);
                    }
                    keysToRemove.clear();
                }
            }
        }

        private void addAccess(String accessorName, AccessorType accessorType, String accessType, Integer access, int policyItemType) {
            Map<String, Map<String, AccessResult>> accessorsAccessInfo;
            switch (accessorType) {
                case USER: {
                    accessorsAccessInfo = this.usersAccessInfo;
                    break;
                }
                case GROUP: {
                    accessorsAccessInfo = this.groupsAccessInfo;
                    break;
                }
                default: {
                    return;
                }
            }
            Map accessorAccessInfo = accessorsAccessInfo.computeIfAbsent(accessorName, k -> new HashMap());
            AccessResult currentAccess = (AccessResult)accessorAccessInfo.get(accessType);
            if (currentAccess == null) {
                if (policyItemType == 0 || policyItemType == 1) {
                    accessorAccessInfo.put(accessType, new AccessResult(access, policyItemType == 1));
                }
            } else if (access.equals(ACCESS_DENIED)) {
                if (currentAccess.getResult() == ACCESS_CONDITIONAL.intValue()) {
                    currentAccess.setResult(access);
                } else {
                    int updatedAccessValue = currentAccess.getResult() + access;
                    updatedAccessValue = policyItemType == 1 ? (updatedAccessValue < ACCESS_DENIED ? ACCESS_DENIED : updatedAccessValue) : (updatedAccessValue < ACCESS_UNDETERMINED ? ACCESS_UNDETERMINED : updatedAccessValue);
                    currentAccess.setResult(updatedAccessValue);
                }
            } else if (access.equals(ACCESS_ALLOWED)) {
                if (currentAccess.getResult() == ACCESS_CONDITIONAL.intValue()) {
                    if (policyItemType == 0) {
                        currentAccess.setResult(access);
                    }
                } else {
                    int updatedAccessValue = currentAccess.getResult() + access;
                    boolean replaceValue = false;
                    if (policyItemType == 0) {
                        updatedAccessValue = updatedAccessValue > ACCESS_ALLOWED ? ACCESS_ALLOWED : updatedAccessValue;
                        replaceValue = true;
                    } else {
                        int n = updatedAccessValue = updatedAccessValue > ACCESS_UNDETERMINED ? ACCESS_UNDETERMINED : updatedAccessValue;
                    }
                    if (replaceValue) {
                        accessorAccessInfo.put(accessType, new AccessResult(updatedAccessValue));
                    } else {
                        currentAccess.setResult(updatedAccessValue);
                    }
                }
            } else if (currentAccess.getResult() == ACCESS_UNDETERMINED.intValue()) {
                currentAccess.setResult(access);
            }
        }

        public static class AccessResult {
            private int result;
            private final boolean hasSeenDeny;

            public AccessResult(int result) {
                this(result, false);
            }

            public AccessResult(int result, boolean hasSeenDeny) {
                this.hasSeenDeny = hasSeenDeny;
                this.setResult(result);
            }

            public int getResult() {
                return this.result;
            }

            public void setResult(int result) {
                this.result = result;
            }

            public boolean getHasSeenDeny() {
                return this.hasSeenDeny;
            }

            public String toString() {
                if (this.result == ACCESS_ALLOWED) {
                    return "ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                if (this.result == ACCESS_DENIED) {
                    return "NOT_ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                if (this.result == ACCESS_CONDITIONAL) {
                    return "CONDITIONAL_ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                return "NOT_DETERMINED, hasSeenDeny=" + this.hasSeenDeny;
            }
        }

        private static enum AccessorType {
            USER,
            GROUP;

        }
    }

    public static class PolicyNameComparator
    implements Comparator<RangerPolicyEvaluator>,
    Serializable {
        @Override
        public int compare(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = Integer.compare(other.getPolicyPriority(), me.getPolicyPriority());
            return result == 0 ? this.compareNormal(me, other) : result;
        }

        private int compareNormal(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = me.hasDeny() && !other.hasDeny() ? -1 : (!me.hasDeny() && other.hasDeny() ? 1 : me.getPolicy().getName().compareTo(other.getPolicy().getName()));
            return result;
        }
    }

    public static class PolicyEvalOrderComparator
    implements Comparator<RangerPolicyEvaluator>,
    Serializable {
        @Override
        public int compare(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = Integer.compare(other.getPolicyPriority(), me.getPolicyPriority());
            return result == 0 ? this.compareNormal(me, other) : result;
        }

        private int compareNormal(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result;
            if (me.hasDeny() && !other.hasDeny()) {
                result = -1;
            } else if (!me.hasDeny() && other.hasDeny()) {
                result = 1;
            } else {
                result = Long.compare(other.getUsageCount(), me.getUsageCount());
                if (result == 0) {
                    result = Integer.compare(me.getEvalOrder(), other.getEvalOrder());
                }
            }
            return result;
        }
    }
}

