/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;

public class PolicyRefresher
extends Thread {
    private static final Log LOG = LogFactory.getLog(PolicyRefresher.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private final RangerBasePlugin plugIn;
    private final String serviceType;
    private final String serviceName;
    private final RangerAdminClient rangerAdmin;
    private final String cacheFileName;
    private final String cacheDir;
    private final Gson gson;
    private final boolean disableCacheIfServiceNotFound;
    private long pollingIntervalMs = 30000L;
    private long lastKnownVersion = -1L;
    private long lastActivationTimeInMillis;
    private boolean policiesSetInPlugin;
    private boolean serviceDefSetInPlugin;

    public PolicyRefresher(RangerBasePlugin plugIn, String serviceType, String appId, String serviceName, RangerAdminClient rangerAdmin, long pollingIntervalMs, String cacheDir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + serviceName + ").PolicyRefresher()"));
        }
        this.plugIn = plugIn;
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.rangerAdmin = rangerAdmin;
        this.pollingIntervalMs = pollingIntervalMs;
        if (StringUtils.isEmpty((String)appId)) {
            appId = serviceType;
        }
        String cacheFilename = String.format("%s_%s.json", appId, serviceName);
        cacheFilename = cacheFilename.replace(File.separatorChar, '_');
        this.cacheFileName = cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
        this.cacheDir = cacheDir;
        Gson gson = null;
        try {
            gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"PolicyRefresher(): failed to create GsonBuilder object", excp);
        }
        this.gson = gson;
        String propertyPrefix = "ranger.plugin." + serviceType;
        this.disableCacheIfServiceNotFound = RangerConfiguration.getInstance().getBoolean(propertyPrefix + ".disable.cache.if.servicenotfound", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + serviceName + ").PolicyRefresher()"));
        }
    }

    public RangerBasePlugin getPlugin() {
        return this.plugIn;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerAdminClient getRangerAdminClient() {
        return this.rangerAdmin;
    }

    public long getPollingIntervalMs() {
        return this.pollingIntervalMs;
    }

    public void setPollingIntervalMilliSeconds(long pollingIntervalMilliSeconds) {
        this.pollingIntervalMs = pollingIntervalMilliSeconds;
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    public void startRefresher() {
        this.loadPolicy();
        super.start();
    }

    public void stopRefresher() {
        super.interrupt();
        try {
            super.join();
        }
        catch (InterruptedException excp) {
            LOG.warn((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): error while waiting for thread to exit"), (Throwable)excp);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").run()"));
        }
        while (true) {
            this.loadPolicy();
            try {
                Thread.sleep(this.pollingIntervalMs);
            }
            catch (InterruptedException excp) {
                LOG.info((Object)("PolicyRefresher(serviceName=" + this.serviceName + ").run(): interrupted! Exiting thread"), (Throwable)excp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").run()"));
                }
                return;
            }
        }
    }

    private void loadPolicy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicy(serviceName=" + this.serviceName + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        try {
            ServicePolicies svcPolicies = this.loadPolicyfromPolicyAdmin();
            if (svcPolicies == null) {
                if (!this.policiesSetInPlugin) {
                    svcPolicies = this.loadFromCache();
                }
            } else {
                this.saveToCache(svcPolicies);
            }
            RangerPerfTracer.log(perf);
            if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
            }
            if (svcPolicies != null) {
                this.plugIn.setPolicies(svcPolicies);
                this.policiesSetInPlugin = true;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = svcPolicies.getPolicyVersion();
            } else if (!this.policiesSetInPlugin && !this.serviceDefSetInPlugin) {
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (this.disableCacheIfServiceNotFound) {
                this.disableCache();
                this.plugIn.setPolicies(null);
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (Exception excp) {
            LOG.error((Object)"Encountered unexpected exception, ignoring..", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()"));
        }
    }

    private ServicePolicies loadPolicyfromPolicyAdmin() throws RangerServiceNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()"));
        }
        ServicePolicies svcPolicies = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicyFromPolicyAdmin(serviceName=" + this.serviceName + ")");
        }
        try {
            boolean isUpdated;
            svcPolicies = this.rangerAdmin.getServicePoliciesIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = svcPolicies != null;
            if (isUpdated) {
                long newVersion;
                long l = newVersion = svcPolicies.getPolicyVersion() == null ? -1L : svcPolicies.getPolicyVersion();
                if (!StringUtils.equals((String)this.serviceName, (String)svcPolicies.getServiceName())) {
                    LOG.warn((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): ignoring unexpected serviceName '" + svcPolicies.getServiceName() + "' in service-store"));
                    svcPolicies.setServiceName(this.serviceName);
                }
                LOG.info((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): found updated version. lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + newVersion));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PolicyRefresher(serviceName=" + this.serviceName + ").run(): no update found. lastKnownVersion=" + this.lastKnownVersion));
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            LOG.error((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): failed to find service. Will clean up local cache of policies (" + this.lastKnownVersion + ")"), (Throwable)snfe);
            throw snfe;
        }
        catch (Exception excp) {
            LOG.error((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): failed to refresh policies. Will continue to use last known version of policies (" + this.lastKnownVersion + ")"), (Throwable)excp);
            svcPolicies = null;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()"));
        }
        return svcPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServicePolicies loadFromCache() {
        ServicePolicies policies;
        block18: {
            File cacheFile;
            block19: {
                RangerPerfTracer perf;
                FileReader reader;
                block17: {
                    policies = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()"));
                    }
                    File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
                    if (cacheFile == null || !cacheFile.isFile() || !cacheFile.canRead()) break block19;
                    reader = null;
                    perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadFromCache(serviceName=" + this.serviceName + ")");
                    }
                    try {
                        reader = new FileReader(cacheFile);
                        policies = (ServicePolicies)this.gson.fromJson((Reader)reader, ServicePolicies.class);
                        if (policies == null) break block17;
                        if (!StringUtils.equals((String)this.serviceName, (String)policies.getServiceName())) {
                            LOG.warn((Object)("ignoring unexpected serviceName '" + policies.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'"));
                            policies.setServiceName(this.serviceName);
                        }
                        this.lastKnownVersion = policies.getPolicyVersion() == null ? -1L : policies.getPolicyVersion();
                    }
                    catch (Exception excp) {
                        try {
                            LOG.error((Object)("failed to load policies from cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                        }
                        catch (Throwable throwable) {
                            RangerPerfTracer.log(perf);
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Exception excp2) {
                                    LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp2);
                                }
                            }
                            throw throwable;
                        }
                        RangerPerfTracer.log(perf);
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Exception excp3) {
                                LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp3);
                            }
                        }
                        break block18;
                    }
                }
                RangerPerfTracer.log(perf);
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                    }
                }
                break block18;
            }
            LOG.warn((Object)("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()"));
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToCache(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()"));
        }
        if (policies != null) {
            File cacheFile = null;
            if (this.cacheDir != null) {
                File cacheDirTmp = new File(this.cacheDir);
                if (cacheDirTmp.exists()) {
                    cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                } else {
                    try {
                        cacheDirTmp.mkdirs();
                        cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                    }
                    catch (SecurityException ex) {
                        LOG.error((Object)"Cannot create cache directory", (Throwable)ex);
                    }
                }
            }
            if (cacheFile != null) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    this.gson.toJson((Object)policies, (Appendable)writer);
                }
                catch (Exception excp) {
                    LOG.error((Object)("failed to save policies to cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Exception excp) {
                            LOG.error((Object)("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                        }
                    }
                }
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.info((Object)"policies is null. Nothing to save in cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()"));
        }
    }

    private void disableCache() {
        File cacheFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")"));
        }
        File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn((Object)"Cleaning up local cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error((Object)("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            } else {
                LOG.warn((Object)("Moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No local policy cache found. No need to disable it!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")"));
        }
    }
}

