/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;

public class RangerAdminRESTClient
extends AbstractRangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminRESTClient.class);
    private String serviceName;
    private String serviceNameUrlParam;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private RangerRESTUtils restUtils = new RangerRESTUtils();
    private String supportsPolicyDeltas = "true";

    public static <T> GenericType<List<T>> getGenericType(final T clazz) {
        ParameterizedType parameterizedGenericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz.getClass()};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        return new GenericType<List<T>>(parameterizedGenericType){};
    }

    @Override
    public void init(String serviceName, String appId, String propertyPrefix) {
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = "";
        String tmpUrl = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.ssl.config.file");
        this.clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty(this.clusterName)) {
            this.clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".ambari.cluster.name", "");
        }
        int restClientConnTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this.supportsPolicyDeltas = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.supports.policy.deltas", "false");
        if (!StringUtil.isEmpty(tmpUrl)) {
            url = tmpUrl.trim();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!"true".equalsIgnoreCase(this.supportsPolicyDeltas)) {
            this.supportsPolicyDeltas = "false";
        }
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam(serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Unsupported encoding, serviceName=" + serviceName));
            this.serviceNameUrlParam = serviceName;
        }
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        RESTResponse resp;
        ClientResponse response;
        UserGroupInformation user;
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean bl = isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service policy if updated as user : " + user));
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/policies/download/" + RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId).queryParam("clusterName", RangerAdminRESTClient.this.clusterName).queryParam("supportsPolicyDeltas", RangerAdminRESTClient.this.supportsPolicyDeltas);
                    return (ClientResponse)secureWebResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            WebResource webResource = this.createWebResource("/service/plugins/policies/download/" + this.serviceNameUrlParam).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", this.pluginId).queryParam("clusterName", this.clusterName).queryParam("supportsPolicyDeltas", this.supportsPolicyDeltas);
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (ServicePolicies)response.getEntity(ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            LOG.error((Object)("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            ret = null;
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerRole createRole(final RangerRole request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.createRole(" + request + ")"));
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/").queryParam("serviceName", RangerAdminRESTClient.this.serviceNameUrlParam);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("create role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/");
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during createRole. roleName=" + request.getName());
        }
        ret = (RangerRole)response.getEntity(RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.createRole(" + request + ")"));
        }
        return ret;
    }

    @Override
    public void dropRole(final String execUser, final String roleName) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.dropRole(" + roleName + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/name/" + roleName).queryParam("serviceName", RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("execUser", execUser);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).delete(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("drop role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/name/" + roleName).queryParam("execUser", execUser);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).delete(ClientResponse.class);
        }
        if (response == null) {
            throw new Exception("unknown error during deleteRole. roleName=" + roleName);
        }
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.deleteRole(" + roleName + ")"));
        }
    }

    @Override
    public List<String> getUserRoles(final String execUser) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getUserRoles(" + execUser + ")"));
        }
        List ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/user/" + execUser);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get roles as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/user/" + execUser);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getUserRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getUserRoles. execUser=" + execUser);
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getUserRoles(" + execUser + ")"));
        }
        return ret;
    }

    @Override
    public List<String> getAllRoles(final String execUser) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAdminRESTClient.getAllRoles()");
        }
        List ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/names/").queryParam("serviceName", RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("execUser", execUser);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get roles as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/names/").queryParam("execUser", execUser);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getAllRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getAllRoles.");
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAdminRESTClient.getAllRoles()");
        }
        return ret;
    }

    @Override
    public RangerRole getRole(final String execUser, final String roleName) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")"));
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/name/" + roleName).queryParam("serviceName", RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("execUser", execUser);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get role info as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/name/" + roleName).queryParam("execUser", execUser);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getPrincipalsForRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getPrincipalsForRole. roleName=" + roleName);
        }
        ret = (RangerRole)response.getEntity(RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")"));
        }
        return ret;
    }

    @Override
    public void grantRole(final GrantRevokeRoleRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantRole(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/grant/" + RangerAdminRESTClient.this.serviceNameUrlParam);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grant role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/grant/" + this.serviceNameUrlParam);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("grantRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantRole(" + request + ")"));
        }
    }

    @Override
    public void revokeRole(final GrantRevokeRoleRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.revokeRole(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/public/v2/api/roles/revoke/" + RangerAdminRESTClient.this.serviceNameUrlParam);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revoke role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/public/v2/api/roles/revoke/" + this.serviceNameUrlParam);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("revokeRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during revokeRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.revokeRole(" + request + ")"));
        }
    }

    @Override
    public void grantAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/grant/" + RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/grant/" + this.serviceNameUrlParam).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    @Override
    public void revokeAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/revoke/" + RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokeAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/revoke/" + this.serviceNameUrlParam).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
    }

    private WebResource createWebResource(String url) {
        WebResource ret = this.restClient.getResource(url);
        return ret;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        RESTResponse resp;
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        ServiceTags ret = null;
        ClientResponse response = null;
        WebResource webResource = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/tags/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)secureWebResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getServiceTagsIfUpdated as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            webResource = this.createWebResource("/service/tags/download/" + this.serviceNameUrlParam).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (ServiceTags)response.getEntity(ServiceTags.class);
        } else if (response.getStatus() == 404) {
            LOG.error((Object)("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): "));
        }
        List ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final WebResource webResource = this.createWebResource("/service/tags/lookup").queryParam("serviceName", this.serviceNameUrlParam).queryParam("pattern", pattern);
        ClientResponse response = null;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    return (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getTagTypes as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("Error getting tags. request=" + webResource + ", response=" + resp + ", serviceName=" + this.serviceName + ", pattern=" + pattern));
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret));
        }
        return ret;
    }
}

