/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.RangerGeolocationDatabase;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.store.GeolocationStore;

public abstract class RangerAbstractGeolocationProvider
extends RangerAbstractContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerAbstractGeolocationProvider.class);
    public static final String ENRICHER_OPTION_GEOLOCATION_META_PREFIX = "geolocation.meta.prefix";
    public static final String KEY_CONTEXT_GEOLOCATION_PREFIX = "LOCATION_";
    private GeolocationStore store;
    private String geoMetaPrefix;

    public abstract String getGeoSourceLoader();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractGeolocationProvider.init()");
        }
        super.init();
        this.geoMetaPrefix = this.getOption(ENRICHER_OPTION_GEOLOCATION_META_PREFIX);
        if (this.geoMetaPrefix == null) {
            this.geoMetaPrefix = "";
        }
        String geoSourceLoader = this.getGeoSourceLoader();
        GeolocationStore geoStore = null;
        Map<String, String> context = this.enricherDef.getEnricherOptions();
        if (context != null) {
            try {
                Class<?> geoSourceLoaderClass = Class.forName(geoSourceLoader);
                geoStore = (GeolocationStore)geoSourceLoaderClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error((Object)("RangerAbstractGeolocationProvider.init() - Class " + geoSourceLoader + " not found, exception=" + exception));
            }
            catch (ClassCastException exception) {
                LOG.error((Object)("RangerAbstractGeolocationProvider.init() - Class " + geoSourceLoader + " is not a type of GeolocationStore, exception=" + exception));
            }
            catch (IllegalAccessException exception) {
                LOG.error((Object)("RangerAbstractGeolocationProvider.init() - Class " + geoSourceLoader + " could not be instantiated, exception=" + exception));
            }
            catch (InstantiationException exception) {
                LOG.error((Object)("RangerAbstractGeolocationProvider.init() - Class " + geoSourceLoader + " could not be instantiated, exception=" + exception));
            }
            if (geoStore != null) {
                try {
                    geoStore.init(context);
                    this.store = geoStore;
                }
                catch (Exception exception) {
                    LOG.error((Object)("RangerAbstractGeolocationProvider.init() - geoLocation Store cannot be initialized, exception=" + exception));
                }
            }
        }
        if (this.store == null) {
            LOG.error((Object)"RangerAbstractGeolocationProvider.init() - is not initialized correctly.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAbstractGeolocationProvider.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractGeolocationProvider.enrich(" + request + ")"));
        }
        RangerGeolocationData geolocation = null;
        String clientIPAddress = request.getClientIPAddress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerAbstractGeolocationProvider.enrich() - clientIPAddress=" + clientIPAddress));
        }
        if (StringUtils.isNotBlank((String)clientIPAddress) && this.store != null) {
            geolocation = this.store.getGeoLocation(clientIPAddress);
            if (geolocation != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerAbstractGeolocationProvider.enrich() - Country=" + geolocation));
                }
                Map<String, Object> context = request.getContext();
                String[] geoAttrValues = geolocation.getLocationData();
                RangerGeolocationDatabase database = this.store.getGeoDatabase();
                String[] attributeNames = database.getMetadata().getLocationDataItemNames();
                for (int i = 0; i < geoAttrValues.length && i < attributeNames.length; ++i) {
                    String contextName = KEY_CONTEXT_GEOLOCATION_PREFIX + this.geoMetaPrefix + attributeNames[i];
                    context.put(contextName, geoAttrValues[i]);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerAbstractGeolocationProvider.enrich() - clientIPAddress '" + clientIPAddress + "' not found."));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RangerAbstractGeolocationProvider.enrich() - clientIPAddress is null or blank, cannot get geolocation");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractGeolocationProvider.enrich(" + request + ")"));
        }
    }
}

