/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public abstract class RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerBaseService.class);
    protected static final String ADMIN_USER_PRINCIPAL = "ranger.admin.kerberos.principal";
    protected static final String ADMIN_USER_KEYTAB = "ranger.admin.kerberos.keytab";
    protected static final String LOOKUP_PRINCIPAL = "ranger.lookup.kerberos.principal";
    protected static final String LOOKUP_KEYTAB = "ranger.lookup.kerberos.keytab";
    protected static final String RANGER_AUTH_TYPE = "hadoop.security.authentication";
    protected static final String KERBEROS_TYPE = "kerberos";
    protected RangerServiceDef serviceDef;
    protected RangerService service;
    protected Map<String, String> configs;
    protected String serviceName;
    protected String serviceType;

    public void init(RangerServiceDef serviceDef, RangerService service) {
        this.serviceDef = serviceDef;
        this.service = service;
        this.configs = service.getConfigs();
        this.serviceName = service.getName();
        this.serviceType = service.getType();
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public RangerService getService() {
        return this.service;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public abstract Map<String, Object> validateConfig() throws Exception;

    public abstract List<String> lookupResource(ResourceLookupContext var1) throws Exception;

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBaseService.getDefaultRangerPolicies() ");
        }
        Boolean additionalDefaultPolicySetup = Boolean.valueOf(this.configs.get("setup.additional.default.policies"));
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        try {
            RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef);
            for (List<RangerServiceDef.RangerResourceDef> aHierarchy : serviceDefHelper.filterHierarchies_containsOnlyMandatoryResources(0)) {
                RangerPolicy policy = this.getDefaultPolicy(aHierarchy);
                if (policy == null) continue;
                ret.add(policy);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting default polcies for Service: " + this.service.getName()), (Throwable)e);
        }
        if (additionalDefaultPolicySetup.booleanValue()) {
            String PROP_POLICY_NAME_PREFIX = "default-policy.";
            String PROP_POLICY_NAME_SUFFIX = ".name";
            TreeSet<String> policyIndexes = new TreeSet<String>();
            for (String configName : this.configs.keySet()) {
                if (!configName.startsWith("default-policy.") || !configName.endsWith(".name")) continue;
                policyIndexes.add(configName.substring("default-policy.".length(), configName.length() - ".name".length()));
            }
            for (String policyIndex : policyIndexes) {
                String resourcePropertyPrefix = "default-policy." + policyIndex + ".resource.";
                Map<String, RangerPolicy.RangerPolicyResource> policyResources = this.getResourcesForPrefix(resourcePropertyPrefix);
                if (!MapUtils.isNotEmpty(policyResources)) continue;
                this.addCustomRangerDefaultPolicies(ret, policyResources, policyIndex);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBaseService.getDefaultRangerPolicies(): " + ret));
        }
        return ret;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> getResourcesForPrefix(String resourcePropertyPrefix) {
        HashMap<String, RangerPolicy.RangerPolicyResource> policyResourceMap = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (this.configs != null) {
            for (Map.Entry<String, String> entry : this.configs.entrySet()) {
                if (entry.getKey().indexOf(resourcePropertyPrefix) <= -1 || !StringUtils.isNotBlank((String)entry.getValue())) continue;
                RangerPolicy.RangerPolicyResource rPolRes = new RangerPolicy.RangerPolicyResource();
                String resourceKey = entry.getKey().substring(resourcePropertyPrefix.length());
                ArrayList<String> resourceList = new ArrayList<String>(Arrays.asList(entry.getValue().split(",")));
                rPolRes.setIsExcludes(false);
                rPolRes.setIsRecursive(false);
                rPolRes.setValues(resourceList);
                policyResourceMap.put(resourceKey, rPolRes);
            }
        }
        return policyResourceMap;
    }

    private void addCustomRangerDefaultPolicies(List<RangerPolicy> ret, Map<String, RangerPolicy.RangerPolicyResource> policyResourceMap, String policyIndex) throws Exception {
        LOG.info((Object)"Setting additional default policies");
        String startConfigName = "default-policy.";
        RangerPolicy addDefaultPolicy1 = null;
        String policyName = this.configs.get(startConfigName + policyIndex + ".name");
        if (policyResourceMap != null && StringUtils.isNotBlank((String)policyName)) {
            String polItem1Users = this.configs.get(startConfigName + policyIndex + ".policyItem.1.users");
            String polItem2Users = this.configs.get(startConfigName + policyIndex + ".policyItem.2.users");
            String polItem1group = this.configs.get(startConfigName + policyIndex + ".policyItem.1.groups");
            String polItem2group = this.configs.get(startConfigName + policyIndex + ".policyItem.2.groups");
            String polItem1AccessTypes = this.configs.get(startConfigName + policyIndex + ".policyItem.1.accessTypes");
            String polItem2AccessTypes = this.configs.get(startConfigName + policyIndex + ".policyItem.2.accessTypes");
            if ((StringUtils.isNotBlank((String)polItem1Users) && StringUtils.isNotBlank((String)polItem1AccessTypes) || StringUtils.isNotBlank((String)polItem2Users) && StringUtils.isNotBlank((String)polItem2AccessTypes)) && (addDefaultPolicy1 = this.getRangerCustomPolicy(policyName, policyResourceMap, polItem1Users, polItem2Users, polItem1group, polItem2group, polItem1AccessTypes, polItem2AccessTypes)) != null) {
                ret.add(addDefaultPolicy1);
            }
        }
    }

    public RangerPolicy getRangerCustomPolicy(String policyName, Map<String, RangerPolicy.RangerPolicyResource> policyResourceMap, String polItem1Users, String polItem2Users, String polItem1Group, String polItem2Group, String polItem1AccessTypes, String polItem2AccessTypes) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBaseService.getAtlasTopicPolicy(). resourcenames" + policyResourceMap + "policy users = " + polItem1Users + polItem2Users + "policy groups = " + polItem1Group + polItem2Group + "accessLists "));
        }
        RangerPolicy rPolicy = new RangerPolicy();
        ArrayList<RangerPolicy.RangerPolicyItem> policyItemList = new ArrayList<RangerPolicy.RangerPolicyItem>();
        ArrayList<String> policyItem1UserList = new ArrayList<String>();
        ArrayList<String> policyItem2UserList = new ArrayList<String>();
        ArrayList<String> pol1Item1AccessTypeList = new ArrayList<String>();
        ArrayList<String> pol1Item2AccessTypeList = new ArrayList<String>();
        ArrayList<String> policyItem1GroupList = new ArrayList<String>();
        ArrayList<String> policyItem2GroupList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)polItem1Group)) {
            policyItem1GroupList.addAll(Arrays.asList(polItem1Group.split(",")));
        }
        if (StringUtils.isNotBlank((String)polItem2Group)) {
            policyItem2GroupList.addAll(Arrays.asList(polItem2Group.split(",")));
        }
        if (StringUtils.isNotBlank((String)polItem1Users)) {
            policyItem1UserList.addAll(Arrays.asList(polItem1Users.split(",")));
        }
        if (StringUtils.isNotBlank((String)polItem2Users)) {
            policyItem2UserList.addAll(Arrays.asList(polItem2Users.split(",")));
        }
        if (StringUtils.isNotBlank((String)polItem1AccessTypes)) {
            pol1Item1AccessTypeList.addAll(Arrays.asList(polItem1AccessTypes.split(",")));
        }
        if (StringUtils.isNotBlank((String)polItem2AccessTypes)) {
            pol1Item2AccessTypeList.addAll(Arrays.asList(polItem2AccessTypes.split(",")));
        }
        if ((CollectionUtils.isNotEmpty(policyItem1UserList) || CollectionUtils.isNotEmpty(policyItem1GroupList)) && CollectionUtils.isNotEmpty(pol1Item1AccessTypeList)) {
            RangerPolicy.RangerPolicyItem policyItem1 = this.setCustomPolItem(policyItem1UserList, pol1Item1AccessTypeList, policyItem1GroupList);
            policyItemList.add(policyItem1);
        }
        if ((CollectionUtils.isNotEmpty(policyItem2UserList) || CollectionUtils.isNotEmpty(policyItem2GroupList)) && CollectionUtils.isNotEmpty(pol1Item2AccessTypeList)) {
            RangerPolicy.RangerPolicyItem policyItem2 = this.setCustomPolItem(policyItem2UserList, pol1Item2AccessTypeList, policyItem2GroupList);
            policyItemList.add(policyItem2);
        }
        rPolicy.setPolicyItems(policyItemList);
        rPolicy.setIsEnabled(true);
        rPolicy.setVersion(1L);
        rPolicy.setIsAuditEnabled(true);
        rPolicy.setService(this.serviceName);
        rPolicy.setDescription("Policy for " + policyName);
        rPolicy.setName(policyName);
        rPolicy.setResources(policyResourceMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerBaseService.getAtlasTopicPolicy() ");
        }
        return rPolicy;
    }

    private RangerPolicy.RangerPolicyItem setCustomPolItem(List<String> userList, List<String> pol1Item1AccessTypeList, List<String> groupList) {
        RangerPolicy.RangerPolicyItem polItem = new RangerPolicy.RangerPolicyItem();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKafka.setCustomPolItem(). userlist = " + userList + " accessType" + pol1Item1AccessTypeList));
        }
        ArrayList<RangerPolicy.RangerPolicyItemAccess> polAccesslist = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        polItem.setDelegateAdmin(false);
        for (String pol1Item1AccessType : pol1Item1AccessTypeList) {
            RangerPolicy.RangerPolicyItemAccess polAccess = new RangerPolicy.RangerPolicyItemAccess();
            polAccess.setIsAllowed(true);
            polAccess.setType(pol1Item1AccessType);
            polAccesslist.add(polAccess);
        }
        polItem.setAccesses(polAccesslist);
        polItem.setUsers(userList);
        polItem.setGroups(groupList);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerServiceKafka.setCustomPolItem()");
        }
        return polItem;
    }

    private RangerPolicy getDefaultPolicy(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBaseService.getDefaultPolicy()");
        }
        RangerPolicy policy = new RangerPolicy();
        String policyName = this.buildPolicyName(resourceHierarchy);
        policy.setIsEnabled(true);
        policy.setVersion(1L);
        policy.setName(policyName);
        policy.setService(this.service.getName());
        policy.setDescription("Policy for " + policyName);
        policy.setIsAuditEnabled(true);
        policy.setResources(this.createDefaultPolicyResource(resourceHierarchy));
        ArrayList<RangerPolicy.RangerPolicyItem> policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(policy.getResources());
        policyItems.add(policyItem);
        policy.setPolicyItems(policyItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBaseService.getDefaultPolicy()" + policy));
        }
        return policy;
    }

    private RangerPolicy.RangerPolicyItem createDefaultPolicyItem(Map<String, RangerPolicy.RangerPolicyResource> policyResources) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBaseService.createDefaultPolicyItem()");
        }
        RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
        policyItem.setUsers(this.getUserList());
        List<RangerPolicy.RangerPolicyItemAccess> accesses = this.getAllowedAccesses(policyResources);
        policyItem.setAccesses(accesses);
        policyItem.setDelegateAdmin(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBaseService.createDefaultPolicyItem(): " + policyItem));
        }
        return policyItem;
    }

    protected List<RangerPolicy.RangerPolicyItemAccess> getAllowedAccesses(Map<String, RangerPolicy.RangerPolicyResource> policyResources) {
        ArrayList<RangerPolicy.RangerPolicyItemAccess> ret = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        RangerServiceDef.RangerResourceDef leafResourceDef = ServiceDefUtil.getLeafResourceDef(this.serviceDef, policyResources);
        if (leafResourceDef != null) {
            Set<String> accessTypeRestrictions = leafResourceDef.getAccessTypeRestrictions();
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : this.serviceDef.getAccessTypes()) {
                boolean isAccessTypeAllowed = CollectionUtils.isEmpty(accessTypeRestrictions) || accessTypeRestrictions.contains(accessTypeDef.getName());
                if (!isAccessTypeAllowed) continue;
                RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
                access.setType(accessTypeDef.getName());
                access.setIsAllowed(true);
                ret.add(access);
            }
        }
        return ret;
    }

    protected Map<String, RangerPolicy.RangerPolicyResource> createDefaultPolicyResource(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBaseService.createDefaultPolicyResource()");
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> resourceMap = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        for (RangerServiceDef.RangerResourceDef resourceDef : resourceHierarchy) {
            RangerPolicy.RangerPolicyResource polRes = new RangerPolicy.RangerPolicyResource();
            polRes.setIsExcludes(false);
            polRes.setIsRecursive(resourceDef.getRecursiveSupported());
            polRes.setValue("*");
            resourceMap.put(resourceDef.getName(), polRes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBaseService.createDefaultPolicyResource():" + resourceMap));
        }
        return resourceMap;
    }

    private String buildPolicyName(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) {
        StringBuilder sb = new StringBuilder("all");
        if (CollectionUtils.isNotEmpty(resourceHierarchy)) {
            int resourceDefCount = 0;
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceHierarchy) {
                if (resourceDefCount > 0) {
                    sb.append(", ");
                } else {
                    sb.append(" - ");
                }
                sb.append(resourceDef.getName());
                ++resourceDefCount;
            }
        }
        return sb.toString().trim();
    }

    private List<String> getUserList() {
        String lookupKeytab;
        String lookupPrincipal;
        String authType;
        String lookUpUser;
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, String> serviceConfig = this.service.getConfigs();
        if (serviceConfig != null) {
            ArrayList<String> defaultUserList;
            String defaultUsers;
            String serviceConfigUser = serviceConfig.get("username");
            if (StringUtils.isNotBlank((String)serviceConfigUser)) {
                ret.add(serviceConfig.get("username"));
            }
            if (!StringUtils.isEmpty((String)(defaultUsers = serviceConfig.get("default.policy.users"))) && !(defaultUserList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)defaultUsers, (String)",")))).isEmpty()) {
                ret.addAll(defaultUserList);
            }
        }
        if (StringUtils.isNotBlank((String)(lookUpUser = this.getLookupUser(authType = RangerConfiguration.getInstance().get(RANGER_AUTH_TYPE, "simple"), lookupPrincipal = RangerConfiguration.getInstance().get(LOOKUP_PRINCIPAL), lookupKeytab = RangerConfiguration.getInstance().get(LOOKUP_KEYTAB))))) {
            ret.add(lookUpUser);
        }
        return ret;
    }

    protected String getLookupUser(String authType, String lookupPrincipal, String lookupKeytab) {
        String lookupUser = null;
        if (!StringUtils.isEmpty((String)authType) && authType.equalsIgnoreCase(KERBEROS_TYPE) && SecureClientLogin.isKerberosCredentialExists(lookupPrincipal, lookupKeytab)) {
            KerberosName krbName = new KerberosName(lookupPrincipal);
            try {
                lookupUser = krbName.getShortName();
            }
            catch (IOException e) {
                LOG.error((Object)"Unknown lookup user", (Throwable)e);
            }
        }
        return lookupUser;
    }
}

