/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.slf4j.LoggerFactory;

public class BrokerStartup {
    public static Properties properties = null;
    public static CommandLine commandLine = null;
    public static String configFile = null;
    public static InternalLogger log;

    public static void main(String[] args) {
        BrokerStartup.start(BrokerStartup.createBrokerController(args));
    }

    public static BrokerController start(BrokerController controller) {
        try {
            controller.start();
            String tip = "The broker[" + controller.getBrokerConfig().getBrokerName() + ", " + controller.getBrokerAddr() + "] boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
            if (null != controller.getBrokerConfig().getNamesrvAddr()) {
                tip = tip + " and name server is " + controller.getBrokerConfig().getNamesrvAddr();
            }
            log.info(tip);
            System.out.printf("%s%n", tip);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static void shutdown(BrokerController controller) {
        if (null != controller) {
            controller.shutdown();
        }
    }

    public static BrokerController createBrokerController(String[] args) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        if (null == System.getProperty("com.rocketmq.remoting.socket.sndbuf.size")) {
            NettySystemConfig.socketSndbufSize = 131072;
        }
        if (null == System.getProperty("com.rocketmq.remoting.socket.rcvbuf.size")) {
            NettySystemConfig.socketRcvbufSize = 131072;
        }
        try {
            String namesrvAddr;
            String file;
            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
            commandLine = ServerUtil.parseCmdLine((String)"mqbroker", (String[])args, (Options)BrokerStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
            if (null == commandLine) {
                System.exit(-1);
            }
            BrokerConfig brokerConfig = new BrokerConfig();
            NettyServerConfig nettyServerConfig = new NettyServerConfig();
            NettyClientConfig nettyClientConfig = new NettyClientConfig();
            nettyClientConfig.setUseTLS(Boolean.parseBoolean(System.getProperty("tls.enable", String.valueOf(TlsSystemConfig.tlsMode == TlsMode.ENFORCING))));
            nettyServerConfig.setListenPort(10911);
            MessageStoreConfig messageStoreConfig = new MessageStoreConfig();
            if (BrokerRole.SLAVE == messageStoreConfig.getBrokerRole()) {
                int ratio = messageStoreConfig.getAccessMessageInMemoryMaxRatio() - 10;
                messageStoreConfig.setAccessMessageInMemoryMaxRatio(ratio);
            }
            if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
                configFile = file;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                properties = new Properties();
                properties.load(in);
                BrokerStartup.properties2SystemEnv(properties);
                MixAll.properties2Object((Properties)properties, (Object)brokerConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
                MixAll.properties2Object((Properties)properties, (Object)messageStoreConfig);
                BrokerPathConfigHelper.setBrokerConfigPath(file);
                ((InputStream)in).close();
            }
            MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)brokerConfig);
            if (null == brokerConfig.getRocketmqHome()) {
                System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation", "ROCKETMQ_HOME");
                System.exit(-2);
            }
            if (null != (namesrvAddr = brokerConfig.getNamesrvAddr())) {
                try {
                    String[] addrArray;
                    for (String addr : addrArray = namesrvAddr.split(";")) {
                        RemotingUtil.string2SocketAddress((String)addr);
                    }
                }
                catch (Exception e) {
                    System.out.printf("The Name Server Address[%s] illegal, please set it as follows, \"127.0.0.1:9876;192.168.0.1:9876\"%n", namesrvAddr);
                    System.exit(-3);
                }
            }
            switch (messageStoreConfig.getBrokerRole()) {
                case ASYNC_MASTER: 
                case SYNC_MASTER: {
                    brokerConfig.setBrokerId(0L);
                    break;
                }
                case SLAVE: {
                    if (brokerConfig.getBrokerId() > 0L) break;
                    System.out.printf("Slave's brokerId must be > 0", new Object[0]);
                    System.exit(-3);
                    break;
                }
            }
            if (messageStoreConfig.isEnableDLegerCommitLog()) {
                brokerConfig.setBrokerId(-1L);
            }
            messageStoreConfig.setHaListenPort(nettyServerConfig.getListenPort() + 1);
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(brokerConfig.getRocketmqHome() + "/conf/logback_broker.xml");
            if (commandLine.hasOption('p')) {
                InternalLogger console = InternalLoggerFactory.getLogger((String)"RocketmqConsole");
                MixAll.printObjectProperties((InternalLogger)console, (Object)brokerConfig);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyServerConfig);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyClientConfig);
                MixAll.printObjectProperties((InternalLogger)console, (Object)messageStoreConfig);
                System.exit(0);
            } else if (commandLine.hasOption('m')) {
                InternalLogger console = InternalLoggerFactory.getLogger((String)"RocketmqConsole");
                MixAll.printObjectProperties((InternalLogger)console, (Object)brokerConfig, (boolean)true);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyServerConfig, (boolean)true);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyClientConfig, (boolean)true);
                MixAll.printObjectProperties((InternalLogger)console, (Object)messageStoreConfig, (boolean)true);
                System.exit(0);
            }
            log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
            MixAll.printObjectProperties((InternalLogger)log, (Object)brokerConfig);
            MixAll.printObjectProperties((InternalLogger)log, (Object)nettyServerConfig);
            MixAll.printObjectProperties((InternalLogger)log, (Object)nettyClientConfig);
            MixAll.printObjectProperties((InternalLogger)log, (Object)messageStoreConfig);
            final BrokerController controller = new BrokerController(brokerConfig, nettyServerConfig, nettyClientConfig, messageStoreConfig);
            controller.getConfiguration().registerConfig(properties);
            boolean initResult = controller.initialize();
            if (!initResult) {
                controller.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;
                private AtomicInteger shutdownTimes = new AtomicInteger(0);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        log.info("Shutdown hook was invoked, {}", (Object)this.shutdownTimes.incrementAndGet());
                        if (!this.hasShutdown) {
                            this.hasShutdown = true;
                            long beginTime = System.currentTimeMillis();
                            controller.shutdown();
                            long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                            log.info("Shutdown hook over, consuming total time(ms): {}", (Object)consumingTimeTotal);
                        }
                    }
                }
            }, "ShutdownHook"));
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private static void properties2SystemEnv(Properties properties) {
        if (properties == null) {
            return;
        }
        String rmqAddressServerDomain = properties.getProperty("rmqAddressServerDomain", MixAll.WS_DOMAIN_NAME);
        String rmqAddressServerSubGroup = properties.getProperty("rmqAddressServerSubGroup", MixAll.WS_DOMAIN_SUBGROUP);
        System.setProperty("rocketmq.namesrv.domain", rmqAddressServerDomain);
        System.setProperty("rocketmq.namesrv.domain.subgroup", rmqAddressServerSubGroup);
    }

    private static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Broker config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "printImportantConfig", false, "Print important config item");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }
}

