/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupResponseBody;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupResponseHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetResponseHeader;
import org.apache.rocketmq.common.rpc.RpcClientUtils;
import org.apache.rocketmq.common.rpc.RpcRequest;
import org.apache.rocketmq.common.rpc.RpcRequestHeader;
import org.apache.rocketmq.common.rpc.RpcResponse;
import org.apache.rocketmq.common.rpc.TopicRequestHeader;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ConsumerManageProcessor
extends AsyncNettyRequestProcessor
implements NettyRequestProcessor {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public ConsumerManageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 38: {
                return this.getConsumerListByGroup(ctx, request);
            }
            case 15: {
                return this.updateConsumerOffset(ctx, request);
            }
            case 14: {
                return this.queryConsumerOffset(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand getConsumerListByGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetConsumerListByGroupResponseHeader.class);
        GetConsumerListByGroupRequestHeader requestHeader = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
        if (consumerGroupInfo != null) {
            List<String> clientIds = consumerGroupInfo.getAllClientId();
            if (!clientIds.isEmpty()) {
                GetConsumerListByGroupResponseBody body = new GetConsumerListByGroupResponseBody();
                body.setConsumerIdList(clientIds);
                response.setBody(body.encode());
                response.setCode(0);
                response.setRemark(null);
                return response;
            }
            log.warn("getAllClientId failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        } else {
            log.warn("getConsumerGroupInfo failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        response.setCode(1);
        response.setRemark("no consumer for this group, " + requestHeader.getConsumerGroup());
        return response;
    }

    public RemotingCommand rewriteRequestForStaticTopic(UpdateConsumerOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", requestHeader.getTopic(), requestHeader.getQueueId(), mappingDetail.getBname()));
            }
            Long globalOffset = requestHeader.getCommitOffset();
            LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)globalOffset, (boolean)true);
            requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setBname(mappingItem.getBname());
            requestHeader.setCommitOffset(Long.valueOf(mappingItem.computePhysicalQueueOffset(globalOffset.longValue())));
            if (mappingDetail.getBname().equals(mappingItem.getBname())) {
                return null;
            }
            RpcRequest rpcRequest = new RpcRequest(15, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand updateConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(UpdateConsumerOffsetResponseHeader.class);
        UpdateConsumerOffsetRequestHeader requestHeader = (UpdateConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        this.brokerController.getConsumerOffsetManager().commitOffset(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand rewriteRequestForStaticTopic(QueryConsumerOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", requestHeader.getTopic(), requestHeader.getQueueId(), mappingDetail.getBname()));
            }
            List mappingItemList = mappingContext.getMappingItemList();
            if (mappingItemList.size() == 1 && ((LogicQueueMappingItem)mappingItemList.get(0)).getLogicOffset() == 0L) {
                mappingContext.setCurrentItem((LogicQueueMappingItem)mappingItemList.get(0));
                requestHeader.setQueueId(Integer.valueOf(mappingContext.getLeaderItem().getQueueId()));
                return null;
            }
            List itemList = mappingContext.getMappingItemList();
            long offset = -1L;
            for (int i = itemList.size() - 1; i >= 0; --i) {
                LogicQueueMappingItem mappingItem = (LogicQueueMappingItem)itemList.get(i);
                mappingContext.setCurrentItem(mappingItem);
                if (mappingItem.getBname().equals(mappingDetail.getBname())) {
                    offset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), mappingItem.getQueueId());
                    if (offset < 0L) continue;
                    break;
                }
                requestHeader.setBname(mappingItem.getBname());
                requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
                requestHeader.setLo(Boolean.valueOf(false));
                requestHeader.setSetZeroIfNotFound(Boolean.valueOf(false));
                RpcRequest rpcRequest = new RpcRequest(14, (RpcRequestHeader)requestHeader, null);
                RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
                if (rpcResponse.getException() != null) {
                    throw rpcResponse.getException();
                }
                if (rpcResponse.getCode() == 0) {
                    offset = ((QueryConsumerOffsetResponseHeader)rpcResponse.getHeader()).getOffset();
                    break;
                }
                if (rpcResponse.getCode() == 22) continue;
                throw new RuntimeException("Unknown response code " + rpcResponse.getCode());
            }
            RemotingCommand response = RemotingCommand.createResponseCommand(QueryConsumerOffsetResponseHeader.class);
            QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.readCustomHeader();
            if (offset >= 0L) {
                responseHeader.setOffset(Long.valueOf(offset));
                response.setCode(0);
                response.setRemark(null);
            } else {
                response.setCode(22);
                response.setRemark("Not found, maybe this group consumer boot first");
            }
            RemotingCommand rewriteResponseResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode());
            if (rewriteResponseResult != null) {
                return rewriteResponseResult;
            }
            return response;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    public RemotingCommand rewriteResponseForStaticTopic(QueryConsumerOffsetRequestHeader requestHeader, QueryConsumerOffsetResponseHeader responseHeader, TopicQueueMappingContext mappingContext, int code) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            if (code != 0) {
                return null;
            }
            LogicQueueMappingItem item = mappingContext.getCurrentItem();
            responseHeader.setOffset(Long.valueOf(item.computeStaticQueueOffsetStrictly(responseHeader.getOffset().longValue())));
            return null;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand queryConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryConsumerOffsetResponseHeader.class);
        QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.readCustomHeader();
        QueryConsumerOffsetRequestHeader requestHeader = (QueryConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(QueryConsumerOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
        if (offset >= 0L) {
            responseHeader.setOffset(Long.valueOf(offset));
            response.setCode(0);
            response.setRemark(null);
        } else {
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            if (requestHeader.getSetZeroIfNotFound() != null && Boolean.FALSE.equals(requestHeader.getSetZeroIfNotFound())) {
                response.setCode(22);
                response.setRemark("Not found, do not set to zero, maybe this group boot first");
            } else if (minOffset <= 0L && !this.brokerController.getMessageStore().checkInDiskByConsumeOffset(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), 0L)) {
                responseHeader.setOffset(Long.valueOf(0L));
                response.setCode(0);
                response.setRemark(null);
            } else {
                response.setCode(22);
                response.setRemark("Not found, V3_0_6_SNAPSHOT maybe this group consumer boot first");
            }
        }
        RemotingCommand rewriteResponseResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode());
        if (rewriteResponseResult != null) {
            return rewriteResponseResult;
        }
        return response;
    }
}

