/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionForRetryMessageFilter;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.pagecache.ManyMessageTransfer;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.filter.FilterAPI;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.protocol.topic.OffsetMovedEvent;
import org.apache.rocketmq.common.rpc.RpcClientUtils;
import org.apache.rocketmq.common.rpc.RpcRequest;
import org.apache.rocketmq.common.rpc.RpcRequestHeader;
import org.apache.rocketmq.common.rpc.RpcResponse;
import org.apache.rocketmq.common.rpc.TopicRequestHeader;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class PullMessageProcessor
extends AsyncNettyRequestProcessor
implements NettyRequestProcessor {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private List<ConsumeMessageHook> consumeMessageHookList;

    public PullMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand rewriteRequestForStaticTopic(PullMessageRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            String topic = mappingContext.getTopic();
            Integer globalId = mappingContext.getGlobalId();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d cannot find mapping item in request process of current broker %s", topic, globalId, mappingDetail.getBname()));
            }
            Long globalOffset = requestHeader.getQueueOffset();
            LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)globalOffset, (boolean)true);
            mappingContext.setCurrentItem(mappingItem);
            if (globalOffset < mappingItem.getLogicOffset()) {
                // empty if block
            }
            String bname = mappingItem.getBname();
            Integer phyQueueId = mappingItem.getQueueId();
            Long phyQueueOffset = mappingItem.computePhysicalQueueOffset(globalOffset.longValue());
            requestHeader.setQueueId(phyQueueId);
            requestHeader.setQueueOffset(phyQueueOffset);
            if (mappingItem.checkIfEndOffsetDecided() && requestHeader.getMaxMsgNums() != null) {
                requestHeader.setMaxMsgNums(Integer.valueOf((int)Math.min(mappingItem.getEndOffset() - mappingItem.getStartOffset(), (long)requestHeader.getMaxMsgNums().intValue())));
            }
            if (mappingDetail.getBname().equals(bname)) {
                return null;
            }
            int sysFlag = requestHeader.getSysFlag();
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setBname(bname);
            sysFlag = PullSysFlag.clearSuspendFlag((int)sysFlag);
            sysFlag = PullSysFlag.clearCommitOffsetFlag((int)sysFlag);
            requestHeader.setSysFlag(Integer.valueOf(sysFlag));
            RpcRequest rpcRequest = new RpcRequest(11, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)rpcResponse.getHeader();
            RemotingCommand rewriteResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, rpcResponse.getCode());
            if (rewriteResult != null) {
                return rewriteResult;
            }
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand rewriteResponseForStaticTopic(PullMessageRequestHeader requestHeader, PullMessageResponseHeader responseHeader, TopicQueueMappingContext mappingContext, int code) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            LogicQueueMappingItem leaderItem = mappingContext.getLeaderItem();
            LogicQueueMappingItem currentItem = mappingContext.getCurrentItem();
            LogicQueueMappingItem earlistItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)0L, (boolean)true);
            assert (currentItem.getLogicOffset() >= 0L);
            long requestOffset = requestHeader.getQueueOffset();
            long nextBeginOffset = responseHeader.getNextBeginOffset();
            long minOffset = responseHeader.getMinOffset();
            long maxOffset = responseHeader.getMaxOffset();
            int responseCode = code;
            if (code != 0) {
                LogicQueueMappingItem nextItem;
                boolean isRevised = false;
                if (leaderItem.getGen() == currentItem.getGen()) {
                    if (requestOffset > maxOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = maxOffset;
                        } else {
                            responseCode = code;
                        }
                    } else if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else {
                        responseCode = code;
                    }
                }
                if (earlistItem.getGen() == currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        } else {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        }
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            isRevised = true;
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
                if (!isRevised && leaderItem.getGen() != currentItem.getGen() && earlistItem.getGen() != currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
            }
            if (currentItem.checkIfEndOffsetDecided() && nextBeginOffset >= currentItem.getEndOffset()) {
                nextBeginOffset = currentItem.getEndOffset();
            }
            responseHeader.setNextBeginOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(nextBeginOffset)));
            responseHeader.setMinOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(Math.max(currentItem.getStartOffset(), minOffset))));
            responseHeader.setMaxOffset(Long.valueOf(Math.max(currentItem.computeStaticQueueOffsetStrictly(maxOffset), TopicQueueMappingDetail.computeMaxOffsetFromMapping((TopicQueueMappingDetail)mappingDetail, (Integer)mappingContext.getGlobalId()))));
            responseHeader.setOffsetDelta(Long.valueOf(currentItem.computeOffsetDelta()));
            if (code != 0) {
                return RemotingCommand.createResponseCommandWithHeader((int)responseCode, (CommandCustomHeader)responseHeader);
            }
            return null;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemotingCommand processRequest(final Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        boolean hasCommitOffsetFlag;
        PullMessageRequestHeader requestHeader;
        RemotingCommand response;
        block69: {
            block68: {
                RemotingCommand rewriteResult;
                void var19_21;
                ConsumerFilterData consumerFilterData;
                SubscriptionData subscriptionData;
                TopicQueueMappingContext mappingContext;
                long suspendTimeoutMillisLong;
                boolean hasSuspendFlag;
                SubscriptionGroupConfig subscriptionGroupConfig;
                PullMessageResponseHeader responseHeader;
                long beginTimeMills;
                block66: {
                    beginTimeMills = this.brokerController.getMessageStore().now();
                    response = RemotingCommand.createResponseCommand(PullMessageResponseHeader.class);
                    responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
                    requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
                    response.setOpaque(request.getOpaque());
                    log.debug("receive PullMessage request command, {}", (Object)request);
                    if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
                        response.setCode(16);
                        response.setRemark(String.format("the broker[%s] pulling message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
                        return response;
                    }
                    subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
                    if (null == subscriptionGroupConfig) {
                        response.setCode(26);
                        response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
                        return response;
                    }
                    if (!subscriptionGroupConfig.isConsumeEnable()) {
                        response.setCode(16);
                        response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
                        return response;
                    }
                    hasSuspendFlag = PullSysFlag.hasSuspendFlag((int)requestHeader.getSysFlag());
                    hasCommitOffsetFlag = PullSysFlag.hasCommitOffsetFlag((int)requestHeader.getSysFlag());
                    boolean hasSubscriptionFlag = PullSysFlag.hasSubscriptionFlag((int)requestHeader.getSysFlag());
                    suspendTimeoutMillisLong = hasSuspendFlag ? requestHeader.getSuspendTimeoutMillis() : 0L;
                    TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
                    if (null == topicConfig) {
                        log.error("the topic {} not exist, consumer: {}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                        response.setCode(17);
                        response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
                        return response;
                    }
                    if (!PermName.isReadable((int)topicConfig.getPerm())) {
                        response.setCode(16);
                        response.setRemark("the topic[" + requestHeader.getTopic() + "] pulling message is forbidden");
                        return response;
                    }
                    mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, false);
                    RemotingCommand rewriteResult2 = this.rewriteRequestForStaticTopic(requestHeader, mappingContext);
                    if (rewriteResult2 != null) {
                        return rewriteResult2;
                    }
                    if (requestHeader.getQueueId() < 0 || requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
                        String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
                        log.warn(errorInfo);
                        response.setCode(1);
                        response.setRemark(errorInfo);
                        return response;
                    }
                    subscriptionData = null;
                    consumerFilterData = null;
                    if (hasSubscriptionFlag) {
                        try {
                            subscriptionData = FilterAPI.build((String)requestHeader.getTopic(), (String)requestHeader.getSubscription(), (String)requestHeader.getExpressionType());
                            if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                                consumerFilterData = ConsumerFilterManager.build(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getSubscription(), requestHeader.getExpressionType(), requestHeader.getSubVersion());
                                assert (consumerFilterData != null);
                            }
                            break block66;
                        }
                        catch (Exception exception) {
                            log.warn("Parse the consumer's subscription[{}] failed, group: {}", (Object)requestHeader.getSubscription(), (Object)requestHeader.getConsumerGroup());
                            response.setCode(23);
                            response.setRemark("parse the consumer's subscription failed");
                            return response;
                        }
                    }
                    ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
                    if (null == consumerGroupInfo) {
                        log.warn("the consumer's group info not exist, group: {}", (Object)requestHeader.getConsumerGroup());
                        response.setCode(24);
                        response.setRemark("the consumer's group info not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                        return response;
                    }
                    if (!subscriptionGroupConfig.isConsumeBroadcastEnable() && consumerGroupInfo.getMessageModel() == MessageModel.BROADCASTING) {
                        response.setCode(16);
                        response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] can not consume by broadcast way");
                        return response;
                    }
                    subscriptionData = consumerGroupInfo.findSubscriptionData(requestHeader.getTopic());
                    if (null == subscriptionData) {
                        log.warn("the consumer's subscription not exist, group: {}, topic:{}", (Object)requestHeader.getConsumerGroup(), (Object)requestHeader.getTopic());
                        response.setCode(24);
                        response.setRemark("the consumer's subscription not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                        return response;
                    }
                    if (subscriptionData.getSubVersion() < requestHeader.getSubVersion()) {
                        log.warn("The broker's subscription is not latest, group: {} {}", (Object)requestHeader.getConsumerGroup(), (Object)subscriptionData.getSubString());
                        response.setCode(25);
                        response.setRemark("the consumer's subscription not latest");
                        return response;
                    }
                    if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                        consumerFilterData = this.brokerController.getConsumerFilterManager().get(requestHeader.getTopic(), requestHeader.getConsumerGroup());
                        if (consumerFilterData == null) {
                            response.setCode(27);
                            response.setRemark("The broker's consumer filter data is not exist!Your expression may be wrong!");
                            return response;
                        }
                        if (consumerFilterData.getClientVersion() < requestHeader.getSubVersion()) {
                            log.warn("The broker's consumer filter data is not latest, group: {}, topic: {}, serverV: {}, clientV: {}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), consumerFilterData.getClientVersion(), requestHeader.getSubVersion()});
                            response.setCode(28);
                            response.setRemark("the consumer's consumer filter data not latest");
                            return response;
                        }
                    }
                }
                if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType()) && !this.brokerController.getBrokerConfig().isEnablePropertyFilter()) {
                    response.setCode(1);
                    response.setRemark("The broker does not support consumer to filter message by " + subscriptionData.getExpressionType());
                    return response;
                }
                if (this.brokerController.getBrokerConfig().isFilterSupportRetry()) {
                    ExpressionForRetryMessageFilter expressionForRetryMessageFilter = new ExpressionForRetryMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
                } else {
                    ExpressionMessageFilter expressionMessageFilter = new ExpressionMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
                }
                final GetMessageResult getMessageResult = this.brokerController.getMessageStore().getMessage(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getQueueOffset().longValue(), requestHeader.getMaxMsgNums().intValue(), (MessageFilter)var19_21);
                if (getMessageResult == null) break block68;
                response.setRemark(getMessageResult.getStatus().name());
                responseHeader.setNextBeginOffset(Long.valueOf(getMessageResult.getNextBeginOffset()));
                responseHeader.setMinOffset(Long.valueOf(getMessageResult.getMinOffset()));
                responseHeader.setMaxOffset(Long.valueOf(getMessageResult.getMaxOffset()));
                if (getMessageResult.isSuggestPullingFromSlave()) {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
                } else {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                }
                switch (this.brokerController.getMessageStoreConfig().getBrokerRole()) {
                    case ASYNC_MASTER: 
                    case SYNC_MASTER: {
                        break;
                    }
                    case SLAVE: {
                        if (this.brokerController.getBrokerConfig().isSlaveReadEnable()) break;
                        response.setCode(20);
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                        break;
                    }
                }
                if (this.brokerController.getBrokerConfig().isSlaveReadEnable()) {
                    if (getMessageResult.isSuggestPullingFromSlave()) {
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
                    } else {
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
                    }
                } else {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                }
                switch (getMessageResult.getStatus()) {
                    case FOUND: {
                        response.setCode(0);
                        break;
                    }
                    case MESSAGE_WAS_REMOVING: {
                        response.setCode(20);
                        break;
                    }
                    case NO_MATCHED_LOGIC_QUEUE: 
                    case NO_MESSAGE_IN_QUEUE: {
                        if (0L != requestHeader.getQueueOffset()) {
                            response.setCode(21);
                            log.info("the broker store no queue data, fix the request offset {} to {}, Topic: {} QueueId: {} Consumer Group: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup()});
                            break;
                        }
                        response.setCode(19);
                        break;
                    }
                    case NO_MATCHED_MESSAGE: {
                        response.setCode(20);
                        break;
                    }
                    case OFFSET_FOUND_NULL: {
                        response.setCode(19);
                        break;
                    }
                    case OFFSET_OVERFLOW_BADLY: {
                        response.setCode(21);
                        log.info("the request offset: {} over flow badly, broker max offset: {}, consumer: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getMaxOffset(), channel.remoteAddress()});
                        break;
                    }
                    case OFFSET_OVERFLOW_ONE: {
                        response.setCode(19);
                        break;
                    }
                    case OFFSET_TOO_SMALL: {
                        response.setCode(21);
                        log.info("the request offset too small. group={}, topic={}, requestOffset={}, brokerMinOffset={}, clientIp={}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueOffset(), getMessageResult.getMinOffset(), channel.remoteAddress()});
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.hasConsumeMessageHook()) {
                    ConsumeMessageContext context = new ConsumeMessageContext();
                    context.setConsumerGroup(requestHeader.getConsumerGroup());
                    context.setTopic(requestHeader.getTopic());
                    context.setQueueId(requestHeader.getQueueId());
                    String owner = (String)request.getExtFields().get("Owner");
                    switch (response.getCode()) {
                        case 0: {
                            int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                            int incValue = getMessageResult.getMsgCount4Commercial() * commercialBaseCount;
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_SUCCESS);
                            context.setCommercialRcvTimes(incValue);
                            context.setCommercialRcvSize(getMessageResult.getBufferTotalSize());
                            context.setCommercialOwner(owner);
                            break;
                        }
                        case 19: {
                            if (brokerAllowSuspend) break;
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                            context.setCommercialRcvTimes(1);
                            context.setCommercialOwner(owner);
                            break;
                        }
                        case 20: 
                        case 21: {
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                            context.setCommercialRcvTimes(1);
                            context.setCommercialOwner(owner);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    this.executeConsumeMessageHookBefore(context);
                }
                if ((rewriteResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode())) != null) {
                    response = rewriteResult;
                }
                switch (response.getCode()) {
                    case 0: {
                        this.brokerController.getBrokerStatsManager().incGroupGetNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getMessageCount());
                        this.brokerController.getBrokerStatsManager().incGroupGetSize(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getBufferTotalSize());
                        this.brokerController.getBrokerStatsManager().incBrokerGetNums(getMessageResult.getMessageCount());
                        if (this.brokerController.getBrokerConfig().isTransferMsgByHeap()) {
                            byte[] r = this.readGetMessageResult(getMessageResult, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
                            this.brokerController.getBrokerStatsManager().incGroupGetLatency(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), (int)(this.brokerController.getMessageStore().now() - beginTimeMills));
                            response.setBody(r);
                            break;
                        }
                        try {
                            ManyMessageTransfer fileRegion = new ManyMessageTransfer(response.encodeHeader(getMessageResult.getBufferTotalSize()), getMessageResult);
                            channel.writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    getMessageResult.release();
                                    if (!future.isSuccess()) {
                                        log.error("transfer many message by pagecache failed, {}", (Object)channel.remoteAddress(), (Object)future.cause());
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            log.error("transfer many message by pagecache exception", e);
                            getMessageResult.release();
                        }
                        response = null;
                        break;
                    }
                    case 19: {
                        if (brokerAllowSuspend && hasSuspendFlag) {
                            long pollingTimeMills = suspendTimeoutMillisLong;
                            if (!this.brokerController.getBrokerConfig().isLongPollingEnable()) {
                                pollingTimeMills = this.brokerController.getBrokerConfig().getShortPollingTimeMills();
                            }
                            String topic = requestHeader.getTopic();
                            long offset = requestHeader.getQueueOffset();
                            int queueId = requestHeader.getQueueId();
                            PullRequest pullRequest = new PullRequest(request, channel, pollingTimeMills, this.brokerController.getMessageStore().now(), offset, subscriptionData, (MessageFilter)var19_21);
                            this.brokerController.getPullRequestHoldService().suspendPullRequest(topic, queueId, pullRequest);
                            response = null;
                            break;
                        }
                    }
                    case 20: {
                        break;
                    }
                    case 21: {
                        if (this.brokerController.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE || this.brokerController.getMessageStoreConfig().isOffsetCheckInSlave()) {
                            MessageQueue mq = new MessageQueue();
                            mq.setTopic(requestHeader.getTopic());
                            mq.setQueueId(requestHeader.getQueueId().intValue());
                            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                            OffsetMovedEvent event = new OffsetMovedEvent();
                            event.setConsumerGroup(requestHeader.getConsumerGroup());
                            event.setMessageQueue(mq);
                            event.setOffsetRequest(requestHeader.getQueueOffset().longValue());
                            event.setOffsetNew(getMessageResult.getNextBeginOffset());
                            this.generateOffsetMovedEvent(event);
                            log.warn("PULL_OFFSET_MOVED:correction offset. topic={}, groupId={}, requestOffset={}, newOffset={}, suggestBrokerId={}", new Object[]{requestHeader.getTopic(), requestHeader.getConsumerGroup(), event.getOffsetRequest(), event.getOffsetNew(), responseHeader.getSuggestWhichBrokerId()});
                            break;
                        }
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
                        response.setCode(20);
                        log.warn("PULL_OFFSET_MOVED:none correction. topic={}, groupId={}, requestOffset={}, suggestBrokerId={}", new Object[]{requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueOffset(), responseHeader.getSuggestWhichBrokerId()});
                        break;
                    }
                    default: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
                break block69;
            }
            response.setCode(1);
            response.setRemark("store getMessage return null");
        }
        boolean storeOffsetEnable = brokerAllowSuspend;
        storeOffsetEnable = storeOffsetEnable && hasCommitOffsetFlag;
        boolean bl = storeOffsetEnable = storeOffsetEnable && this.brokerController.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE;
        if (storeOffsetEnable) {
            this.brokerController.getConsumerOffsetManager().commitOffset(RemotingHelper.parseChannelRemoteAddr((Channel)channel), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        }
        return response;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void executeConsumeMessageHookBefore(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageBefore(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readGetMessageResult(GetMessageResult getMessageResult, String group, String topic, int queueId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(getMessageResult.getBufferTotalSize());
        long storeTimestamp = 0L;
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            for (ByteBuffer bb : messageBufferList) {
                byteBuffer.put(bb);
                int sysFlag = bb.getInt(36);
                int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
                int msgStoreTimePos = 48 + bornhostLength;
                storeTimestamp = bb.getLong(msgStoreTimePos);
            }
        }
        finally {
            getMessageResult.release();
        }
        this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - storeTimestamp);
        return byteBuffer.array();
    }

    private void generateOffsetMovedEvent(OffsetMovedEvent event) {
        try {
            MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
            msgInner.setTopic("OFFSET_MOVED_EVENT");
            msgInner.setTags(event.getConsumerGroup());
            msgInner.setDelayTimeLevel(0);
            msgInner.setKeys(event.getConsumerGroup());
            msgInner.setBody(event.encode());
            msgInner.setFlag(0);
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)TopicFilterType.SINGLE_TAG, (String)msgInner.getTags()));
            msgInner.setQueueId(0);
            msgInner.setSysFlag(0);
            msgInner.setBornTimestamp(System.currentTimeMillis());
            msgInner.setBornHost(RemotingUtil.string2SocketAddress((String)this.brokerController.getBrokerAddr()));
            msgInner.setStoreHost(msgInner.getBornHost());
            msgInner.setReconsumeTimes(0);
            PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
        }
        catch (Exception e) {
            log.warn(String.format("generateOffsetMovedEvent Exception, %s", event.toString()), (Throwable)e);
        }
    }

    public void executeRequestWhenWakeup(final Channel channel, final RemotingCommand request) throws RemotingCommandException {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    final RemotingCommand response = PullMessageProcessor.this.processRequest(channel, request, false);
                    if (response != null) {
                        response.setOpaque(request.getOpaque());
                        response.markResponseType();
                        try {
                            channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (!future.isSuccess()) {
                                        log.error("processRequestWrapper response to {} failed", (Object)future.channel().remoteAddress(), (Object)future.cause());
                                        log.error(request.toString());
                                        log.error(response.toString());
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            log.error("processRequestWrapper process request over, but response failed", e);
                            log.error(request.toString());
                            log.error(response.toString());
                        }
                    }
                }
                catch (RemotingCommandException e1) {
                    log.error("excuteRequestWhenWakeup run", (Throwable)e1);
                }
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, channel, request));
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }
}

