/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.TopicAttributes;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.Attribute;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class TopicConfigManager
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final int SCHEDULE_TOPIC_QUEUE_NUM = 18;
    private final transient Lock topicConfigTableLock = new ReentrantLock();
    private final ConcurrentMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>(1024);
    private final DataVersion dataVersion = new DataVersion();
    private transient BrokerController brokerController;

    public TopicConfigManager() {
    }

    public TopicConfigManager(BrokerController brokerController) {
        int perm;
        this.brokerController = brokerController;
        String topic = "SELF_TEST_TOPIC";
        TopicConfig topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        if (this.brokerController.getBrokerConfig().isAutoCreateTopicEnable()) {
            topic = "TBW102";
            topicConfig = new TopicConfig(topic);
            TopicValidator.addSystemTopic((String)topic);
            topicConfig.setReadQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            topicConfig.setWriteQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            perm = 7;
            topicConfig.setPerm(perm);
            this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
        topic = "BenchmarkTest";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1024);
        topicConfig.setWriteQueueNums(1024);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerClusterName();
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isClusterTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setPerm(perm);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerName();
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isBrokerTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        topicConfig.setPerm(perm);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = "OFFSET_MOVED_EVENT";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = "SCHEDULE_TOPIC_XXXX";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(18);
        topicConfig.setWriteQueueNums(18);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        if (this.brokerController.getBrokerConfig().isTraceTopicEnable()) {
            topic = this.brokerController.getBrokerConfig().getMsgTraceTopicName();
            topicConfig = new TopicConfig(topic);
            TopicValidator.addSystemTopic((String)topic);
            topicConfig.setReadQueueNums(1);
            topicConfig.setWriteQueueNums(1);
            this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
        topic = this.brokerController.getBrokerConfig().getBrokerClusterName() + "_" + "REPLY_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
    }

    public TopicConfig selectTopicConfig(String topic) {
        return (TopicConfig)this.topicConfigTable.get(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageMethod(String topic, String defaultTopic, String remoteAddress, int clientDefaultTopicQueueNums, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block14: {
            topicConfig = null;
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block14;
                try {
                    topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    TopicConfig defaultTopicConfig = (TopicConfig)this.topicConfigTable.get(defaultTopic);
                    if (defaultTopicConfig != null) {
                        if (defaultTopic.equals("TBW102") && !this.brokerController.getBrokerConfig().isAutoCreateTopicEnable()) {
                            defaultTopicConfig.setPerm(6);
                        }
                        if (PermName.isInherited((int)defaultTopicConfig.getPerm())) {
                            topicConfig = new TopicConfig(topic);
                            int queueNums = Math.min(clientDefaultTopicQueueNums, defaultTopicConfig.getWriteQueueNums());
                            if (queueNums < 0) {
                                queueNums = 0;
                            }
                            topicConfig.setReadQueueNums(queueNums);
                            topicConfig.setWriteQueueNums(queueNums);
                            int perm = defaultTopicConfig.getPerm();
                            topicConfig.setPerm(perm &= 0xFFFFFFFE);
                            topicConfig.setTopicSysFlag(topicSysFlag);
                            topicConfig.setTopicFilterType(defaultTopicConfig.getTopicFilterType());
                        } else {
                            log.warn("Create new topic failed, because the default topic[{}] has no perm [{}] producer:[{}]", new Object[]{defaultTopic, defaultTopicConfig.getPerm(), remoteAddress});
                        }
                    } else {
                        log.warn("Create new topic failed, because the default topic[{}] not exist. producer:[{}]", (Object)defaultTopic, (Object)remoteAddress);
                    }
                    if (topicConfig != null) {
                        log.info("Create new topic by default topic:[{}] config:[{}] producer:[{}]", new Object[]{defaultTopic, topicConfig, remoteAddress});
                        this.topicConfigTable.put(topic, topicConfig);
                        this.dataVersion.nextVersion();
                        createNew = true;
                        this.persist();
                    }
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.brokerController.registerBrokerAll(false, true, true);
        return topicConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageBackMethod(String topic, int clientDefaultTopicQueueNums, int perm, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block8: {
            topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
            if (topicConfig != null) {
                return topicConfig;
            }
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block8;
                try {
                    topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    topicConfig = new TopicConfig(topic);
                    topicConfig.setReadQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setWriteQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setPerm(perm);
                    topicConfig.setTopicSysFlag(topicSysFlag);
                    log.info("create new topic {}", (Object)topicConfig);
                    this.topicConfigTable.put(topic, topicConfig);
                    createNew = true;
                    this.dataVersion.nextVersion();
                    this.persist();
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageBackMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.brokerController.registerBrokerAll(false, true, true);
        return topicConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicOfTranCheckMaxTime(int clientDefaultTopicQueueNums, int perm) {
        boolean createNew;
        TopicConfig topicConfig;
        block8: {
            topicConfig = (TopicConfig)this.topicConfigTable.get("TRANS_CHECK_MAX_TIME_TOPIC");
            if (topicConfig != null) {
                return topicConfig;
            }
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block8;
                try {
                    topicConfig = (TopicConfig)this.topicConfigTable.get("TRANS_CHECK_MAX_TIME_TOPIC");
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    topicConfig = new TopicConfig("TRANS_CHECK_MAX_TIME_TOPIC");
                    topicConfig.setReadQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setWriteQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setPerm(perm);
                    topicConfig.setTopicSysFlag(0);
                    log.info("create new topic {}", (Object)topicConfig);
                    this.topicConfigTable.put("TRANS_CHECK_MAX_TIME_TOPIC", topicConfig);
                    createNew = true;
                    this.dataVersion.nextVersion();
                    this.persist();
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("create TRANS_CHECK_MAX_TIME_TOPIC exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.brokerController.registerBrokerAll(false, true, true);
        return topicConfig;
    }

    public void updateTopicUnitFlag(String topic, boolean unit) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (unit) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitFlag((int)oldTopicSysFlag));
            } else {
                topicConfig.setTopicSysFlag(TopicSysFlag.clearUnitFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag={}", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.topicConfigTable.put(topic, topicConfig);
            this.dataVersion.nextVersion();
            this.persist();
            this.brokerController.registerBrokerAll(false, true, true);
        }
    }

    public void updateTopicUnitSubFlag(String topic, boolean hasUnitSub) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (hasUnitSub) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitSubFlag((int)oldTopicSysFlag));
            } else {
                topicConfig.setTopicSysFlag(TopicSysFlag.clearUnitSubFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag={}", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.topicConfigTable.put(topic, topicConfig);
            this.dataVersion.nextVersion();
            this.persist();
            this.brokerController.registerBrokerAll(false, true, true);
        }
    }

    public void updateTopicConfig(TopicConfig topicConfig) {
        Preconditions.checkNotNull((Object)topicConfig, (Object)"topicConfig shouldn't be null");
        Map<String, String> newAttributes = this.request(topicConfig);
        Map<String, String> currentAttributes = this.current(topicConfig.getTopicName());
        Map<String, String> finalAttributes = this.alterCurrentAttributes(this.topicConfigTable.get(topicConfig.getTopicName()) == null, (ImmutableMap<String, String>)ImmutableMap.copyOf(currentAttributes), (ImmutableMap<String, String>)ImmutableMap.copyOf(newAttributes));
        topicConfig.setAttributes(finalAttributes);
        TopicConfig old = this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        if (old != null) {
            log.info("update topic config, old:[{}] new:[{}]", (Object)old, (Object)topicConfig);
        } else {
            log.info("create new topic [{}]", (Object)topicConfig);
        }
        this.dataVersion.nextVersion();
        this.persist(topicConfig.getTopicName(), topicConfig);
    }

    public void updateOrderTopicConfig(KVTable orderKVTableFromNs) {
        if (orderKVTableFromNs != null && orderKVTableFromNs.getTable() != null) {
            boolean isChange = false;
            Set orderTopics = orderKVTableFromNs.getTable().keySet();
            for (String string : orderTopics) {
                TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.get(string);
                if (topicConfig == null || topicConfig.isOrder()) continue;
                topicConfig.setOrder(true);
                isChange = true;
                log.info("update order topic config, topic={}, order={}", (Object)string, (Object)true);
            }
            for (Map.Entry entry : this.topicConfigTable.entrySet()) {
                TopicConfig topicConfig;
                String topic = (String)entry.getKey();
                if (orderTopics.contains(topic) || !(topicConfig = (TopicConfig)entry.getValue()).isOrder()) continue;
                topicConfig.setOrder(false);
                isChange = true;
                log.info("update order topic config, topic={}, order={}", (Object)topic, (Object)false);
            }
            if (isChange) {
                this.dataVersion.nextVersion();
                this.persist();
            }
        }
    }

    public Map<String, Attribute> allAttributes() {
        return TopicAttributes.ALL;
    }

    public boolean isOrderTopic(String topic) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
        if (topicConfig == null) {
            return false;
        }
        return topicConfig.isOrder();
    }

    public void deleteTopicConfig(String topic) {
        TopicConfig old = (TopicConfig)this.topicConfigTable.remove(topic);
        if (old != null) {
            log.info("delete topic config OK, topic: {}", (Object)old);
            this.dataVersion.nextVersion();
            this.persist();
        } else {
            log.warn("delete topic config failed, topic: {} not exists", (Object)topic);
        }
    }

    public TopicConfigSerializeWrapper buildTopicConfigSerializeWrapper() {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        topicConfigSerializeWrapper.setDataVersion(this.dataVersion);
        return topicConfigSerializeWrapper;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getTopicConfigPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper;
        if (jsonString != null && (topicConfigSerializeWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.fromJson((String)jsonString, TopicConfigSerializeWrapper.class)) != null) {
            this.topicConfigTable.putAll(topicConfigSerializeWrapper.getTopicConfigTable());
            this.dataVersion.assignNewOne(topicConfigSerializeWrapper.getDataVersion());
            this.printLoadDataWhenFirstBoot(topicConfigSerializeWrapper);
        }
    }

    public String encode(boolean prettyFormat) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        topicConfigSerializeWrapper.setDataVersion(this.dataVersion);
        return topicConfigSerializeWrapper.toJson(prettyFormat);
    }

    private void printLoadDataWhenFirstBoot(TopicConfigSerializeWrapper tcs) {
        for (Map.Entry next : tcs.getTopicConfigTable().entrySet()) {
            log.info("load exist local topic, {}", (Object)((TopicConfig)next.getValue()).toString());
        }
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public ConcurrentMap<String, TopicConfig> getTopicConfigTable() {
        return this.topicConfigTable;
    }

    private Map<String, String> request(TopicConfig topicConfig) {
        return topicConfig.getAttributes() == null ? new HashMap() : topicConfig.getAttributes();
    }

    private Map<String, String> current(String topic) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.get(topic);
        if (topicConfig == null) {
            return new HashMap<String, String>();
        }
        Map attributes = topicConfig.getAttributes();
        if (attributes == null) {
            return new HashMap<String, String>();
        }
        return attributes;
    }

    private Map<String, String> alterCurrentAttributes(boolean create, ImmutableMap<String, String> currentAttributes, ImmutableMap<String, String> newAttributes) {
        HashMap<String, String> init = new HashMap<String, String>();
        HashMap<String, String> add = new HashMap<String, String>();
        HashMap<String, String> update = new HashMap<String, String>();
        HashMap<String, String> delete = new HashMap<String, String>();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry attribute : newAttributes.entrySet()) {
            String key = (String)attribute.getKey();
            String realKey = this.realKey(key);
            String value = (String)attribute.getValue();
            this.validate(realKey);
            this.duplicationCheck(keys, realKey);
            if (create) {
                if (key.startsWith("+")) {
                    init.put(realKey, value);
                    continue;
                }
                throw new RuntimeException("only add attribute is supported while creating topic. key: " + realKey);
            }
            if (key.startsWith("+")) {
                if (!currentAttributes.containsKey((Object)realKey)) {
                    add.put(realKey, value);
                    continue;
                }
                update.put(realKey, value);
                continue;
            }
            if (key.startsWith("-")) {
                if (!currentAttributes.containsKey((Object)realKey)) {
                    throw new RuntimeException("attempt to delete a nonexistent key: " + realKey);
                }
                delete.put(realKey, value);
                continue;
            }
            throw new RuntimeException("wrong format key: " + realKey);
        }
        this.validateAlter(init, true, false);
        this.validateAlter(add, false, false);
        this.validateAlter(update, false, false);
        this.validateAlter(delete, false, true);
        log.info("add: {}, update: {}, delete: {}", new Object[]{add, update, delete});
        HashMap<String, String> finalAttributes = new HashMap<String, String>((Map<String, String>)currentAttributes);
        finalAttributes.putAll(init);
        finalAttributes.putAll(add);
        finalAttributes.putAll(update);
        for (String s : delete.keySet()) {
            finalAttributes.remove(s);
        }
        return finalAttributes;
    }

    private void duplicationCheck(Set<String> keys, String key) {
        boolean notExist = keys.add(key);
        if (!notExist) {
            throw new RuntimeException("alter duplication key. key: " + key);
        }
    }

    private void validate(String kvAttribute) {
        if (Strings.isNullOrEmpty((String)kvAttribute)) {
            throw new RuntimeException("kv string format wrong.");
        }
        if (kvAttribute.contains("+")) {
            throw new RuntimeException("kv string format wrong.");
        }
        if (kvAttribute.contains("-")) {
            throw new RuntimeException("kv string format wrong.");
        }
    }

    private void validateAlter(Map<String, String> alter, boolean init, boolean delete) {
        for (Map.Entry<String, String> entry : alter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Attribute attribute = this.allAttributes().get(key);
            if (attribute == null) {
                throw new RuntimeException("unsupported key: " + key);
            }
            if (!init && !attribute.isChangeable()) {
                throw new RuntimeException("attempt to update an unchangeable attribute. key: " + key);
            }
            if (delete) continue;
            attribute.verify(value);
        }
    }

    private String realKey(String key) {
        return key.substring(1);
    }
}

