/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.domain;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.rocketmq.common.fastjson.GenericMapSuperclassDeserializer;
import org.apache.rocketmq.common.protocol.route.LogicalQueueRouteData;
import org.apache.rocketmq.common.protocol.route.LogicalQueuesInfo;
import org.apache.rocketmq.srvutil.ConcurrentHashMapUtil;

public class LogicalQueuesInfoInBroker
extends LogicalQueuesInfo {
    private final ConcurrentMap<Integer, ConcurrentNavigableMap<Long, LogicalQueueRouteData>> queueId2LogicalQueueMap = Maps.newConcurrentMap();

    public LogicalQueuesInfoInBroker() {
    }

    public LogicalQueuesInfoInBroker(LogicalQueuesInfoInBroker other) {
        this(other, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalQueuesInfoInBroker(LogicalQueuesInfoInBroker other, Predicate<LogicalQueueRouteData> predicate) {
        other.readLock().lock();
        try {
            for (Map.Entry entry : other.entrySet()) {
                Stream<Object> stream = ((List)entry.getValue()).stream();
                if (predicate != null) {
                    stream = stream.filter(predicate);
                }
                this.put(entry.getKey(), stream.map(LogicalQueueRouteData::new).collect(Collectors.toList()));
            }
        }
        finally {
            other.readLock().unlock();
        }
    }

    public void updateQueueRouteDataByQueueId(int queueId, LogicalQueueRouteData queueRouteData) {
        if (queueRouteData == null) {
            return;
        }
        ((ConcurrentNavigableMap)ConcurrentHashMapUtil.computeIfAbsent(this.queueId2LogicalQueueMap, (Object)queueId, k -> new ConcurrentSkipListMap())).put(queueRouteData.getOffsetDelta(), queueRouteData);
    }

    public LogicalQueueRouteData queryQueueRouteDataByQueueId(int queueId, long offset) {
        ConcurrentNavigableMap m = (ConcurrentNavigableMap)this.queueId2LogicalQueueMap.get(queueId);
        if (m == null || m.isEmpty()) {
            return null;
        }
        Map.Entry entry = m.floorEntry(offset);
        if (entry == null) {
            return null;
        }
        return (LogicalQueueRouteData)entry.getValue();
    }

    public void deleteQueueRouteData(LogicalQueueRouteData logicalQueueRouteData) {
        ConcurrentNavigableMap m = (ConcurrentNavigableMap)this.queueId2LogicalQueueMap.get(logicalQueueRouteData.getQueueId());
        if (m != null) {
            m.remove(logicalQueueRouteData.getOffsetDelta(), logicalQueueRouteData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalQueueRouteData nextAvailableLogicalRouteData(LogicalQueueRouteData queueRouteData, Predicate<LogicalQueueRouteData> predicate) {
        this.readLock().lock();
        try {
            List queueRouteDataList = Optional.ofNullable(this.get(queueRouteData.getLogicalQueueIndex())).orElse(Collections.emptyList());
            int idx = Collections.binarySearch(queueRouteDataList, queueRouteData);
            if (idx >= 0) {
                int size = queueRouteDataList.size();
                for (int i = idx + 1; i < size; ++i) {
                    LogicalQueueRouteData tmp = (LogicalQueueRouteData)queueRouteDataList.get(i);
                    if (!predicate.test(tmp)) continue;
                    LogicalQueueRouteData logicalQueueRouteData = tmp;
                    return logicalQueueRouteData;
                }
            }
        }
        finally {
            this.readLock().unlock();
        }
        return null;
    }

    static {
        ParserConfig.getGlobalInstance().putDeserializer(LogicalQueuesInfoInBroker.class, (ObjectDeserializer)GenericMapSuperclassDeserializer.INSTANCE);
    }
}

