/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.loadbalance;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class AssignmentManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private transient BrokerController brokerController;
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final Lock lockNamesrv = new ReentrantLock();
    private final BrokerOuterAPI mQClientAPIImpl;
    private final ConcurrentHashMap<String, Set<MessageQueue>> topicSubscribeInfoTable = new ConcurrentHashMap();
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("LoadBalanceManagerScheduledThread"));
    private static final List<String> IGNORE_ROUTE_TOPICS = Lists.newArrayList((Object[])new String[]{"rmq_sys_", "CID_RMQ_SYS_", "DEFAULT_CONSUMER", "TOOLS_CONSUMER", "FILTERSRV_CONSUMER", "__MONITOR_CONSUMER", "CID_ONS-HTTP-PROXY", "CID_ONSAPI_PERMISSION", "CID_ONSAPI_OWNER", "CID_ONSAPI_PULL"});
    private final List<String> ignoreRouteTopics = Lists.newArrayList(IGNORE_ROUTE_TOPICS);

    public AssignmentManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.mQClientAPIImpl = brokerController.getBrokerOuterAPI();
        this.ignoreRouteTopics.add(brokerController.getBrokerConfig().getBrokerClusterName());
        this.ignoreRouteTopics.add(brokerController.getBrokerConfig().getBrokerName());
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    AssignmentManager.this.updateTopicRouteInfoFromNameServer();
                }
                catch (Exception e) {
                    log.error("ScheduledTask: failed to pull TopicRouteData from NameServer", (Throwable)e);
                }
            }
        }, 200L, this.brokerController.getBrokerConfig().getLoadBalancePollNameServerInterval(), TimeUnit.MILLISECONDS);
    }

    public void updateTopicRouteInfoFromNameServer() {
        HashSet topicList = new HashSet(this.brokerController.getTopicConfigManager().getTopicConfigTable().keySet());
        block0: for (String topic : topicList) {
            for (String keyword : this.ignoreRouteTopics) {
                if (!topic.contains(keyword)) continue;
                continue block0;
            }
            this.updateTopicRouteInfoFromNameServer(topic);
        }
    }

    public boolean updateTopicRouteInfoFromNameServer(String topic) {
        block5: {
            try {
                TopicRouteData topicRouteData = this.mQClientAPIImpl.getTopicRouteInfoFromNameServer(topic, 3000L);
                if (topicRouteData != null) {
                    Set<MessageQueue> oldSubscribeInfo;
                    boolean changed;
                    Set newSubscribeInfo = MQClientInstance.topicRouteData2TopicSubscribeInfo((String)topic, (TopicRouteData)topicRouteData);
                    boolean bl = changed = !newSubscribeInfo.equals(oldSubscribeInfo = this.topicSubscribeInfoTable.get(topic));
                    if (changed) {
                        log.info("the topic[{}] subscribe message queue changed, old[{}] ,new[{}]", new Object[]{topic, oldSubscribeInfo, newSubscribeInfo});
                        this.topicSubscribeInfoTable.put(topic, newSubscribeInfo);
                        return true;
                    }
                } else {
                    log.warn("updateTopicRouteInfoFromNameServer, getTopicRouteInfoFromNameServer return null, Topic: {}", (Object)topic);
                }
            }
            catch (Exception e) {
                if (topic.startsWith("%RETRY%")) break block5;
                log.warn("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
                if (!(e instanceof MQBrokerException) || 17 != ((MQBrokerException)e).getResponseCode()) break block5;
                this.cleanNoneRouteTopic(topic);
            }
        }
        return false;
    }

    private void cleanNoneRouteTopic(String topic) {
        this.topicSubscribeInfoTable.remove(topic);
    }

    public Set<MessageQueue> getTopicSubscribeInfo(String topic) {
        return this.topicSubscribeInfoTable.get(topic);
    }
}

