/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.loadbalance;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.protocol.body.SetMessageRequestModeRequestBody;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class MessageRequestModeManager
extends ConfigManager {
    private BrokerController brokerController;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, SetMessageRequestModeRequestBody>> messageRequestModeMap = new ConcurrentHashMap();

    public MessageRequestModeManager() {
    }

    public MessageRequestModeManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void setMessageRequestMode(String topic, String consumerGroup, SetMessageRequestModeRequestBody requestBody) {
        ConcurrentHashMap<String, SetMessageRequestModeRequestBody> pre;
        ConcurrentHashMap<String, Object> consumerGroup2ModeMap = this.messageRequestModeMap.get(topic);
        if (consumerGroup2ModeMap == null && (pre = this.messageRequestModeMap.putIfAbsent(topic, consumerGroup2ModeMap = new ConcurrentHashMap())) != null) {
            consumerGroup2ModeMap = pre;
        }
        consumerGroup2ModeMap.put(consumerGroup, requestBody);
    }

    public SetMessageRequestModeRequestBody getMessageRequestMode(String topic, String consumerGroup) {
        ConcurrentHashMap<String, SetMessageRequestModeRequestBody> consumerGroup2ModeMap = this.messageRequestModeMap.get(topic);
        if (consumerGroup2ModeMap != null) {
            return consumerGroup2ModeMap.get(consumerGroup);
        }
        return null;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, SetMessageRequestModeRequestBody>> getMessageRequestModeMap() {
        return this.messageRequestModeMap;
    }

    public void setMessageRequestModeMap(ConcurrentHashMap<String, ConcurrentHashMap<String, SetMessageRequestModeRequestBody>> messageRequestModeMap) {
        this.messageRequestModeMap = messageRequestModeMap;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getMessageRequestModePath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        MessageRequestModeManager obj;
        if (jsonString != null && (obj = (MessageRequestModeManager)((Object)RemotingSerializable.fromJson((String)jsonString, MessageRequestModeManager.class))) != null) {
            this.messageRequestModeMap = obj.messageRequestModeMap;
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }
}

