/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pagecache;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class OneMessageTransfer
extends AbstractReferenceCounted
implements FileRegion {
    private final ByteBuffer byteBufferHeader;
    private final SelectMappedBufferResult selectMappedBufferResult;
    private long transferred;

    public OneMessageTransfer(ByteBuffer byteBufferHeader, SelectMappedBufferResult selectMappedBufferResult) {
        this.byteBufferHeader = byteBufferHeader;
        this.selectMappedBufferResult = selectMappedBufferResult;
    }

    public long position() {
        return this.byteBufferHeader.position() + this.selectMappedBufferResult.getByteBuffer().position();
    }

    public long transfered() {
        return this.transferred;
    }

    public long count() {
        return this.byteBufferHeader.limit() + this.selectMappedBufferResult.getSize();
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.byteBufferHeader.hasRemaining()) {
            this.transferred += (long)target.write(this.byteBufferHeader);
            return this.transferred;
        }
        if (this.selectMappedBufferResult.getByteBuffer().hasRemaining()) {
            this.transferred += (long)target.write(this.selectMappedBufferResult.getByteBuffer());
            return this.transferred;
        }
        return 0L;
    }

    public void close() {
        this.deallocate();
    }

    protected void deallocate() {
        this.selectMappedBufferResult.release();
    }
}

