/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.plugin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.broker.plugin.MessageStorePluginContext;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public abstract class AbstractPluginMessageStore
implements MessageStore {
    protected MessageStore next = null;
    protected MessageStorePluginContext context;

    public AbstractPluginMessageStore(MessageStorePluginContext context, MessageStore next) {
        this.next = next;
        this.context = context;
    }

    public long getEarliestMessageTime() {
        return this.next.getEarliestMessageTime();
    }

    public long lockTimeMills() {
        return this.next.lockTimeMills();
    }

    public boolean isOSPageCacheBusy() {
        return this.next.isOSPageCacheBusy();
    }

    public boolean isTransientStorePoolDeficient() {
        return this.next.isTransientStorePoolDeficient();
    }

    public boolean load() {
        return this.next.load();
    }

    public void start() throws Exception {
        this.next.start();
    }

    public void shutdown() {
        this.next.shutdown();
    }

    public void destroy() {
        this.next.destroy();
    }

    public PutMessageResult putMessage(MessageExtBrokerInner msg) {
        return this.next.putMessage(msg);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        return this.next.asyncPutMessage(msg);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        return this.next.asyncPutMessages(messageExtBatch);
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
    }

    public long getMaxOffsetInQueue(String topic, int queueId) {
        return this.next.getMaxOffsetInQueue(topic, queueId);
    }

    public long getMaxOffsetInQueue(String topic, int queueId, boolean committed) {
        return this.next.getMaxOffsetInQueue(topic, queueId, committed);
    }

    public long getMinOffsetInQueue(String topic, int queueId) {
        return this.next.getMinOffsetInQueue(topic, queueId);
    }

    public long getCommitLogOffsetInQueue(String topic, int queueId, long consumeQueueOffset) {
        return this.next.getCommitLogOffsetInQueue(topic, queueId, consumeQueueOffset);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp) {
        return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
    }

    public MessageExt lookMessageByOffset(long commitLogOffset) {
        return this.next.lookMessageByOffset(commitLogOffset);
    }

    public SelectMappedBufferResult selectOneMessageByOffset(long commitLogOffset) {
        return this.next.selectOneMessageByOffset(commitLogOffset);
    }

    public SelectMappedBufferResult selectOneMessageByOffset(long commitLogOffset, int msgSize) {
        return this.next.selectOneMessageByOffset(commitLogOffset, msgSize);
    }

    public String getRunningDataInfo() {
        return this.next.getRunningDataInfo();
    }

    public HashMap<String, String> getRuntimeInfo() {
        return this.next.getRuntimeInfo();
    }

    public long getMaxPhyOffset() {
        return this.next.getMaxPhyOffset();
    }

    public long getMinPhyOffset() {
        return this.next.getMinPhyOffset();
    }

    public long getEarliestMessageTime(String topic, int queueId) {
        return this.next.getEarliestMessageTime(topic, queueId);
    }

    public long getMessageStoreTimeStamp(String topic, int queueId, long consumeQueueOffset) {
        return this.next.getMessageStoreTimeStamp(topic, queueId, consumeQueueOffset);
    }

    public long getMessageTotalInQueue(String topic, int queueId) {
        return this.next.getMessageTotalInQueue(topic, queueId);
    }

    public SelectMappedBufferResult getCommitLogData(long offset) {
        return this.next.getCommitLogData(offset);
    }

    public boolean appendToCommitLog(long startOffset, byte[] data) {
        return this.next.appendToCommitLog(startOffset, data);
    }

    public void executeDeleteFilesManually() {
        this.next.executeDeleteFilesManually();
    }

    public QueryMessageResult queryMessage(String topic, String key, int maxNum, long begin, long end) {
        return this.next.queryMessage(topic, key, maxNum, begin, end);
    }

    public void updateHaMasterAddress(String newAddr) {
        this.next.updateHaMasterAddress(newAddr);
    }

    public long slaveFallBehindMuch() {
        return this.next.slaveFallBehindMuch();
    }

    public long now() {
        return this.next.now();
    }

    public int cleanUnusedTopic(Set<String> topics) {
        return this.next.cleanUnusedTopic(topics);
    }

    public void cleanExpiredConsumerQueue() {
        this.next.cleanExpiredConsumerQueue();
    }

    public boolean checkInDiskByConsumeOffset(String topic, int queueId, long consumeOffset) {
        return this.next.checkInDiskByConsumeOffset(topic, queueId, consumeOffset);
    }

    public long dispatchBehindBytes() {
        return this.next.dispatchBehindBytes();
    }

    public long flush() {
        return this.next.flush();
    }

    public boolean resetWriteOffset(long phyOffset) {
        return this.next.resetWriteOffset(phyOffset);
    }

    public long getConfirmOffset() {
        return this.next.getConfirmOffset();
    }

    public void setConfirmOffset(long phyOffset) {
        this.next.setConfirmOffset(phyOffset);
    }

    public LinkedList<CommitLogDispatcher> getDispatcherList() {
        return this.next.getDispatcherList();
    }

    public ConsumeQueue getConsumeQueue(String topic, int queueId) {
        return this.next.getConsumeQueue(topic, queueId);
    }

    public BrokerStatsManager getBrokerStatsManager() {
        return this.next.getBrokerStatsManager();
    }
}

