/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.acl.plain.PlainAccessValidator;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.domain.LogicalQueuesInfoInBroker;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageUtil;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicQueueId;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.BrokerStatsData;
import org.apache.rocketmq.common.protocol.body.BrokerStatsItem;
import org.apache.rocketmq.common.protocol.body.Connection;
import org.apache.rocketmq.common.protocol.body.ConsumeQueueData;
import org.apache.rocketmq.common.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.CreateMessageQueueForLogicalQueueRequestBody;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.common.protocol.body.LockBatchResponseBody;
import org.apache.rocketmq.common.protocol.body.MigrateLogicalQueueBody;
import org.apache.rocketmq.common.protocol.body.ProducerConnection;
import org.apache.rocketmq.common.protocol.body.QueryConsumeQueueResponseBody;
import org.apache.rocketmq.common.protocol.body.QueryConsumeTimeSpanBody;
import org.apache.rocketmq.common.protocol.body.QueryCorrectionOffsetBody;
import org.apache.rocketmq.common.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.common.protocol.body.ReuseTopicLogicalQueueRequestBody;
import org.apache.rocketmq.common.protocol.body.SealTopicLogicalQueueRequestBody;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.common.protocol.body.UpdateTopicLogicalQueueMappingRequestBody;
import org.apache.rocketmq.common.protocol.header.CloneGroupOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.common.protocol.header.CreateAccessConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.CreateTopicRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteAccessConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteSubscriptionGroupRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteTopicLogicalQueueRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteTopicRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetAllTopicConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetBrokerAclConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetBrokerClusterAclConfigResponseBody;
import org.apache.rocketmq.common.protocol.header.GetBrokerClusterAclConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetBrokerConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumeStatsInBrokerHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumeStatsRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerConnectionListRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerStatusRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetEarliestMsgStoretimeRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetEarliestMsgStoretimeResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetProducerConnectionListRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicStatsInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumeQueueRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumeTimeSpanRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryCorrectionOffsetHeader;
import org.apache.rocketmq.common.protocol.header.QueryTopicConsumeByWhoRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryTopicLogicalQueueMappingRequestHeader;
import org.apache.rocketmq.common.protocol.header.ResetOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.ResumeCheckHalfMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SearchOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.SearchOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.UpdateGlobalWhiteAddrsConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.ViewBrokerStatsDataRequestHeader;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterFilterServerRequestHeader;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterFilterServerResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.protocol.route.LogicalQueueRouteData;
import org.apache.rocketmq.common.protocol.route.MessageQueueRouteState;
import org.apache.rocketmq.common.stats.StatsItem;
import org.apache.rocketmq.common.stats.StatsSnapshot;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.filter.util.BitsArray;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.srvutil.ConcurrentHashMapUtil;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class AdminBrokerProcessor
extends AsyncNettyRequestProcessor
implements NettyRequestProcessor {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public AdminBrokerProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 17: {
                return this.updateAndCreateTopic(ctx, request);
            }
            case 215: {
                return this.deleteTopic(ctx, request);
            }
            case 21: {
                return this.getAllTopicConfig(ctx, request);
            }
            case 25: {
                return this.updateBrokerConfig(ctx, request);
            }
            case 26: {
                return this.getBrokerConfig(ctx, request);
            }
            case 29: {
                return this.searchOffsetByTimestamp(ctx, request);
            }
            case 30: {
                return this.getMaxOffset(ctx, request);
            }
            case 31: {
                return this.getMinOffset(ctx, request);
            }
            case 32: {
                return this.getEarliestMsgStoretime(ctx, request);
            }
            case 28: {
                return this.getBrokerRuntimeInfo(ctx, request);
            }
            case 41: {
                return this.lockBatchMQ(ctx, request);
            }
            case 42: {
                return this.unlockBatchMQ(ctx, request);
            }
            case 200: {
                return this.updateAndCreateSubscriptionGroup(ctx, request);
            }
            case 201: {
                return this.getAllSubscriptionGroup(ctx, request);
            }
            case 207: {
                return this.deleteSubscriptionGroup(ctx, request);
            }
            case 202: {
                return this.getTopicStatsInfo(ctx, request);
            }
            case 203: {
                return this.getConsumerConnectionList(ctx, request);
            }
            case 204: {
                return this.getProducerConnectionList(ctx, request);
            }
            case 208: {
                return this.getConsumeStats(ctx, request);
            }
            case 43: {
                return this.getAllConsumerOffset(ctx, request);
            }
            case 45: {
                return this.getAllDelayOffset(ctx, request);
            }
            case 222: {
                return this.resetOffset(ctx, request);
            }
            case 223: {
                return this.getConsumerStatus(ctx, request);
            }
            case 300: {
                return this.queryTopicConsumeByWho(ctx, request);
            }
            case 301: {
                return this.registerFilterServer(ctx, request);
            }
            case 303: {
                return this.queryConsumeTimeSpan(ctx, request);
            }
            case 305: {
                return this.getSystemTopicListFromBroker(ctx, request);
            }
            case 306: {
                return this.cleanExpiredConsumeQueue();
            }
            case 316: {
                return this.cleanUnusedTopic();
            }
            case 307: {
                return this.getConsumerRunningInfo(ctx, request);
            }
            case 308: {
                return this.queryCorrectionOffset(ctx, request);
            }
            case 309: {
                return this.consumeMessageDirectly(ctx, request);
            }
            case 314: {
                return this.cloneGroupOffset(ctx, request);
            }
            case 315: {
                return this.ViewBrokerStatsData(ctx, request);
            }
            case 317: {
                return this.fetchAllConsumeStatsInBroker(ctx, request);
            }
            case 321: {
                return this.queryConsumeQueue(ctx, request);
            }
            case 50: {
                return this.updateAndCreateAccessConfig(ctx, request);
            }
            case 51: {
                return this.deleteAccessConfig(ctx, request);
            }
            case 52: {
                return this.getBrokerAclConfigVersion(ctx, request);
            }
            case 53: {
                return this.updateGlobalWhiteAddrsConfig(ctx, request);
            }
            case 323: {
                return this.resumeCheckHalfMessage(ctx, request);
            }
            case 54: {
                return this.getBrokerClusterAclConfig(ctx, request);
            }
            case 351: {
                return this.getTopicConfig(ctx, request);
            }
            case 411: {
                return this.updateTopicLogicalQueueMapping(ctx, request);
            }
            case 422: {
                return this.deleteTopicLogicalQueueMapping(ctx, request);
            }
            case 413: {
                return this.queryTopicLogicalQueueMapping(ctx, request);
            }
            case 414: {
                return this.sealTopicLogicalQueue(ctx, request);
            }
            case 415: {
                return this.reuseTopicLogicalQueue(ctx, request);
            }
            case 416: {
                return this.createMessageQueueForLogicalQueue(ctx, request);
            }
            case 417: {
                return this.migrateTopicLogicalQueuePrepare(ctx, request);
            }
            case 418: {
                return this.migrateTopicLogicalQueueCommit(ctx, request);
            }
            case 419: {
                return this.migrateTopicLogicalQueueNotify(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    private synchronized RemotingCommand updateAndCreateTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CreateTopicRequestHeader requestHeader = (CreateTopicRequestHeader)request.decodeCommandCustomHeader(CreateTopicRequestHeader.class);
        log.info("updateAndCreateTopic called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        String topic = requestHeader.getTopic();
        if (!TopicValidator.validateTopic((String)topic, (RemotingCommand)response)) {
            return response;
        }
        if (TopicValidator.isSystemTopic((String)topic, (RemotingCommand)response)) {
            return response;
        }
        TopicConfig topicConfig = new TopicConfig(topic);
        topicConfig.setReadQueueNums(requestHeader.getReadQueueNums().intValue());
        topicConfig.setWriteQueueNums(requestHeader.getWriteQueueNums().intValue());
        topicConfig.setTopicFilterType(requestHeader.getTopicFilterTypeEnum());
        topicConfig.setPerm(requestHeader.getPerm().intValue());
        topicConfig.setTopicSysFlag(requestHeader.getTopicSysFlag() == null ? 0 : requestHeader.getTopicSysFlag());
        this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
        this.brokerController.registerIncrementBrokerData(topicConfig, this.brokerController.getTopicConfigManager().getDataVersion());
        response.setCode(0);
        return response;
    }

    private synchronized RemotingCommand deleteTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteTopicRequestHeader requestHeader = (DeleteTopicRequestHeader)request.decodeCommandCustomHeader(DeleteTopicRequestHeader.class);
        log.info("deleteTopic called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        String topic = requestHeader.getTopic();
        if (!TopicValidator.validateTopic((String)topic, (RemotingCommand)response)) {
            return response;
        }
        if (TopicValidator.isSystemTopic((String)topic, (RemotingCommand)response)) {
            return response;
        }
        this.brokerController.getTopicConfigManager().deleteTopicConfig(topic);
        this.brokerController.getMessageStore().cleanUnusedTopic(this.brokerController.getTopicConfigManager().getTopicConfigTable().keySet());
        if (this.brokerController.getBrokerConfig().isAutoDeleteUnusedStats()) {
            this.brokerController.getBrokerStatsManager().onTopicDeleted(requestHeader.getTopic());
        }
        this.brokerController.getTopicConfigManager().deleteQueueRouteData(requestHeader.getTopic());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private synchronized RemotingCommand updateAndCreateAccessConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CreateAccessConfigRequestHeader requestHeader = (CreateAccessConfigRequestHeader)request.decodeCommandCustomHeader(CreateAccessConfigRequestHeader.class);
        PlainAccessConfig accessConfig = new PlainAccessConfig();
        accessConfig.setAccessKey(requestHeader.getAccessKey());
        accessConfig.setSecretKey(requestHeader.getSecretKey());
        accessConfig.setWhiteRemoteAddress(requestHeader.getWhiteRemoteAddress());
        accessConfig.setDefaultTopicPerm(requestHeader.getDefaultTopicPerm());
        accessConfig.setDefaultGroupPerm(requestHeader.getDefaultGroupPerm());
        accessConfig.setTopicPerms(UtilAll.string2List((String)requestHeader.getTopicPerms(), (String)","));
        accessConfig.setGroupPerms(UtilAll.string2List((String)requestHeader.getGroupPerms(), (String)","));
        accessConfig.setAdmin(requestHeader.isAdmin());
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.updateAccessConfig(accessConfig)) {
                String errorMsg = "The accesskey[" + requestHeader.getAccessKey() + "] corresponding to accessConfig has been updated failed.";
                log.warn(errorMsg);
                response.setCode(209);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            ctx.writeAndFlush((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to generate a proper update accessvalidator response", (Throwable)e);
            response.setCode(209);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private synchronized RemotingCommand deleteAccessConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteAccessConfigRequestHeader requestHeader = (DeleteAccessConfigRequestHeader)request.decodeCommandCustomHeader(DeleteAccessConfigRequestHeader.class);
        log.info("DeleteAccessConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        try {
            String accessKey = requestHeader.getAccessKey();
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.deleteAccessConfig(accessKey)) {
                String errorMsg = "The accesskey[" + requestHeader.getAccessKey() + "] corresponding to accessConfig has been deleted failed.";
                log.warn(errorMsg);
                response.setCode(210);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            ctx.writeAndFlush((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to generate a proper delete accessvalidator response", (Throwable)e);
            response.setCode(210);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private synchronized RemotingCommand updateGlobalWhiteAddrsConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UpdateGlobalWhiteAddrsConfigRequestHeader requestHeader = (UpdateGlobalWhiteAddrsConfigRequestHeader)request.decodeCommandCustomHeader(UpdateGlobalWhiteAddrsConfigRequestHeader.class);
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.updateGlobalWhiteAddrsConfig(UtilAll.string2List((String)requestHeader.getGlobalWhiteAddrs(), (String)","))) {
                String errorMsg = "The globalWhiteAddresses[" + requestHeader.getGlobalWhiteAddrs() + "] has been updated failed.";
                log.warn(errorMsg);
                response.setCode(211);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            ctx.writeAndFlush((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to generate a proper update globalWhiteAddresses response", (Throwable)e);
            response.setCode(211);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private RemotingCommand getBrokerAclConfigVersion(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerAclConfigResponseHeader.class);
        GetBrokerAclConfigResponseHeader responseHeader = (GetBrokerAclConfigResponseHeader)response.readCustomHeader();
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            responseHeader.setVersion(accessValidator.getAclConfigVersion());
            responseHeader.setBrokerAddr(this.brokerController.getBrokerAddr());
            responseHeader.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            responseHeader.setClusterName(this.brokerController.getBrokerConfig().getBrokerClusterName());
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        catch (Exception e) {
            log.error("Failed to generate a proper getBrokerAclConfigVersion response", (Throwable)e);
            return null;
        }
    }

    private RemotingCommand getBrokerClusterAclConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerClusterAclConfigResponseHeader.class);
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            GetBrokerClusterAclConfigResponseBody body = new GetBrokerClusterAclConfigResponseBody();
            AclConfig aclConfig = accessValidator.getAllAclConfig();
            body.setGlobalWhiteAddrs(aclConfig.getGlobalWhiteAddrs());
            body.setPlainAccessConfigs(aclConfig.getPlainAccessConfigs());
            response.setCode(0);
            response.setBody(body.encode());
            response.setRemark(null);
            return response;
        }
        catch (Exception e) {
            log.error("Failed to generate a proper getBrokerClusterAclConfig response", (Throwable)e);
            return null;
        }
    }

    private RemotingCommand getAllTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetAllTopicConfigResponseHeader.class);
        String content = this.brokerController.getTopicConfigManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            log.error("No topic in this broker, client: {}", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No topic in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private synchronized RemotingCommand updateBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response;
        block5: {
            response = RemotingCommand.createResponseCommand(null);
            log.info("updateBrokerConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
            byte[] body = request.getBody();
            if (body != null) {
                try {
                    String bodyStr = new String(body, "UTF-8");
                    Properties properties = MixAll.string2Properties((String)bodyStr);
                    if (properties != null) {
                        log.info("updateBrokerConfig, new config: [{}] client: {} ", (Object)properties, (Object)ctx.channel().remoteAddress());
                        this.brokerController.getConfiguration().update(properties);
                        if (properties.containsKey("brokerPermission")) {
                            this.brokerController.getTopicConfigManager().getDataVersion().nextVersion();
                            this.brokerController.registerBrokerAll(false, false, true);
                        }
                        break block5;
                    }
                    log.error("string2Properties error");
                    response.setCode(1);
                    response.setRemark("string2Properties error");
                    return response;
                }
                catch (UnsupportedEncodingException e) {
                    log.error("", (Throwable)e);
                    response.setCode(1);
                    response.setRemark("UnsupportedEncodingException " + e);
                    return response;
                }
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerConfigResponseHeader.class);
        GetBrokerConfigResponseHeader responseHeader = (GetBrokerConfigResponseHeader)response.readCustomHeader();
        String content = this.brokerController.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        responseHeader.setVersion(this.brokerController.getConfiguration().getDataVersionJson());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand searchOffsetByTimestamp(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(SearchOffsetResponseHeader.class);
        SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.readCustomHeader();
        SearchOffsetRequestHeader requestHeader = (SearchOffsetRequestHeader)request.decodeCommandCustomHeader(SearchOffsetRequestHeader.class);
        long offset = this.brokerController.getMessageStore().getOffsetInQueueByTime(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getTimestamp().longValue());
        responseHeader.setOffset(Long.valueOf(offset));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand getMaxOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        LogicalQueueRouteData requestLogicalQueueRouteData;
        LogicalQueuesInfoInBroker logicalQueuesInfo;
        RemotingCommand response = RemotingCommand.createResponseCommand(GetMaxOffsetResponseHeader.class);
        GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.readCustomHeader();
        GetMaxOffsetRequestHeader requestHeader = (GetMaxOffsetRequestHeader)request.decodeCommandCustomHeader(GetMaxOffsetRequestHeader.class);
        String topic = requestHeader.getTopic();
        int queueId = requestHeader.getQueueId();
        if (requestHeader.getLogicalQueue() && (logicalQueuesInfo = this.brokerController.getTopicConfigManager().selectLogicalQueuesInfo(topic)) != null && (requestLogicalQueueRouteData = logicalQueuesInfo.queryQueueRouteDataByQueueId(queueId, Long.MAX_VALUE)) != null) {
            logicalQueuesInfo.readLock().lock();
            try {
                LogicalQueueRouteData selectedLogicalQueueRouteData;
                List queueRouteDataList = (List)logicalQueuesInfo.get(requestLogicalQueueRouteData.getLogicalQueueIndex());
                if (queueRouteDataList != null && !queueRouteDataList.isEmpty() && !Objects.equals((selectedLogicalQueueRouteData = (LogicalQueueRouteData)queueRouteDataList.get(queueRouteDataList.size() - 1)).getMessageQueue(), new MessageQueue(topic, this.brokerController.getBrokerConfig().getBrokerName(), queueId))) {
                    log.info("getMaxOffset topic={} queueId={} not latest, redirect: {}", new Object[]{topic, queueId, selectedLogicalQueueRouteData});
                    response.addExtField("REDIRECT", "1");
                }
            }
            finally {
                logicalQueuesInfo.readLock().unlock();
            }
        }
        long offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId, requestHeader.isCommitted());
        responseHeader.setOffset(Long.valueOf(offset));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getMinOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetMinOffsetResponseHeader.class);
        GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)response.readCustomHeader();
        GetMinOffsetRequestHeader requestHeader = (GetMinOffsetRequestHeader)request.decodeCommandCustomHeader(GetMinOffsetRequestHeader.class);
        long offset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        responseHeader.setOffset(Long.valueOf(offset));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getEarliestMsgStoretime(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetEarliestMsgStoretimeResponseHeader.class);
        GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)response.readCustomHeader();
        GetEarliestMsgStoretimeRequestHeader requestHeader = (GetEarliestMsgStoretimeRequestHeader)request.decodeCommandCustomHeader(GetEarliestMsgStoretimeRequestHeader.class);
        long timestamp = this.brokerController.getMessageStore().getEarliestMessageTime(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        responseHeader.setTimestamp(Long.valueOf(timestamp));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerRuntimeInfo(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        HashMap<String, String> runtimeInfo = this.prepareRuntimeInfo();
        KVTable kvTable = new KVTable();
        kvTable.setTable(runtimeInfo);
        byte[] body = kvTable.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand lockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LockBatchRequestBody requestBody = (LockBatchRequestBody)LockBatchRequestBody.decode((byte[])request.getBody(), LockBatchRequestBody.class);
        Set<MessageQueue> lockOKMQSet = this.brokerController.getRebalanceLockManager().tryLockBatch(requestBody.getConsumerGroup(), requestBody.getMqSet(), requestBody.getClientId());
        LockBatchResponseBody responseBody = new LockBatchResponseBody();
        responseBody.setLockOKMQSet(lockOKMQSet);
        response.setBody(responseBody.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand unlockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UnlockBatchRequestBody requestBody = (UnlockBatchRequestBody)UnlockBatchRequestBody.decode((byte[])request.getBody(), UnlockBatchRequestBody.class);
        this.brokerController.getRebalanceLockManager().unlockBatch(requestBody.getConsumerGroup(), requestBody.getMqSet(), requestBody.getClientId());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand updateAndCreateSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        log.info("updateAndCreateSubscriptionGroup called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        SubscriptionGroupConfig config = (SubscriptionGroupConfig)RemotingSerializable.decode((byte[])request.getBody(), SubscriptionGroupConfig.class);
        if (config != null) {
            this.brokerController.getSubscriptionGroupManager().updateSubscriptionGroupConfig(config);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getSubscriptionGroupManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            log.error("No subscription group in this broker, client:{} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No subscription group in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand deleteSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteSubscriptionGroupRequestHeader requestHeader = (DeleteSubscriptionGroupRequestHeader)request.decodeCommandCustomHeader(DeleteSubscriptionGroupRequestHeader.class);
        log.info("deleteSubscriptionGroup called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        this.brokerController.getSubscriptionGroupManager().deleteSubscriptionGroupConfig(requestHeader.getGroupName());
        if (requestHeader.isRemoveOffset()) {
            this.brokerController.getConsumerOffsetManager().removeOffset(requestHeader.getGroupName());
        }
        if (this.brokerController.getBrokerConfig().isAutoDeleteUnusedStats()) {
            this.brokerController.getBrokerStatsManager().onGroupDeleted(requestHeader.getGroupName());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getTopicStatsInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetTopicStatsInfoRequestHeader requestHeader = (GetTopicStatsInfoRequestHeader)request.decodeCommandCustomHeader(GetTopicStatsInfoRequestHeader.class);
        String topic = requestHeader.getTopic();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("topic[" + topic + "] not exist");
            return response;
        }
        TopicStatsTable topicStatsTable = new TopicStatsTable();
        for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
            long max;
            MessageQueue mq = new MessageQueue();
            mq.setTopic(topic);
            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            mq.setQueueId(i);
            TopicOffset topicOffset = new TopicOffset();
            long min = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, i);
            if (min < 0L) {
                min = 0L;
            }
            if ((max = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i)) < 0L) {
                max = 0L;
            }
            long timestamp = 0L;
            if (max > 0L) {
                timestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, max - 1L);
            }
            topicOffset.setMinOffset(min);
            topicOffset.setMaxOffset(max);
            topicOffset.setLastUpdateTimestamp(timestamp);
            topicStatsTable.getOffsetTable().put(mq, topicOffset);
        }
        byte[] body = topicStatsTable.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConsumerConnectionList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumerConnectionListRequestHeader requestHeader = (GetConsumerConnectionListRequestHeader)request.decodeCommandCustomHeader(GetConsumerConnectionListRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
        if (consumerGroupInfo != null) {
            ConsumerConnection bodydata = new ConsumerConnection();
            bodydata.setConsumeFromWhere(consumerGroupInfo.getConsumeFromWhere());
            bodydata.setConsumeType(consumerGroupInfo.getConsumeType());
            bodydata.setMessageModel(consumerGroupInfo.getMessageModel());
            bodydata.getSubscriptionTable().putAll(consumerGroupInfo.getSubscriptionTable());
            Iterator it = consumerGroupInfo.getChannelInfoTable().entrySet().iterator();
            while (it.hasNext()) {
                ClientChannelInfo info = (ClientChannelInfo)it.next().getValue();
                Connection connection = new Connection();
                connection.setClientId(info.getClientId());
                connection.setLanguage(info.getLanguage());
                connection.setVersion(info.getVersion());
                connection.setClientAddr(RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()));
                bodydata.getConnectionSet().add(connection);
            }
            byte[] body = bodydata.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(206);
        response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] not online");
        return response;
    }

    private RemotingCommand getProducerConnectionList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetProducerConnectionListRequestHeader requestHeader = (GetProducerConnectionListRequestHeader)request.decodeCommandCustomHeader(GetProducerConnectionListRequestHeader.class);
        ProducerConnection bodydata = new ProducerConnection();
        Map channelInfoHashMap = this.brokerController.getProducerManager().getGroupChannelTable().get(requestHeader.getProducerGroup());
        if (channelInfoHashMap != null) {
            Iterator it = channelInfoHashMap.entrySet().iterator();
            while (it.hasNext()) {
                ClientChannelInfo info = (ClientChannelInfo)it.next().getValue();
                Connection connection = new Connection();
                connection.setClientId(info.getClientId());
                connection.setLanguage(info.getLanguage());
                connection.setVersion(info.getVersion());
                connection.setClientAddr(RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()));
                bodydata.getConnectionSet().add(connection);
            }
            byte[] body = bodydata.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(1);
        response.setRemark("the producer group[" + requestHeader.getProducerGroup() + "] not exist");
        return response;
    }

    private RemotingCommand getConsumeStats(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumeStatsRequestHeader requestHeader = (GetConsumeStatsRequestHeader)request.decodeCommandCustomHeader(GetConsumeStatsRequestHeader.class);
        ConsumeStats consumeStats = new ConsumeStats();
        Set<String> topics = new HashSet<String>();
        if (UtilAll.isBlank((String)requestHeader.getTopic())) {
            topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(requestHeader.getConsumerGroup());
        } else {
            topics.add(requestHeader.getTopic());
        }
        for (String topic : topics) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (null == topicConfig) {
                log.warn("consumeStats, topic config not exist, {}", (Object)topic);
                continue;
            }
            SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getConsumerGroup(), topic);
            if (null == findSubscriptionData && this.brokerController.getConsumerManager().findSubscriptionDataCount(requestHeader.getConsumerGroup()) > 0) {
                log.warn("consumeStats, the consumer group[{}], topic[{}] not exist", (Object)requestHeader.getConsumerGroup(), (Object)topic);
                continue;
            }
            for (int i = 0; i < topicConfig.getReadQueueNums(); ++i) {
                long lastTimestamp;
                long consumerOffset;
                MessageQueue mq = new MessageQueue();
                mq.setTopic(topic);
                mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                mq.setQueueId(i);
                OffsetWrapper offsetWrapper = new OffsetWrapper();
                long brokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
                if (brokerOffset < 0L) {
                    brokerOffset = 0L;
                }
                if ((consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), topic, i)) < 0L) {
                    consumerOffset = 0L;
                }
                offsetWrapper.setBrokerOffset(brokerOffset);
                offsetWrapper.setConsumerOffset(consumerOffset);
                long timeOffset = consumerOffset - 1L;
                if (timeOffset >= 0L && (lastTimestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, timeOffset)) > 0L) {
                    offsetWrapper.setLastTimestamp(lastTimestamp);
                }
                consumeStats.getOffsetTable().put(mq, offsetWrapper);
            }
            double consumeTps = this.brokerController.getBrokerStatsManager().tpsGroupGetNums(requestHeader.getConsumerGroup(), topic);
            consumeStats.setConsumeTps(consumeTps += consumeStats.getConsumeTps());
        }
        byte[] body = consumeStats.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getConsumerOffsetManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("get all consumer offset from master error.", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            log.error("No consumer offset in this broker, client: {} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No consumer offset in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllDelayOffset(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (!(this.brokerController.getMessageStore() instanceof DefaultMessageStore)) {
            log.error("Delay offset not supported in this messagetore, client: {} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("Delay offset not supported in this messagetore");
            return response;
        }
        String content = ((DefaultMessageStore)this.brokerController.getMessageStore()).getScheduleMessageService().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Get all delay offset from master error.", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            log.error("No delay offset in this broker, client: {} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No delay offset in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand resetOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResetOffsetRequestHeader requestHeader = (ResetOffsetRequestHeader)request.decodeCommandCustomHeader(ResetOffsetRequestHeader.class);
        log.info("[reset-offset] reset offset started by {}. topic={}, group={}, timestamp={}, isForce={}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getTimestamp(), requestHeader.isForce()});
        boolean isC = false;
        LanguageCode language = request.getLanguage();
        switch (language) {
            case CPP: {
                isC = true;
            }
        }
        return this.brokerController.getBroker2Client().resetOffset(requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getTimestamp(), requestHeader.isForce(), isC);
    }

    public RemotingCommand getConsumerStatus(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetConsumerStatusRequestHeader requestHeader = (GetConsumerStatusRequestHeader)request.decodeCommandCustomHeader(GetConsumerStatusRequestHeader.class);
        log.info("[get-consumer-status] get consumer status by {}. topic={}, group={}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getTopic(), requestHeader.getGroup()});
        return this.brokerController.getBroker2Client().getConsumeStatus(requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getClientAddr());
    }

    private RemotingCommand queryTopicConsumeByWho(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryTopicConsumeByWhoRequestHeader requestHeader = (QueryTopicConsumeByWhoRequestHeader)request.decodeCommandCustomHeader(QueryTopicConsumeByWhoRequestHeader.class);
        HashSet<String> groups = this.brokerController.getConsumerManager().queryTopicConsumeByWho(requestHeader.getTopic());
        Set<String> groupInOffset = this.brokerController.getConsumerOffsetManager().whichGroupByTopic(requestHeader.getTopic());
        if (groupInOffset != null && !groupInOffset.isEmpty()) {
            groups.addAll(groupInOffset);
        }
        GroupList groupList = new GroupList();
        groupList.setGroupList(groups);
        byte[] body = groupList.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand registerFilterServer(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(RegisterFilterServerResponseHeader.class);
        RegisterFilterServerResponseHeader responseHeader = (RegisterFilterServerResponseHeader)response.readCustomHeader();
        RegisterFilterServerRequestHeader requestHeader = (RegisterFilterServerRequestHeader)request.decodeCommandCustomHeader(RegisterFilterServerRequestHeader.class);
        this.brokerController.getFilterServerManager().registerFilterServer(ctx.channel(), requestHeader.getFilterServerAddr());
        responseHeader.setBrokerId(this.brokerController.getBrokerConfig().getBrokerId());
        responseHeader.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand queryConsumeTimeSpan(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryConsumeTimeSpanRequestHeader requestHeader = (QueryConsumeTimeSpanRequestHeader)request.decodeCommandCustomHeader(QueryConsumeTimeSpanRequestHeader.class);
        String topic = requestHeader.getTopic();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("topic[" + topic + "] not exist");
            return response;
        }
        ArrayList<QueueTimeSpan> timeSpanSet = new ArrayList<QueueTimeSpan>();
        for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
            QueueTimeSpan timeSpan = new QueueTimeSpan();
            MessageQueue mq = new MessageQueue();
            mq.setTopic(topic);
            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            mq.setQueueId(i);
            timeSpan.setMessageQueue(mq);
            long minTime = this.brokerController.getMessageStore().getEarliestMessageTime(topic, i);
            timeSpan.setMinTimeStamp(minTime);
            long max = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
            long maxTime = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, max - 1L);
            timeSpan.setMaxTimeStamp(maxTime);
            long consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getGroup(), topic, i);
            long consumeTime = consumerOffset > 0L ? this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, consumerOffset - 1L) : minTime;
            timeSpan.setConsumeTimeStamp(consumeTime);
            long maxBrokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), i);
            if (consumerOffset < maxBrokerOffset) {
                long nextTime = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, consumerOffset);
                timeSpan.setDelayTime(System.currentTimeMillis() - nextTime);
            }
            timeSpanSet.add(timeSpan);
        }
        QueryConsumeTimeSpanBody queryConsumeTimeSpanBody = new QueryConsumeTimeSpanBody();
        queryConsumeTimeSpanBody.setConsumeTimeSpanSet(timeSpanSet);
        response.setBody(queryConsumeTimeSpanBody.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getSystemTopicListFromBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        Set topics = TopicValidator.getSystemTopicSet();
        TopicList topicList = new TopicList();
        topicList.setTopicList(topics);
        response.setBody(topicList.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand cleanExpiredConsumeQueue() {
        log.warn("invoke cleanExpiredConsumeQueue start.");
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        this.brokerController.getMessageStore().cleanExpiredConsumerQueue();
        log.warn("invoke cleanExpiredConsumeQueue end.");
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand cleanUnusedTopic() {
        log.warn("invoke cleanUnusedTopic start.");
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        this.brokerController.getMessageStore().cleanUnusedTopic(this.brokerController.getTopicConfigManager().getTopicConfigTable().keySet());
        log.warn("invoke cleanUnusedTopic end.");
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConsumerRunningInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetConsumerRunningInfoRequestHeader requestHeader = (GetConsumerRunningInfoRequestHeader)request.decodeCommandCustomHeader(GetConsumerRunningInfoRequestHeader.class);
        return this.callConsumer(307, request, requestHeader.getConsumerGroup(), requestHeader.getClientId());
    }

    private RemotingCommand queryCorrectionOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryCorrectionOffsetHeader requestHeader = (QueryCorrectionOffsetHeader)request.decodeCommandCustomHeader(QueryCorrectionOffsetHeader.class);
        Map<Integer, Long> correctionOffset = this.brokerController.getConsumerOffsetManager().queryMinOffsetInAllGroup(requestHeader.getTopic(), requestHeader.getFilterGroups());
        Map<Integer, Long> compareOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getTopic(), requestHeader.getCompareGroup());
        if (compareOffset != null && !compareOffset.isEmpty()) {
            for (Map.Entry<Integer, Long> entry : compareOffset.entrySet()) {
                Integer queueId;
                correctionOffset.put(queueId, correctionOffset.get(queueId = entry.getKey()) > entry.getValue() ? Long.valueOf(Long.MAX_VALUE) : correctionOffset.get(queueId));
            }
        }
        QueryCorrectionOffsetBody body = new QueryCorrectionOffsetBody();
        body.setCorrectionOffsets(correctionOffset);
        response.setBody(body.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand consumeMessageDirectly(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ConsumeMessageDirectlyResultRequestHeader requestHeader = (ConsumeMessageDirectlyResultRequestHeader)request.decodeCommandCustomHeader(ConsumeMessageDirectlyResultRequestHeader.class);
        request.getExtFields().put("brokerName", this.brokerController.getBrokerConfig().getBrokerName());
        SelectMappedBufferResult selectMappedBufferResult = null;
        try {
            MessageId messageId = MessageDecoder.decodeMessageId((String)requestHeader.getMsgId());
            selectMappedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(messageId.getOffset());
            byte[] body = new byte[selectMappedBufferResult.getSize()];
            selectMappedBufferResult.getByteBuffer().get(body);
            request.setBody(body);
        }
        catch (UnknownHostException unknownHostException) {
        }
        finally {
            if (selectMappedBufferResult != null) {
                selectMappedBufferResult.release();
            }
        }
        return this.callConsumer(309, request, requestHeader.getConsumerGroup(), requestHeader.getClientId());
    }

    private RemotingCommand cloneGroupOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        Set<Object> topics;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CloneGroupOffsetRequestHeader requestHeader = (CloneGroupOffsetRequestHeader)request.decodeCommandCustomHeader(CloneGroupOffsetRequestHeader.class);
        if (UtilAll.isBlank((String)requestHeader.getTopic())) {
            topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(requestHeader.getSrcGroup());
        } else {
            topics = new HashSet<String>();
            topics.add(requestHeader.getTopic());
        }
        for (String string : topics) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(string);
            if (null == topicConfig) {
                log.warn("[cloneGroupOffset], topic config not exist, {}", (Object)string);
                continue;
            }
            if (!requestHeader.isOffline()) {
                SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getSrcGroup(), string);
                if (this.brokerController.getConsumerManager().findSubscriptionDataCount(requestHeader.getSrcGroup()) > 0 && findSubscriptionData == null) {
                    log.warn("[cloneGroupOffset], the consumer group[{}], topic[{}] not exist", (Object)requestHeader.getSrcGroup(), (Object)string);
                    continue;
                }
            }
            this.brokerController.getConsumerOffsetManager().cloneOffset(requestHeader.getSrcGroup(), requestHeader.getDestGroup(), requestHeader.getTopic());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand ViewBrokerStatsData(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ViewBrokerStatsDataRequestHeader requestHeader = (ViewBrokerStatsDataRequestHeader)request.decodeCommandCustomHeader(ViewBrokerStatsDataRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        MessageStore messageStore = this.brokerController.getMessageStore();
        StatsItem statsItem = messageStore.getBrokerStatsManager().getStatsItem(requestHeader.getStatsName(), requestHeader.getStatsKey());
        if (null == statsItem) {
            response.setCode(1);
            response.setRemark(String.format("The stats <%s> <%s> not exist", requestHeader.getStatsName(), requestHeader.getStatsKey()));
            return response;
        }
        BrokerStatsData brokerStatsData = new BrokerStatsData();
        BrokerStatsItem it = new BrokerStatsItem();
        StatsSnapshot ss = statsItem.getStatsDataInMinute();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsMinute(it);
        it = new BrokerStatsItem();
        ss = statsItem.getStatsDataInHour();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsHour(it);
        it = new BrokerStatsItem();
        ss = statsItem.getStatsDataInDay();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsDay(it);
        response.setBody(brokerStatsData.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand fetchAllConsumeStatsInBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumeStatsInBrokerHeader requestHeader = (GetConsumeStatsInBrokerHeader)request.decodeCommandCustomHeader(GetConsumeStatsInBrokerHeader.class);
        boolean isOrder = requestHeader.isOrder();
        ConcurrentMap<String, SubscriptionGroupConfig> subscriptionGroups = this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable();
        ArrayList brokerConsumeStatsList = new ArrayList();
        long totalDiff = 0L;
        for (String group : subscriptionGroups.keySet()) {
            HashMap subscripTopicConsumeMap = new HashMap();
            Set<String> topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(group);
            ArrayList<ConsumeStats> consumeStatsList = new ArrayList<ConsumeStats>();
            for (String topic : topics) {
                ConsumeStats consumeStats = new ConsumeStats();
                TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
                if (null == topicConfig) {
                    log.warn("consumeStats, topic config not exist, {}", (Object)topic);
                    continue;
                }
                if (isOrder && !topicConfig.isOrder()) continue;
                SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(group, topic);
                if (null == findSubscriptionData && this.brokerController.getConsumerManager().findSubscriptionDataCount(group) > 0) {
                    log.warn("consumeStats, the consumer group[{}], topic[{}] not exist", (Object)group, (Object)topic);
                    continue;
                }
                for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
                    long lastTimestamp;
                    long consumerOffset;
                    MessageQueue mq = new MessageQueue();
                    mq.setTopic(topic);
                    mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                    mq.setQueueId(i);
                    OffsetWrapper offsetWrapper = new OffsetWrapper();
                    long brokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
                    if (brokerOffset < 0L) {
                        brokerOffset = 0L;
                    }
                    if ((consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(group, topic, i)) < 0L) {
                        consumerOffset = 0L;
                    }
                    offsetWrapper.setBrokerOffset(brokerOffset);
                    offsetWrapper.setConsumerOffset(consumerOffset);
                    long timeOffset = consumerOffset - 1L;
                    if (timeOffset >= 0L && (lastTimestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, timeOffset)) > 0L) {
                        offsetWrapper.setLastTimestamp(lastTimestamp);
                    }
                    consumeStats.getOffsetTable().put(mq, offsetWrapper);
                }
                double consumeTps = this.brokerController.getBrokerStatsManager().tpsGroupGetNums(group, topic);
                consumeStats.setConsumeTps(consumeTps += consumeStats.getConsumeTps());
                totalDiff += consumeStats.computeTotalDiff();
                consumeStatsList.add(consumeStats);
            }
            subscripTopicConsumeMap.put(group, consumeStatsList);
            brokerConsumeStatsList.add(subscripTopicConsumeMap);
        }
        ConsumeStatsList consumeStats = new ConsumeStatsList();
        consumeStats.setBrokerAddr(this.brokerController.getBrokerAddr());
        consumeStats.setConsumeStatsList(brokerConsumeStatsList);
        consumeStats.setTotalDiff(totalDiff);
        response.setBody(consumeStats.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private HashMap<String, String> prepareRuntimeInfo() {
        File commitLogDir;
        HashMap runtimeInfo = this.brokerController.getMessageStore().getRuntimeInfo();
        runtimeInfo.put("brokerVersionDesc", MQVersion.getVersionDesc((int)MQVersion.CURRENT_VERSION));
        runtimeInfo.put("brokerVersion", String.valueOf(MQVersion.CURRENT_VERSION));
        runtimeInfo.put("msgPutTotalYesterdayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalYesterdayMorning()));
        runtimeInfo.put("msgPutTotalTodayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalTodayMorning()));
        runtimeInfo.put("msgPutTotalTodayNow", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalTodayNow()));
        runtimeInfo.put("msgGetTotalYesterdayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalYesterdayMorning()));
        runtimeInfo.put("msgGetTotalTodayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalTodayMorning()));
        runtimeInfo.put("msgGetTotalTodayNow", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalTodayNow()));
        runtimeInfo.put("sendThreadPoolQueueSize", String.valueOf(this.brokerController.getSendThreadPoolQueue().size()));
        runtimeInfo.put("sendThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getSendThreadPoolQueueCapacity()));
        runtimeInfo.put("pullThreadPoolQueueSize", String.valueOf(this.brokerController.getPullThreadPoolQueue().size()));
        runtimeInfo.put("pullThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getPullThreadPoolQueueCapacity()));
        runtimeInfo.put("queryThreadPoolQueueSize", String.valueOf(this.brokerController.getQueryThreadPoolQueue().size()));
        runtimeInfo.put("queryThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getQueryThreadPoolQueueCapacity()));
        runtimeInfo.put("EndTransactionQueueSize", String.valueOf(this.brokerController.getEndTransactionThreadPoolQueue().size()));
        runtimeInfo.put("EndTransactionThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getEndTransactionPoolQueueCapacity()));
        runtimeInfo.put("dispatchBehindBytes", String.valueOf(this.brokerController.getMessageStore().dispatchBehindBytes()));
        runtimeInfo.put("pageCacheLockTimeMills", String.valueOf(this.brokerController.getMessageStore().lockTimeMills()));
        runtimeInfo.put("sendThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4SendThreadPoolQueue()));
        runtimeInfo.put("pullThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4PullThreadPoolQueue()));
        runtimeInfo.put("queryThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4QueryThreadPoolQueue()));
        runtimeInfo.put("earliestMessageTimeStamp", String.valueOf(this.brokerController.getMessageStore().getEarliestMessageTime()));
        runtimeInfo.put("startAcceptSendRequestTimeStamp", String.valueOf(this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp()));
        if (this.brokerController.getMessageStore() instanceof DefaultMessageStore) {
            DefaultMessageStore defaultMessageStore = (DefaultMessageStore)this.brokerController.getMessageStore();
            runtimeInfo.put("remainTransientStoreBufferNumbs", String.valueOf(defaultMessageStore.remainTransientStoreBufferNumbs()));
            if (defaultMessageStore.getMessageStoreConfig().isTransientStorePoolEnable()) {
                runtimeInfo.put("remainHowManyDataToCommit", MixAll.humanReadableByteCount((long)defaultMessageStore.getCommitLog().remainHowManyDataToCommit(), (boolean)false));
            }
            runtimeInfo.put("remainHowManyDataToFlush", MixAll.humanReadableByteCount((long)defaultMessageStore.getCommitLog().remainHowManyDataToFlush(), (boolean)false));
        }
        if ((commitLogDir = new File(this.brokerController.getMessageStoreConfig().getStorePathRootDir())).exists()) {
            runtimeInfo.put("commitLogDirCapacity", String.format("Total : %s, Free : %s.", MixAll.humanReadableByteCount((long)commitLogDir.getTotalSpace(), (boolean)false), MixAll.humanReadableByteCount((long)commitLogDir.getFreeSpace(), (boolean)false)));
        }
        return runtimeInfo;
    }

    private RemotingCommand callConsumer(int requestCode, RemotingCommand request, String consumerGroup, String clientId) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ClientChannelInfo clientChannelInfo = this.brokerController.getConsumerManager().findChannel(consumerGroup, clientId);
        if (null == clientChannelInfo) {
            response.setCode(1);
            response.setRemark(String.format("The Consumer <%s> <%s> not online", consumerGroup, clientId));
            return response;
        }
        if (clientChannelInfo.getVersion() < MQVersion.Version.V3_1_8_SNAPSHOT.ordinal()) {
            response.setCode(1);
            response.setRemark(String.format("The Consumer <%s> Version <%s> too low to finish, please upgrade it to V3_1_8_SNAPSHOT", clientId, MQVersion.getVersionDesc((int)clientChannelInfo.getVersion())));
            return response;
        }
        try {
            RemotingCommand newRequest = RemotingCommand.createRequestCommand((int)requestCode, null);
            newRequest.setExtFields(request.getExtFields());
            newRequest.setBody(request.getBody());
            return this.brokerController.getBroker2Client().callClient(clientChannelInfo.getChannel(), newRequest);
        }
        catch (RemotingTimeoutException e) {
            response.setCode(207);
            response.setRemark(String.format("consumer <%s> <%s> Timeout: %s", consumerGroup, clientId, RemotingHelper.exceptionSimpleDesc((Throwable)e)));
            return response;
        }
        catch (Exception e) {
            response.setCode(1);
            response.setRemark(String.format("invoke consumer <%s> <%s> Exception: %s", consumerGroup, clientId, RemotingHelper.exceptionSimpleDesc((Throwable)e)));
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand queryConsumeQueue(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        SelectMappedBufferResult result;
        QueryConsumeQueueRequestHeader requestHeader = (QueryConsumeQueueRequestHeader)request.decodeCommandCustomHeader(QueryConsumeQueueRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ConsumeQueue consumeQueue = this.brokerController.getMessageStore().getConsumeQueue(requestHeader.getTopic(), requestHeader.getQueueId());
        if (consumeQueue == null) {
            response.setCode(1);
            response.setRemark(String.format("%d@%s is not exist!", requestHeader.getQueueId(), requestHeader.getTopic()));
            return response;
        }
        response.setCode(0);
        QueryConsumeQueueResponseBody body = new QueryConsumeQueueResponseBody();
        body.setMaxQueueIndex(consumeQueue.getMaxOffsetInQueue());
        body.setMinQueueIndex(consumeQueue.getMinOffsetInQueue());
        ExpressionMessageFilter messageFilter = null;
        if (requestHeader.getConsumerGroup() != null) {
            SubscriptionData subscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getConsumerGroup(), requestHeader.getTopic());
            body.setSubscriptionData(subscriptionData);
            if (subscriptionData == null) {
                body.setFilterData(String.format("%s@%s is not online!", requestHeader.getConsumerGroup(), requestHeader.getTopic()));
            } else {
                ConsumerFilterData filterData = this.brokerController.getConsumerFilterManager().get(requestHeader.getTopic(), requestHeader.getConsumerGroup());
                body.setFilterData(JSON.toJSONString((Object)filterData, (boolean)true));
                messageFilter = new ExpressionMessageFilter(subscriptionData, filterData, this.brokerController.getConsumerFilterManager());
            }
        }
        if ((result = consumeQueue.getIndexBuffer(requestHeader.getIndex())) == null) {
            response.setRemark(String.format("Index %d of %d@%s is not exist!", requestHeader.getIndex(), requestHeader.getQueueId(), requestHeader.getTopic()));
            return response;
        }
        try {
            ArrayList<ConsumeQueueData> queues = new ArrayList<ConsumeQueueData>();
            for (int i = 0; i < result.getSize() && i < requestHeader.getCount() * 20; i += 20) {
                ConsumeQueueData one = new ConsumeQueueData();
                one.setPhysicOffset(result.getByteBuffer().getLong());
                one.setPhysicSize(result.getByteBuffer().getInt());
                one.setTagsCode(result.getByteBuffer().getLong());
                if (!consumeQueue.isExtAddr(one.getTagsCode())) {
                    queues.add(one);
                    continue;
                }
                ConsumeQueueExt.CqExtUnit cqExtUnit = consumeQueue.getExt(one.getTagsCode());
                if (cqExtUnit != null) {
                    one.setExtendDataJson(JSON.toJSONString((Object)cqExtUnit));
                    if (cqExtUnit.getFilterBitMap() != null) {
                        one.setBitMap(BitsArray.create((byte[])cqExtUnit.getFilterBitMap()).toString());
                    }
                    if (messageFilter != null) {
                        one.setEval(messageFilter.isMatchedByConsumeQueue(cqExtUnit.getTagsCode(), cqExtUnit));
                    }
                } else {
                    one.setMsg("Cq extend not exist!addr: " + one.getTagsCode());
                }
                queues.add(one);
            }
            body.setQueueData(queues);
        }
        finally {
            result.release();
        }
        response.setBody(body.encode());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand resumeCheckHalfMessage(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResumeCheckHalfMessageRequestHeader requestHeader = (ResumeCheckHalfMessageRequestHeader)request.decodeCommandCustomHeader(ResumeCheckHalfMessageRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        SelectMappedBufferResult selectMappedBufferResult = null;
        try {
            MessageId messageId = MessageDecoder.decodeMessageId((String)requestHeader.getMsgId());
            selectMappedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(messageId.getOffset());
            MessageExt msg = MessageDecoder.decode((ByteBuffer)selectMappedBufferResult.getByteBuffer());
            msg.putUserProperty("TRANSACTION_CHECK_TIMES", String.valueOf(0));
            PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(this.toMessageExtBrokerInner(msg));
            if (putMessageResult != null && putMessageResult.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                log.info("Put message back to RMQ_SYS_TRANS_HALF_TOPIC. real topic={}", (Object)msg.getUserProperty("REAL_TOPIC"));
                response.setCode(0);
                response.setRemark(null);
            } else {
                log.error("Put message back to RMQ_SYS_TRANS_HALF_TOPIC failed.");
                response.setCode(1);
                response.setRemark("Put message back to RMQ_SYS_TRANS_HALF_TOPIC failed.");
            }
        }
        catch (Exception e) {
            log.error("Exception was thrown when putting message back to RMQ_SYS_TRANS_HALF_TOPIC.");
            response.setCode(1);
            response.setRemark("Exception was thrown when putting message back to RMQ_SYS_TRANS_HALF_TOPIC.");
        }
        finally {
            if (selectMappedBufferResult != null) {
                selectMappedBufferResult.release();
            }
        }
        return response;
    }

    private MessageExtBrokerInner toMessageExtBrokerInner(MessageExt msgExt) {
        MessageExtBrokerInner inner = new MessageExtBrokerInner();
        inner.setTopic(TransactionalMessageUtil.buildHalfTopic());
        inner.setBody(msgExt.getBody());
        inner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)inner, (Map)msgExt.getProperties());
        inner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        inner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((String)msgExt.getTags()));
        inner.setQueueId(0);
        inner.setSysFlag(msgExt.getSysFlag());
        inner.setBornHost(msgExt.getBornHost());
        inner.setBornTimestamp(msgExt.getBornTimestamp());
        inner.setStoreHost(msgExt.getStoreHost());
        inner.setReconsumeTimes(msgExt.getReconsumeTimes());
        inner.setMsgId(msgExt.getMsgId());
        inner.setWaitStoreMsgOK(false);
        return inner;
    }

    private RemotingCommand getTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetTopicConfigRequestHeader requestHeader = (GetTopicConfigRequestHeader)request.decodeCommandCustomHeader(GetTopicConfigRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        TopicConfig topicConfig = (TopicConfig)this.brokerController.getTopicConfigManager().getTopicConfigTable().get(requestHeader.getTopic());
        if (topicConfig == null) {
            log.error("No topic in this broker, client: {} topic: {}", (Object)ctx.channel().remoteAddress(), (Object)requestHeader.getTopic());
            response.setCode(1);
            response.setRemark("No topic in this broker. topic: " + requestHeader.getTopic());
            return response;
        }
        String content = JSONObject.toJSONString((Object)topicConfig);
        try {
            response.setBody(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException getTopicConfig: topic=" + topicConfig.getTopicName(), (Throwable)e);
            response.setCode(1);
            response.setRemark("UnsupportedEncodingException " + e.getMessage());
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand updateTopicLogicalQueueMapping(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        LogicalQueuesInfoInBroker logicalQueuesInfo;
        UpdateTopicLogicalQueueMappingRequestBody requestBody = (UpdateTopicLogicalQueueMappingRequestBody)RemotingSerializable.decode((byte[])request.getBody(), UpdateTopicLogicalQueueMappingRequestBody.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(1);
        response.setRemark("unknown error");
        if (requestBody == null) {
            response.setRemark("decode null");
            return response;
        }
        String topic = requestBody.getTopic();
        int queueId = requestBody.getQueueId();
        String brokerName = this.brokerController.getBrokerConfig().getBrokerName();
        int logicalQueueIdx = requestBody.getLogicalQueueIdx();
        log.info("updateTopicLogicalQueueMapping topic={} queueId={} logicalQueueIndex={}", new Object[]{topic, queueId, logicalQueueIdx});
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        TopicConfig topicConfig = topicConfigManager.selectTopicConfig(topic);
        if (topicConfig == null) {
            log.warn("updateTopicLogicalQueueMapping topic={} queueId={} logicalQueueIndex={} topic not exist", new Object[]{topic, queueId, logicalQueueIdx});
            response.setRemark("topic not exist");
            return response;
        }
        LogicalQueueRouteData newQueueRouteData = new LogicalQueueRouteData();
        newQueueRouteData.setBrokerAddr(this.brokerController.getBrokerAddr());
        newQueueRouteData.setMessageQueue(new MessageQueue(topic, brokerName, queueId));
        if (logicalQueueIdx >= 0) {
            newQueueRouteData.setLogicalQueueIndex(logicalQueueIdx);
            newQueueRouteData.setLogicalQueueDelta(0L);
            newQueueRouteData.setState(MessageQueueRouteState.Normal);
            logicalQueuesInfo = topicConfigManager.getOrCreateLogicalQueuesInfo(topic);
            logicalQueuesInfo.writeLock().lock();
            try {
                block7: for (List queueRouteDataList : logicalQueuesInfo.values()) {
                    Iterator iterator = queueRouteDataList.iterator();
                    while (iterator.hasNext()) {
                        LogicalQueueRouteData queueRouteData2 = (LogicalQueueRouteData)iterator.next();
                        if (!Objects.equals(queueRouteData2.getMessageQueue(), newQueueRouteData.getMessageQueue())) continue;
                        if (queueRouteData2.getLogicalQueueIndex() == logicalQueueIdx) {
                            log.info("updateTopicLogicalQueueMapping topic={} queueId={} logicalQueueIndex={} already set up", new Object[]{topic, queueId, logicalQueueIdx});
                            response.setCode(0);
                            response.setRemark("already set up");
                            RemotingCommand remotingCommand = response;
                            return remotingCommand;
                        }
                        log.warn("updateTopicLogicalQueueMapping topic={} queueId={} already assigned logicalQueueIdx={}, will reassign as logicalQueueIdx={}", new Object[]{topic, queueRouteData2.getMessageQueue(), queueRouteData2.getLogicalQueueIndex(), newQueueRouteData.getLogicalQueueIndex()});
                        iterator.remove();
                        continue block7;
                    }
                }
                List queueRouteDataList = (List)logicalQueuesInfo.computeIfAbsent(logicalQueueIdx, ignore -> Lists.newArrayListWithExpectedSize((int)1));
                int idx = Collections.binarySearch(queueRouteDataList, newQueueRouteData, Comparator.comparingLong(LogicalQueueRouteData::getLogicalQueueDelta).thenComparingInt(LogicalQueueRouteData::getStateOrdinal));
                if (idx >= 0) {
                    log.warn("updateTopicLogicalQueueMapping topic={} queueId={} logicalQueueIdx={} found same logicalQueueOffset and will replace, exist {}, new {}", new Object[]{topic, queueId, logicalQueueIdx, queueRouteDataList.get(idx), newQueueRouteData});
                    queueRouteDataList.set(idx, newQueueRouteData);
                    response.setCode(1);
                    response.setRemark("duplicate logicalQueueOffset found");
                }
                idx = -idx - 1;
                queueRouteDataList.add(idx, newQueueRouteData);
                logicalQueuesInfo.updateQueueRouteDataByQueueId(newQueueRouteData.getQueueId(), newQueueRouteData);
                response.setCode(0);
                response.setRemark("set up");
                log.info("updateTopicLogicalQueueMapping topic={} queueId={} logicalQueueIdx={} added as #{}", new Object[]{topic, queueId, logicalQueueIdx, idx});
            }
            finally {
                logicalQueuesInfo.writeLock().unlock();
            }
        } else {
            logicalQueuesInfo = topicConfigManager.getOrCreateLogicalQueuesInfo(topic);
            logicalQueuesInfo.writeLock().lock();
            try {
                for (List queueRouteDataList : logicalQueuesInfo.values()) {
                    queueRouteDataList.removeIf(queueRouteData -> Objects.equals(queueRouteData.getMessageQueue(), newQueueRouteData.getMessageQueue()));
                }
            }
            finally {
                logicalQueuesInfo.writeLock().unlock();
            }
            logicalQueuesInfo.updateQueueRouteDataByQueueId(newQueueRouteData.getQueueId(), null);
            this.brokerController.getSendMessageProcessor().getInFlyWritingCounterMap().remove(new TopicQueueId(topic, queueId));
            response.setCode(0);
            response.setRemark("deleted");
            log.info("updateTopicLogicalQueueMapping topic={} queueId={} deleted as logical queue", new Object[]{topic, queueId, logicalQueueIdx});
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfig, topicConfigManager.getDataVersion());
        return response;
    }

    private RemotingCommand deleteTopicLogicalQueueMapping(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteTopicLogicalQueueRequestHeader requestHeader = (DeleteTopicLogicalQueueRequestHeader)request.decodeCommandCustomHeader(DeleteTopicLogicalQueueRequestHeader.class);
        String topic = requestHeader.getTopic();
        log.info("deleteTopicLogicalQueueMapping topic={}", (Object)topic);
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
        if (logicalQueuesInfo == null) {
            response.setCode(0);
            response.setRemark("already deleted");
            log.info("deleteTopicLogicalQueueMapping topic={} already deleted", (Object)topic);
            return response;
        }
        String brokerName = this.brokerController.getBrokerConfig().getBrokerName();
        long size = logicalQueuesInfo.values().stream().flatMap(Collection::stream).filter(v -> Objects.equals(v.getBrokerName(), brokerName)).count();
        if (size > 0L) {
            response.setCode(1);
            response.setRemark(String.format(Locale.ENGLISH, "still %d message queues", size));
            log.info("deleteTopicLogicalQueueMapping topic={} still {} message queues", (Object)topic, (Object)size);
            return response;
        }
        topicConfigManager.deleteQueueRouteData(topic);
        response.setCode(0);
        response.setRemark("deleted");
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        log.info("deleteTopicLogicalQueueMapping topic={} deleted", (Object)topic);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand queryTopicLogicalQueueMapping(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryTopicLogicalQueueMappingRequestHeader requestHeader = (QueryTopicLogicalQueueMappingRequestHeader)request.decodeCommandCustomHeader(QueryTopicLogicalQueueMappingRequestHeader.class);
        String topic = requestHeader.getTopic();
        log.info("queryTopicLogicalQueueMapping topic={}", (Object)topic);
        LogicalQueuesInfoInBroker logicalQueuesInfo = this.brokerController.getTopicConfigManager().selectLogicalQueuesInfo(topic);
        TreeMap result = null;
        if (logicalQueuesInfo != null) {
            result = Maps.newTreeMap();
            logicalQueuesInfo.readLock().lock();
            try {
                for (Map.Entry entry : logicalQueuesInfo.entrySet()) {
                    Integer k = (Integer)entry.getKey();
                    List v = (List)entry.getValue();
                    result.put(k, ImmutableList.copyOf((Collection)v));
                }
            }
            finally {
                logicalQueuesInfo.readLock().unlock();
            }
        }
        response.setCode(0);
        response.setBody(RemotingSerializable.encode((Object)result));
        return response;
    }

    private void sealLogicalQueueRouteData(LogicalQueueRouteData queueRouteData, MessageStore messageStore) throws TimeoutException, InterruptedException {
        LongAdder counter;
        queueRouteData.setState(MessageQueueRouteState.ReadOnly);
        String topic = queueRouteData.getTopic();
        int queueId = queueRouteData.getQueueId();
        TopicQueueId key = new TopicQueueId(topic, queueId);
        long startTime = System.currentTimeMillis();
        while ((counter = (LongAdder)this.brokerController.getSendMessageProcessor().getInFlyWritingCounterMap().get(key)) != null && counter.sum() != 0L) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                throw new TimeoutException();
            }
            Thread.sleep(100L);
        }
        while (messageStore.getMaxOffsetInQueue(topic, queueId, true) != messageStore.getMaxOffsetInQueue(topic, queueId, false)) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                throw new TimeoutException();
            }
            Thread.sleep(100L);
        }
        long firstMsgQueueOffset = messageStore.getMinOffsetInQueue(topic, queueId);
        long lastMsgQueueOffset = messageStore.getMaxOffsetInQueue(topic, queueId, false) - 1L;
        long firstMsgTimeMillis = 0L;
        long lastMsgTimeMillis = 0L;
        boolean expired = false;
        if (firstMsgQueueOffset == lastMsgQueueOffset) {
            expired = true;
        } else {
            long lastMsgCommitLogOffset;
            long minPhyOffset = messageStore.getMinPhyOffset();
            long l = lastMsgCommitLogOffset = lastMsgQueueOffset >= 0L ? messageStore.getCommitLogOffsetInQueue(topic, queueId, lastMsgQueueOffset) : -1L;
            if (lastMsgCommitLogOffset < minPhyOffset) {
                expired = true;
            } else {
                long firstMsgCommitLogOffset = firstMsgQueueOffset >= 0L ? messageStore.getCommitLogOffsetInQueue(topic, queueId, firstMsgQueueOffset) : -1L;
                MessageExt firstMsg = firstMsgCommitLogOffset >= 0L ? messageStore.lookMessageByOffset(firstMsgCommitLogOffset) : null;
                firstMsgTimeMillis = firstMsg != null ? firstMsg.getStoreTimestamp() : 0L;
                MessageExt lastMsg = lastMsgCommitLogOffset >= 0L ? messageStore.lookMessageByOffset(lastMsgCommitLogOffset) : null;
                lastMsgTimeMillis = lastMsg != null ? lastMsg.getStoreTimestamp() : 0L;
            }
        }
        queueRouteData.setOffsetMax(lastMsgQueueOffset + 1L);
        queueRouteData.setFirstMsgTimeMillis(firstMsgTimeMillis);
        queueRouteData.setLastMsgTimeMillis(lastMsgTimeMillis);
        if (expired) {
            queueRouteData.setState(MessageQueueRouteState.Expired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand sealTopicLogicalQueue(ChannelHandlerContext ctx, RemotingCommand request) {
        LogicalQueueRouteData resultQueueRouteData;
        SealTopicLogicalQueueRequestBody requestBody = (SealTopicLogicalQueueRequestBody)RemotingSerializable.decode((byte[])request.getBody(), SealTopicLogicalQueueRequestBody.class);
        if (requestBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        String topic = requestBody.getTopic();
        int queueId = requestBody.getQueueId();
        int logicalQueueIdx = requestBody.getLogicalQueueIndex();
        log.info("sealTopicLogicalQueue topic={} queueId={}", (Object)topic, (Object)queueId);
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        TopicConfig topicConfig = topicConfigManager.selectTopicConfig(topic);
        if (topicConfig == null) {
            log.warn("sealTopicLogicalQueue topic={} queueId={} topic not exist", (Object)topic, (Object)queueId);
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not exist");
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.getOrCreateLogicalQueuesInfo(topic);
        logicalQueuesInfo.readLock().lock();
        try {
            List queueRouteDataList = (List)logicalQueuesInfo.get(logicalQueueIdx);
            if (queueRouteDataList == null) {
                log.info("sealTopicLogicalQueue topic={} queueId={} logicalQueueIdx={} not exist", new Object[]{topic, queueId, logicalQueueIdx});
                response.setRemark("logical queue not exist");
                RemotingCommand remotingCommand = response;
                return remotingCommand;
            }
            List foundQueues = queueRouteDataList.stream().filter(queueRouteData -> queueId == queueRouteData.getQueueId()).collect(Collectors.toList());
            if (foundQueues.isEmpty()) {
                log.info("sealTopicLogicalQueue topic={} queueId={} logicalQueueIdx={} queueId={} not exist", new Object[]{topic, queueId, logicalQueueIdx, queueId});
                response.setRemark("message queue not exist");
                RemotingCommand remotingCommand = response;
                return remotingCommand;
            }
            Optional<LogicalQueueRouteData> firstMainQueueRouteDataOptional = foundQueues.stream().filter(LogicalQueueRouteData::isWritable).findFirst();
            if (!firstMainQueueRouteDataOptional.isPresent()) {
                log.info("sealTopicLogicalQueue topic={} queueId={} logicalQueueIdx={} queueId={} already sealed", new Object[]{topic, queueId, logicalQueueIdx, queueId});
                response.setRemark("message queue already sealed");
                RemotingCommand remotingCommand = response;
                return remotingCommand;
            }
            resultQueueRouteData = firstMainQueueRouteDataOptional.get();
        }
        finally {
            logicalQueuesInfo.readLock().unlock();
        }
        try {
            this.sealLogicalQueueRouteData(resultQueueRouteData, this.brokerController.getMessageStore());
        }
        catch (InterruptedException e) {
            return RemotingCommand.createResponseCommand((int)1, (String)"thread interrupted");
        }
        catch (TimeoutException e) {
            return RemotingCommand.createResponseCommand((int)1, (String)"seal timeout");
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        response.setBody(RemotingSerializable.encode((Object)resultQueueRouteData));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand reuseTopicLogicalQueue(ChannelHandlerContext ctx, RemotingCommand request) {
        ReuseTopicLogicalQueueRequestBody requestBody = (ReuseTopicLogicalQueueRequestBody)RemotingSerializable.decode((byte[])request.getBody(), ReuseTopicLogicalQueueRequestBody.class);
        if (requestBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        String topic = requestBody.getTopic();
        int queueId = requestBody.getQueueId();
        String brokerName = this.brokerController.getBrokerConfig().getBrokerName();
        MessageQueue mq = new MessageQueue(topic, brokerName, queueId);
        int logicalQueueIdx = requestBody.getLogicalQueueIndex();
        MessageQueueRouteState messageQueueRouteState = requestBody.getMessageQueueRouteState();
        log.info("reuseTopicLogicalQueue topic={} queueId={} logicalQueueIdx={} messageQueueRouteState={}", new Object[]{topic, queueId, logicalQueueIdx, messageQueueRouteState});
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
        if (logicalQueuesInfo == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"queue route data not found");
        }
        if (queueId >= topicConfigManager.selectTopicConfig(topic).getWriteQueueNums()) {
            return RemotingCommand.createResponseCommand((int)1, (String)"found no queue");
        }
        logicalQueuesInfo.writeLock().lock();
        LogicalQueueRouteData queueRouteData = new LogicalQueueRouteData(logicalQueueIdx, MessageQueueRouteState.WriteOnly.equals((Object)messageQueueRouteState) ? -1L : 0L, new MessageQueue(topic, brokerName, queueId), messageQueueRouteState, this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId, false), -1L, -1L, -1L, this.brokerController.getBrokerAddr());
        try {
            if (logicalQueuesInfo.values().stream().flatMap(Collection::stream).filter(v -> Objects.equals(v.getMessageQueue(), mq)).anyMatch(LogicalQueueRouteData::isWritable)) {
                RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)"queue writable");
                return remotingCommand;
            }
            ((List)logicalQueuesInfo.computeIfAbsent(logicalQueueIdx, ignore -> Lists.newArrayListWithExpectedSize((int)1))).add(queueRouteData);
            logicalQueuesInfo.updateQueueRouteDataByQueueId(queueId, queueRouteData);
            this.brokerController.getSendMessageProcessor().getInFlyWritingCounterMap().remove(new TopicQueueId(topic, queueId));
        }
        finally {
            logicalQueuesInfo.writeLock().unlock();
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setBody(RemotingSerializable.encode((Object)queueRouteData));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand createMessageQueueForLogicalQueue(ChannelHandlerContext ctx, RemotingCommand request) {
        LogicalQueueRouteData queueRouteData;
        LogicalQueuesInfoInBroker logicalQueuesInfo;
        TopicConfig topicConfig;
        CreateMessageQueueForLogicalQueueRequestBody requestBody = (CreateMessageQueueForLogicalQueueRequestBody)RemotingSerializable.decode((byte[])request.getBody(), CreateMessageQueueForLogicalQueueRequestBody.class);
        if (requestBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        String topic = requestBody.getTopic();
        int logicalQueueIdx = requestBody.getLogicalQueueIndex();
        MessageQueueRouteState messageQueueStatus = requestBody.getMessageQueueStatus();
        log.info("createMessageQueueForLogicalQueue topic={} logicalQueueIdx={}", (Object)topic, (Object)logicalQueueIdx);
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        while (true) {
            if ((topicConfig = topicConfigManager.selectTopicConfig(topic)) == null || topicConfig.getWriteQueueNums() == 0) {
                topicConfig = (TopicConfig)ConcurrentHashMapUtil.computeIfAbsent(topicConfigManager.getTopicConfigTable(), (Object)topic, s -> new TopicConfig(topic, 0, 0, this.brokerController.getBrokerConfig().getBrokerPermission()));
                logicalQueuesInfo = topicConfigManager.getOrCreateLogicalQueuesInfo(topic);
            } else {
                logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
            }
            if (topicConfig.getWriteQueueNums() > 0 && logicalQueuesInfo == null) {
                return RemotingCommand.createResponseCommand((int)1, (String)"topic not enable logical queue");
            }
            TopicConfig newTopicConfig = new TopicConfig(topicConfig);
            newTopicConfig.setWriteQueueNums(newTopicConfig.getWriteQueueNums() + 1);
            newTopicConfig.setReadQueueNums(newTopicConfig.getReadQueueNums() + 1);
            int queueId = newTopicConfig.getWriteQueueNums() - 1;
            queueRouteData = new LogicalQueueRouteData();
            queueRouteData.setLogicalQueueIndex(logicalQueueIdx);
            queueRouteData.setBrokerAddr(this.brokerController.getBrokerAddr());
            queueRouteData.setMessageQueue(new MessageQueue(topic, this.brokerController.getBrokerConfig().getBrokerName(), queueId));
            if (messageQueueStatus != null) {
                queueRouteData.setState(messageQueueStatus);
                switch (messageQueueStatus) {
                    case WriteOnly: 
                    case Expired: {
                        queueRouteData.setLogicalQueueDelta(-1L);
                        break;
                    }
                    default: {
                        queueRouteData.setLogicalQueueDelta(0L);
                    }
                }
            }
            logicalQueuesInfo.writeLock().lock();
            try {
                List l = (List)logicalQueuesInfo.computeIfAbsent(logicalQueueIdx, i -> Lists.newArrayListWithExpectedSize((int)1));
                if (MessageQueueRouteState.WriteOnly.equals((Object)messageQueueStatus) && l.stream().anyMatch(LogicalQueueRouteData::isWriteOnly)) {
                    RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)"multiple WriteOnly queue");
                    return remotingCommand;
                }
                if (MessageQueueRouteState.Normal.equals((Object)messageQueueStatus) && l.stream().anyMatch(LogicalQueueRouteData::isWritable)) {
                    RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)"multiple writable queue");
                    return remotingCommand;
                }
                if (!topicConfigManager.replaceTopicConfig(topic, topicConfig, newTopicConfig)) continue;
                l.add(queueRouteData);
                logicalQueuesInfo.updateQueueRouteDataByQueueId(queueId, queueRouteData);
            }
            finally {
                logicalQueuesInfo.writeLock().unlock();
                continue;
            }
            break;
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfig, topicConfigManager.getDataVersion());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setBody(RemotingSerializable.encode((Object)queueRouteData));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand migrateTopicLogicalQueuePrepare(ChannelHandlerContext ctx, RemotingCommand request) {
        Object object;
        MigrateLogicalQueueBody reqRespBody = (MigrateLogicalQueueBody)RemotingSerializable.decode((byte[])request.getBody(), MigrateLogicalQueueBody.class);
        if (reqRespBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        LogicalQueueRouteData fromQueueRouteData = reqRespBody.getFromQueueRouteData();
        LogicalQueueRouteData toQueueRouteData = reqRespBody.getToQueueRouteData();
        log.info("migrateTopicLogicalQueuePrepare fromQueueRouteData={} toQueueRouteData={}", (Object)fromQueueRouteData, (Object)toQueueRouteData);
        MessageQueue fromMessageQueue = fromQueueRouteData.getMessageQueue();
        int fromQueueId = fromQueueRouteData.getQueueId();
        long fromOffsetDelta = fromQueueRouteData.getOffsetDelta();
        int logicalQueueIndex = fromQueueRouteData.getLogicalQueueIndex();
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        String topic = fromQueueRouteData.getTopic();
        if (!topicConfigManager.getTopicConfigTable().containsKey(topic)) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not exist");
        }
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
        if (logicalQueuesInfo == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not enable logical queue");
        }
        logicalQueuesInfo.writeLock().lock();
        try {
            List queueRouteDataList = (List)logicalQueuesInfo.get(logicalQueueIndex);
            if (queueRouteDataList == null) {
                RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)String.format(Locale.ENGLISH, "logical queue %d not exist", logicalQueueIndex));
                return remotingCommand;
            }
            fromQueueRouteData = null;
            for (LogicalQueueRouteData v : queueRouteDataList) {
                if (!v.isSameTo(fromMessageQueue, fromOffsetDelta)) continue;
                fromQueueRouteData = v;
                break;
            }
            if (fromQueueRouteData == null) {
                object = RemotingCommand.createResponseCommand((int)1, (String)String.format(Locale.ENGLISH, "message queue %d not exist", fromQueueId));
                return object;
            }
            if (!MessageQueueRouteState.Normal.equals((Object)fromQueueRouteData.getState())) {
                object = RemotingCommand.createResponseCommand((int)1, (String)String.format(Locale.ENGLISH, "message queue %d not normal state", fromQueueId));
                return object;
            }
            reqRespBody.setFromQueueRouteData(fromQueueRouteData);
            if (fromQueueRouteData.isWritable()) {
                this.sealLogicalQueueRouteData(fromQueueRouteData, this.brokerController.getMessageStore());
            }
            toQueueRouteData.setLogicalQueueDelta(fromQueueRouteData.getLogicalQueueDelta() + fromQueueRouteData.getMessagesCount());
            queueRouteDataList.add(toQueueRouteData);
        }
        catch (InterruptedException e) {
            object = RemotingCommand.createResponseCommand((int)1, (String)"thread interrupted");
            return object;
        }
        catch (TimeoutException e) {
            object = RemotingCommand.createResponseCommand((int)1, (String)"seal timeout");
            return object;
        }
        finally {
            logicalQueuesInfo.writeLock().unlock();
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setBody(RemotingSerializable.encode((Object)reqRespBody));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand migrateTopicLogicalQueueCommit(ChannelHandlerContext ctx, RemotingCommand request) {
        MigrateLogicalQueueBody reqRespBody = (MigrateLogicalQueueBody)RemotingSerializable.decode((byte[])request.getBody(), MigrateLogicalQueueBody.class);
        if (reqRespBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        LogicalQueueRouteData fromQueueRouteData = reqRespBody.getFromQueueRouteData();
        LogicalQueueRouteData toQueueRouteData = reqRespBody.getToQueueRouteData();
        log.info("migrateTopicLogicalQueueCommit toQueueRouteData={}", (Object)toQueueRouteData);
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        String topic = toQueueRouteData.getTopic();
        int toQueueId = toQueueRouteData.getQueueId();
        if (!topicConfigManager.getTopicConfigTable().containsKey(topic)) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not exist");
        }
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
        if (logicalQueuesInfo == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not enable logical queue");
        }
        logicalQueuesInfo.writeLock().lock();
        try {
            List queueRouteDataList = (List)logicalQueuesInfo.get(toQueueRouteData.getLogicalQueueIndex());
            if (queueRouteDataList == null) {
                RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)String.format(Locale.ENGLISH, "logical queue %d not exist", toQueueRouteData.getLogicalQueueIndex()));
                return remotingCommand;
            }
            queueRouteDataList.stream().filter(arg_0 -> ((LogicalQueueRouteData)fromQueueRouteData).isSameTo(arg_0)).forEach(d -> d.copyFrom(fromQueueRouteData));
            LogicalQueueRouteData queueRouteData = queueRouteDataList.stream().filter(arg_0 -> ((LogicalQueueRouteData)toQueueRouteData).isSameTo(arg_0)).findFirst().orElse(null);
            if (queueRouteData == null) {
                RemotingCommand remotingCommand = RemotingCommand.createResponseCommand((int)1, (String)String.format(Locale.ENGLISH, "message queue %d-%d not exist", toQueueId, toQueueRouteData.getOffsetDelta()));
                return remotingCommand;
            }
            queueRouteData.setLogicalQueueDelta(toQueueRouteData.getLogicalQueueDelta());
            queueRouteData.setState(MessageQueueRouteState.Normal);
            toQueueRouteData.setState(MessageQueueRouteState.Normal);
            if (toQueueRouteData.getBrokerAddr() != null) {
                queueRouteData.setBrokerAddr(toQueueRouteData.getBrokerAddr());
            }
        }
        finally {
            logicalQueuesInfo.writeLock().unlock();
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setBody(RemotingSerializable.encode((Object)reqRespBody));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand migrateTopicLogicalQueueNotify(ChannelHandlerContext ctx, RemotingCommand request) {
        MigrateLogicalQueueBody requestBody = (MigrateLogicalQueueBody)RemotingSerializable.decode((byte[])request.getBody(), MigrateLogicalQueueBody.class);
        if (requestBody == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"decode error");
        }
        LogicalQueueRouteData fromQueueRouteData = requestBody.getFromQueueRouteData();
        LogicalQueueRouteData toQueueRouteData = requestBody.getToQueueRouteData();
        log.info("migrateTopicLogicalQueueNotify fromQueueRouteData={} toQueueRouteData={}", (Object)fromQueueRouteData, (Object)toQueueRouteData);
        TopicConfigManager topicConfigManager = this.brokerController.getTopicConfigManager();
        String topic = toQueueRouteData.getTopic();
        if (!topicConfigManager.getTopicConfigTable().containsKey(topic)) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not exist");
        }
        LogicalQueuesInfoInBroker logicalQueuesInfo = topicConfigManager.selectLogicalQueuesInfo(topic);
        if (logicalQueuesInfo == null) {
            return RemotingCommand.createResponseCommand((int)1, (String)"topic not enable logical queue");
        }
        ArrayList requestQueueRouteDataList = Lists.newArrayList((Object[])new LogicalQueueRouteData[]{fromQueueRouteData, toQueueRouteData});
        boolean toQueueRouteDataFound = false;
        logicalQueuesInfo.writeLock().lock();
        try {
            List queueRouteDataList = (List)logicalQueuesInfo.computeIfAbsent(toQueueRouteData.getLogicalQueueIndex(), ignore -> Lists.newArrayListWithExpectedSize((int)1));
            for (LogicalQueueRouteData v : queueRouteDataList) {
                Iterator iterator = requestQueueRouteDataList.iterator();
                while (iterator.hasNext()) {
                    LogicalQueueRouteData queueRouteData = (LogicalQueueRouteData)iterator.next();
                    if (!queueRouteData.isSameTo(v)) continue;
                    v.copyFrom(queueRouteData);
                    if (queueRouteData.getBrokerAddr() != null) {
                        v.setBrokerAddr(queueRouteData.getBrokerAddr());
                    }
                    if (!toQueueRouteDataFound && toQueueRouteData.isSameTo(v)) {
                        toQueueRouteDataFound = true;
                    }
                    iterator.remove();
                    break;
                }
                if (!requestQueueRouteDataList.isEmpty()) continue;
                break;
            }
            if (!queueRouteDataList.isEmpty() && !toQueueRouteDataFound) {
                queueRouteDataList.add(toQueueRouteData);
            }
        }
        finally {
            logicalQueuesInfo.writeLock().unlock();
        }
        topicConfigManager.getDataVersion().nextVersion();
        topicConfigManager.persist(topic, (Object)logicalQueuesInfo);
        this.brokerController.registerIncrementBrokerData(topicConfigManager.selectTopicConfig(topic), topicConfigManager.getDataVersion());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        return response;
    }
}

