/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.rpc;

import java.nio.ByteBuffer;
import org.apache.rocketmq.common.rpc.RpcRequest;
import org.apache.rocketmq.common.rpc.RpcResponse;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class RpcClientUtils {
    public static RemotingCommand createCommandForRpcRequest(RpcRequest rpcRequest) {
        RemotingCommand cmd = RemotingCommand.createRequestCommand((int)rpcRequest.getCode(), (CommandCustomHeader)rpcRequest.getHeader());
        cmd.setBody(RpcClientUtils.encodeBody(rpcRequest.getBody()));
        return cmd;
    }

    public static RemotingCommand createCommandForRpcResponse(RpcResponse rpcResponse) {
        RemotingCommand cmd = RemotingCommand.createResponseCommandWithHeader((int)rpcResponse.getCode(), (CommandCustomHeader)rpcResponse.getHeader());
        cmd.setRemark(rpcResponse.getException() == null ? "" : rpcResponse.getException().getMessage());
        cmd.setBody(RpcClientUtils.encodeBody(rpcResponse.getBody()));
        return cmd;
    }

    public static byte[] encodeBody(Object body) {
        if (body == null) {
            return null;
        }
        if (body instanceof byte[]) {
            return (byte[])body;
        }
        if (body instanceof RemotingSerializable) {
            return ((RemotingSerializable)body).encode();
        }
        if (body instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)body;
            buffer.mark();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            buffer.reset();
            return data;
        }
        throw new RuntimeException("Unsupported body type " + body.getClass());
    }
}

