/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.api.registry;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.foundation.common.Version;
import org.apache.servicecomb.registry.api.registry.Framework;
import org.apache.servicecomb.registry.api.registry.FrameworkVersions;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.config.ConfigurePropertyUtils;
import org.apache.servicecomb.registry.config.MicroservicePropertiesLoader;

public class MicroserviceFactory {
    public Microservice create() {
        return this.create((Configuration)ConfigUtil.createLocalConfig());
    }

    public Microservice create(Configuration configuration) {
        Microservice microservice = this.createMicroserviceFromConfiguration(configuration);
        microservice.setInstance(MicroserviceInstance.createFromDefinition(configuration));
        return microservice;
    }

    private Microservice createMicroserviceFromConfiguration(Configuration configuration) {
        Microservice microservice = new Microservice();
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        if (!StringUtils.isEmpty((CharSequence)envConfig.getString("APP_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("APP_MAPPING")))) {
            microservice.setAppId(envConfig.getString(envConfig.getString("APP_MAPPING")));
        } else {
            microservice.setAppId(BootStrapProperties.readApplication((Configuration)configuration));
        }
        if (!StringUtils.isEmpty((CharSequence)envConfig.getString("SERVICE_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("SERVICE_MAPPING")))) {
            microservice.setServiceName(envConfig.getString(envConfig.getString("SERVICE_MAPPING")));
        } else {
            microservice.setServiceName(BootStrapProperties.readServiceName((Configuration)configuration));
        }
        String version = !StringUtils.isEmpty((CharSequence)envConfig.getString("VERSION_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("VERSION_MAPPING"))) ? envConfig.getString(envConfig.getString("VERSION_MAPPING")) : BootStrapProperties.readServiceVersion((Configuration)configuration);
        new Version(version);
        microservice.setVersion(version);
        microservice.setDescription(BootStrapProperties.readServiceDescription((Configuration)configuration));
        microservice.setLevel(BootStrapProperties.readServiceRole((Configuration)configuration));
        microservice.setPaths(ConfigurePropertyUtils.getMicroservicePaths(configuration));
        Map<String, String> propertiesMap = MicroservicePropertiesLoader.INSTANCE.loadProperties(configuration);
        microservice.setProperties(propertiesMap);
        microservice.setEnvironment(BootStrapProperties.readServiceEnvironment((Configuration)configuration));
        if (microservice.allowCrossApp()) {
            microservice.setAlias(Microservice.generateAbsoluteMicroserviceName(microservice.getAppId(), microservice.getServiceName()));
        }
        microservice.setFramework(this.createFramework());
        microservice.setRegisterBy("SDK");
        return microservice;
    }

    private Framework createFramework() {
        Framework framework = new Framework();
        framework.setName("servicecomb-java-chassis");
        framework.setVersion(FrameworkVersions.allVersions());
        return framework;
    }
}

