/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCLLogger
implements org.mortbay.log.Logger {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    private final String name;
    private final Logger logger;

    public JCLLogger() {
        this("org.mortbay.jetty");
    }

    public JCLLogger(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String old = System.getProperty("org.mortbay.log.class");
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            System.setProperty("org.mortbay.log.class", JCLLogger.class.getName());
            Class<?> cl = org.mortbay.log.Logger.class.getClassLoader().loadClass("org.mortbay.log.Log");
            Thread.currentThread().setContextClassLoader(JCLLogger.class.getClassLoader());
            cl.getMethod("isDebugEnabled", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (old != null) {
                System.setProperty("org.mortbay.log.class", old);
            } else {
                System.getProperties().remove("org.mortbay.log.class");
            }
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void debug(String msg, Throwable th) {
        this.logger.debug(msg, th);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.logger.debug(JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
    }

    public org.mortbay.log.Logger getLogger(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        return new JCLLogger(this.name + "." + loggerName);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.logger.info(JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void setDebugEnabled(boolean enabled) {
        this.logger.warn("setDebugEnabled not supported");
    }

    public void warn(String msg, Throwable th) {
        this.logger.warn(msg, th);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.logger.warn(JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
    }

    public static String arrayFormat(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        int i = 0;
        int len = messagePattern.length();
        int j = messagePattern.indexOf(123);
        StringBuffer sbuf = new StringBuffer(messagePattern.length() + 50);
        for (int index = 0; index < argArray.length; ++index) {
            int escape = 120;
            j = messagePattern.indexOf(123, i);
            if (j == -1 || j + 1 == len) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            char delimStop = messagePattern.charAt(j + 1);
            if (j > 0) {
                escape = messagePattern.charAt(j - 1);
            }
            if (escape == 92) {
                --index;
                sbuf.append(messagePattern.substring(i, j - 1));
                sbuf.append('{');
                i = j + 1;
                continue;
            }
            if (delimStop != '}') {
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            sbuf.append(messagePattern.substring(i, j));
            sbuf.append(argArray[index]);
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i, messagePattern.length()));
        return sbuf.toString();
    }
}

