/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.servicemix.expression.Expression;

public class BasicAuthCredentials {
    protected Expression username;
    protected Expression password;
    protected Expression host;
    protected Expression domain;

    public Expression getUsername() {
        return this.username;
    }

    public void setUsername(Expression username) {
        this.username = username;
    }

    public Expression getPassword() {
        return this.password;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    public Expression getDomain() {
        return this.domain;
    }

    public void setDomain(Expression domain) {
        this.domain = domain;
    }

    public Expression getHost() {
        return this.host;
    }

    public void setHost(Expression host) {
        this.host = host;
    }

    public void applyCredentials(HttpClient client, MessageExchange exchange, NormalizedMessage message, HostConfiguration hostConfig) throws MessagingException {
        AuthScope scope = null;
        scope = hostConfig != null ? new AuthScope(hostConfig.getHost(), hostConfig.getPort()) : new AuthScope(AuthScope.ANY_HOST, -1);
        Object credentials = this.domain != null && this.host != null ? new NTCredentials((String)this.username.evaluate(exchange, message), (String)this.password.evaluate(exchange, message), (String)this.host.evaluate(exchange, message), (String)this.domain.evaluate(exchange, message)) : new UsernamePasswordCredentials((String)this.username.evaluate(exchange, message), (String)this.password.evaluate(exchange, message));
        client.getState().setCredentials(scope, (Credentials)credentials);
    }

    public void applyProxyCredentials(HttpClient client, MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1);
        Object credentials = this.domain != null && this.host != null ? new NTCredentials((String)this.username.evaluate(exchange, message), (String)this.password.evaluate(exchange, message), (String)this.host.evaluate(exchange, message), (String)this.domain.evaluate(exchange, message)) : new UsernamePasswordCredentials((String)this.username.evaluate(exchange, message), (String)this.password.evaluate(exchange, message));
        client.getState().setProxyCredentials(scope, (Credentials)credentials);
    }
}

