/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.servicemix.http.endpoints.AbstractHttpConsumerMarshaler;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapConsumerMarshaler
extends AbstractHttpConsumerMarshaler {
    private Binding<?> binding;
    private boolean useJbiWrapper = true;
    private Policy[] policies;
    private Map<InterceptorProvider.Phase, InterceptorChain> chains = new HashMap<InterceptorProvider.Phase, InterceptorChain>();
    private String soapVersion = "1.2";

    public Binding<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Binding<?> binding) {
        this.binding = binding;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public MessageExchange createExchange(HttpServletRequest request, ComponentContext context) throws Exception {
        String method = request.getMethod();
        Message msg = this.binding.createMessage();
        msg.put(ComponentContext.class, (Object)context);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.put((Object)"Content-Type", (Object)request.getContentType());
        Map headers = msg.getTransportHeaders();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        headers.put("REQUEST_URI", request.getRequestURL().toString());
        headers.put("CONTENT_TYPE", request.getContentType());
        headers.put("REQUEST_METHOD", method);
        if ("POST".equals(method) || "PUT".equals(method)) {
            msg.setContent(InputStream.class, (Object)this.getRequestEncodingStream(request.getHeader("Content-Encoding"), (InputStream)request.getInputStream()));
        }
        request.setAttribute(Message.class.getName(), (Object)msg);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerIn);
        phase.doIntercept(msg);
        return (MessageExchange)msg.getContent(MessageExchange.class);
    }

    @Override
    public void sendAccepted(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setStatus(202);
    }

    @Override
    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        if (this.soapVersion.equals("1.1")) {
            response.setContentType("text/xml");
        } else {
            response.setContentType("application/soap+xml");
        }
        Message in = (Message)request.getAttribute(Message.class.getName());
        Message msg = this.binding.createMessage(in);
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Content-Encoding"), (OutputStream)response.getOutputStream());
        msg.setContent(OutputStream.class, (Object)encodingStream);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)outMsg);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOut);
        phase.doIntercept(msg);
        encodingStream.close();
    }

    @Override
    public void sendError(MessageExchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        if (this.soapVersion.equals("1.1")) {
            response.setContentType("text/xml");
        } else {
            response.setContentType("application/soap+xml");
        }
        response.setStatus(500);
        Message in = (Message)request.getAttribute(Message.class.getName());
        Message msg = this.binding.createMessage(in);
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Content-Encoding"), (OutputStream)response.getOutputStream());
        msg.setContent(OutputStream.class, (Object)encodingStream);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault);
        SoapFault soapFault = error instanceof SoapFault ? (SoapFault)error : new SoapFault(error);
        msg.setContent(Exception.class, (Object)soapFault);
        phase.doIntercept(msg);
        encodingStream.close();
    }

    @Override
    public void sendFault(MessageExchange exchange, Fault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        if (this.soapVersion.equals("1.1")) {
            response.setContentType("text/xml");
        } else {
            response.setContentType("application/soap+xml");
        }
        response.setStatus(500);
        Message in = (Message)request.getAttribute(Message.class.getName());
        Message msg = this.binding.createMessage(in);
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Content-Encoding"), (OutputStream)response.getOutputStream());
        msg.setContent(OutputStream.class, (Object)encodingStream);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)fault);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault);
        QName code = (QName)fault.getProperty("org.apache.servicemix.soap.fault.code");
        String reason = (String)fault.getProperty("org.apache.servicemix.soap.fault.reason");
        SoapFault soapFault = new SoapFault(code, reason, null, null, fault.getContent());
        msg.setContent(Exception.class, (Object)soapFault);
        phase.doIntercept(msg);
        encodingStream.close();
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase) {
        InterceptorChain chain = this.chains.get(phase);
        if (chain == null) {
            chain = this.binding.getInterceptorChain(phase);
            if (this.policies != null) {
                for (int i = 0; i < this.policies.length; ++i) {
                    chain.add((Iterable)this.policies[i].getInterceptors(phase));
                }
            }
            this.chains.put(phase, chain);
        }
        return chain;
    }
}

