/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class SpringWSDLLocator
implements WSDLLocator {
    private Resource base;
    private Resource latest;
    private Map<String, Resource> history;

    public SpringWSDLLocator(Resource main) {
        this.base = main;
        this.history = new HashMap<String, Resource>();
        this.history.put(this.getBaseURI(), main);
    }

    public InputSource getBaseInputSource() {
        try {
            return new InputSource(this.base.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        try {
            Resource parent = this.history.get(parentLocation);
            if (parent != null) {
                this.latest = parent.createRelative(importLocation);
                this.history.put(this.getLatestImportURI(), this.latest);
                return new InputSource(this.latest.getInputStream());
            }
            throw new UnsupportedOperationException();
        }
        catch (UnsupportedOperationException nie) {
            throw nie;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBaseURI() {
        try {
            return this.base.getURI().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLatestImportURI() {
        try {
            if (this.latest != null) {
                return this.latest.getURI().toString();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.latest = null;
        this.history.clear();
    }
}

