/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasUserRealm
extends MappedLoginService {
    private final Logger logger = LoggerFactory.getLogger(JaasUserRealm.class);
    private String domain = "servicemix-domain";
    private AuthenticationService authenticationService;

    public JaasUserRealm() {
        this._identityService = new JaasJettyIdentityService();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public UserIdentity login(String username, Object credentials) {
        if (username != null && !username.equals("")) {
            this._users.remove(username);
            Subject subject = new Subject();
            try {
                if (this.authenticationService != null) {
                    this.authenticationService.authenticate(subject, this.domain, username, credentials);
                }
            }
            catch (GeneralSecurityException e) {
                this.logger.debug("Login Failed", (Throwable)e);
                return null;
            }
            return new JaasJettyPrincipal(subject, username, IdentityService.NO_ROLES);
        }
        this.logger.debug("Login Failed - null userID");
        return null;
    }

    protected UserIdentity loadUser(String username) {
        return (UserIdentity)this._users.get(username);
    }

    protected void loadUsers() throws IOException {
    }

    public static class JaasJettyIdentityService
    extends DefaultIdentityService {
        public UserIdentity newUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
            return new JaasJettyPrincipal(subject, userPrincipal.getName(), roles);
        }
    }
}

