/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.processors;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpoint;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.LateResponseStrategy;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.exception.HttpTimeoutException;
import org.apache.servicemix.http.exception.LateResponseException;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.apache.servicemix.http.processors.AbstractProcessor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapExchangeProcessor;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerProcessor
extends AbstractProcessor
implements SoapExchangeProcessor,
HttpProcessor {
    private static final String HTTP_METHOD = "HTTP_METHOD";
    private static final String EXCHANGE = MessageExchange.class.getName();
    private static final String MUTEX = MessageExchange.class.getName() + "Mutex";
    private static final String EXCHANGEID = MessageExchange.class.getName() + "Mutex";
    private final Logger logger = LoggerFactory.getLogger(ConsumerProcessor.class);
    protected Object httpContext;
    protected ComponentContext context;
    protected DeliveryChannel channel;
    protected SoapHelper soapHelper;
    protected Map<String, Continuation> continuations = new ConcurrentHashMap<String, Continuation>();
    protected Map<String, Object> mutexes = new ConcurrentHashMap<String, Object>();
    private Map<String, MessageExchange> sentExchanges = new ConcurrentHashMap<String, MessageExchange>();
    protected int suspentionTime = 60000;
    protected boolean started = false;
    protected boolean supportAllHttpMethods;
    protected LateResponseStrategy lateResponseStrategy = LateResponseStrategy.error;

    public ConsumerProcessor(HttpEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
        this.suspentionTime = endpoint.getTimeout();
        if (this.suspentionTime <= 0) {
            this.suspentionTime = this.getConfiguration().getConsumerProcessorSuspendTime();
        }
        this.supportAllHttpMethods = endpoint.isSupportAllHttpMethods();
    }

    @Override
    public SslParameters getSsl() {
        return this.endpoint.getSsl();
    }

    @Override
    public String getAuthMethod() {
        return this.endpoint.getAuthMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        String id = exchange.getExchangeId();
        Continuation continuation = this.continuations.get(id);
        if (continuation != null) {
            Object mutex = continuation.getAttribute(MUTEX);
            if (mutex == null) {
                this.handleLateResponse(exchange);
                return;
            }
            Object object = mutex;
            synchronized (object) {
                if (!continuation.isExpired() && !continuation.isResumed()) {
                    this.logger.debug("Resuming continuation for exchange: {}", (Object)id);
                    continuation.setAttribute(EXCHANGE, (Object)exchange);
                    continuation.resume();
                    if (!continuation.isResumed()) {
                        this.handleLateResponse(exchange);
                    }
                } else {
                    this.handleLateResponse(exchange);
                }
            }
        } else {
            this.handleLateResponse(exchange);
        }
    }

    public void init() throws Exception {
        String url = this.endpoint.getLocationURI();
        this.context = new EndpointComponentContext((Endpoint)this.endpoint);
        this.channel = this.context.getDeliveryChannel();
        this.httpContext = this.getServerManager().createContext(url, this);
    }

    public void shutdown() throws Exception {
        if (this.httpContext instanceof Server.Graceful) {
            ((Server.Graceful)this.httpContext).setShutdown(true);
        }
        this.getServerManager().remove(this.httpContext);
    }

    public void start() throws Exception {
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Continuation continuation = null;
        Object mutex = null;
        String id = null;
        try {
            MessageExchange exchange;
            if (this.handleStaticResource(request, response)) {
                return;
            }
            continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            mutex = this.getOrCreateMutex(continuation);
            boolean sendExchange = false;
            Object object = mutex;
            synchronized (object) {
                exchange = (MessageExchange)continuation.getAttribute(EXCHANGE);
                id = (String)continuation.getAttribute(EXCHANGEID);
                if (exchange == null) {
                    if (continuation.isExpired()) {
                        throw new HttpTimeoutException(id);
                    }
                    this.logger.debug("Receiving HTTP request: {}", (Object)request);
                    if (!this.started) {
                        response.sendError(503, "Endpoint is stopped");
                        return;
                    }
                    continuation.setTimeout((long)this.suspentionTime);
                    exchange = this.createExchange(request);
                    id = exchange.getExchangeId();
                    continuation.setAttribute(MUTEX, mutex);
                    continuation.setAttribute(EXCHANGEID, (Object)id);
                    this.mutexes.put(id, mutex);
                    this.continuations.put(id, continuation);
                    this.sentExchanges.put(id, exchange);
                    this.logger.debug("Suspending continuation for exchange: {}", (Object)id);
                    continuation.suspend((ServletResponse)response);
                    sendExchange = true;
                }
            }
            if (sendExchange) {
                this.send(exchange);
                return;
            }
            this.logger.debug("Resuming HTTP request: {}", (Object)request);
            this.doClean(mutex, continuation, id);
            this.handleResponse(exchange, request, response);
        }
        catch (Exception e) {
            this.doClean(mutex, continuation, id);
            this.sendFault(e instanceof SoapFault ? (SoapFault)e : new SoapFault(e), request, response);
        }
    }

    private void send(MessageExchange exchange) throws MessagingException {
        this.channel.send(exchange);
    }

    protected MessageExchange createExchange(HttpServletRequest request) throws Exception {
        Context ctx = this.createContext(request);
        request.setAttribute(Context.class.getName(), (Object)ctx);
        MessageExchange exchange = this.soapHelper.onReceive(ctx);
        NormalizedMessage inMessage = exchange.getMessage("in");
        if (this.getConfiguration().isWantHeadersFromHttpIntoExchange()) {
            Map<String, String> requestMessageHeaders = this.getHeaders(request);
            if (this.supportAllHttpMethods) {
                requestMessageHeaders.put(HTTP_METHOD, request.getMethod());
            }
            inMessage.setProperty("javax.jbi.messaging.protocol.headers", requestMessageHeaders);
        }
        return exchange;
    }

    private Object getOrCreateMutex(Continuation continuation) {
        Object result = null;
        if (continuation != null) {
            result = continuation.getAttribute(MUTEX);
        }
        if (result == null) {
            result = new Object();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageExchange doClean(Object mutex, Continuation continuation, String exchangeId) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                if (exchangeId == null && continuation != null) {
                    exchangeId = (String)continuation.getAttribute(EXCHANGEID);
                }
                if (exchangeId != null && continuation == null) {
                    continuation = this.continuations.remove(exchangeId);
                }
                if (continuation != null) {
                    continuation.removeAttribute(EXCHANGEID);
                    continuation.removeAttribute(EXCHANGE);
                    continuation.removeAttribute(MUTEX);
                }
                if (exchangeId != null) {
                    this.mutexes.remove(exchangeId);
                    this.continuations.remove(exchangeId);
                    return this.sentExchanges.remove(exchangeId);
                }
            }
        }
        return null;
    }

    private void handleResponse(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Exception e = exchange.getError();
            if (e == null) {
                e = new Exception("Unknown error (exchange aborted ?)");
            }
            throw e;
        }
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            try {
                Fault fault = exchange.getFault();
                if (fault != null) {
                    this.processFault(exchange, request, response);
                } else {
                    this.processResponse(exchange, request, response);
                }
                this.done(exchange);
            }
            catch (Exception e) {
                this.fail(exchange, e);
                throw e;
            }
        } else if (exchange.getStatus() == ExchangeStatus.DONE) {
            response.setStatus(202);
        }
    }

    private void done(MessageExchange exchange) throws MessagingException {
        exchange.setStatus(ExchangeStatus.DONE);
        this.channel.send(exchange);
    }

    private void fail(MessageExchange exchange, Exception e) throws MessagingException {
        exchange.setError(e);
        this.channel.send(exchange);
    }

    protected boolean handleStaticResource(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug("Receiving HTTP request: {}", (Object)request);
        String httpMethod = request.getMethod();
        if ("GET".equals(httpMethod)) {
            this.processGetRequest(request, response);
            return true;
        }
        if (!"POST".equals(httpMethod) && !this.supportAllHttpMethods) {
            response.sendError(405, httpMethod + " not supported");
            return true;
        }
        return false;
    }

    private Context createContext(HttpServletRequest request) throws Exception {
        SoapMessage message = this.soapHelper.getSoapMarshaler().createReader().read((InputStream)request.getInputStream(), request.getHeader("Content-Type"));
        Context ctx = this.soapHelper.createContext(message);
        if (request.getUserPrincipal() != null) {
            if (request.getUserPrincipal() instanceof JaasJettyPrincipal) {
                Subject subject = ((JaasJettyPrincipal)request.getUserPrincipal()).getSubject();
                ctx.getInMessage().setSubject(subject);
            } else {
                ctx.getInMessage().addPrincipal(request.getUserPrincipal());
            }
        }
        return ctx;
    }

    private void processResponse(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NormalizedMessage outMsg = exchange.getMessage("out");
        if (outMsg != null) {
            Context ctx = (Context)request.getAttribute(Context.class.getName());
            SoapMessage out = this.soapHelper.onReply(ctx, outMsg);
            SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(out);
            response.setContentType(writer.getContentType());
            writer.write((OutputStream)response.getOutputStream());
        }
    }

    private void processFault(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SoapFault fault = new SoapFault((QName)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.code"), (QName)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.subcode"), (String)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.reason"), (URI)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.node"), (URI)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.role"), exchange.getFault().getContent());
        this.sendFault(fault, request, response);
    }

    private void processGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String query = request.getQueryString();
        if (query != null && query.trim().equalsIgnoreCase("wsdl")) {
            String uri = request.getRequestURI();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + "main.wsdl";
            response.sendRedirect(uri);
            return;
        }
        String path = request.getPathInfo();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        HttpComponent comp = (HttpComponent)this.endpoint.getServiceUnit().getComponent();
        comp.setProtocol(request.getScheme());
        comp.setHost(request.getServerName());
        comp.setPort(request.getServerPort());
        comp.setPath(request.getContextPath());
        this.endpoint.reloadWsdl();
        Node node = (Node)this.endpoint.getWsdls().get(path);
        if (node == null && path.endsWith("main.wsdl")) {
            node = (Node)this.endpoint.getWsdls().get("main.wsdl");
        }
        this.generateDocument(response, node);
    }

    protected void sendFault(SoapFault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (SoapFault.SENDER.equals(fault.getCode())) {
            response.setStatus(400);
        } else {
            response.setStatus(500);
        }
        Context ctx = (Context)request.getAttribute(Context.class.getName());
        SoapMessage soapFault = this.soapHelper.onFault(ctx, fault);
        SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapFault);
        response.setContentType(writer.getContentType());
        writer.write((OutputStream)response.getOutputStream());
    }

    protected Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        return headers;
    }

    protected ContextManager getServerManager() {
        HttpComponent comp = (HttpComponent)this.endpoint.getServiceUnit().getComponent();
        return comp.getServer();
    }

    protected void generateDocument(HttpServletResponse response, Node node) throws Exception {
        if (node == null) {
            response.sendError(404, "Unable to find requested resource");
            return;
        }
        response.setStatus(200);
        response.setContentType("text/xml");
        new SourceTransformer().toResult((Source)new DOMSource(node), (Result)new StreamResult((OutputStream)response.getOutputStream()));
    }

    protected void handleLateResponse(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            if (this.lateResponseStrategy == LateResponseStrategy.error) {
                this.fail(exchange, new LateResponseException(exchange));
            } else {
                this.logger.warn(LateResponseException.createMessage(exchange));
                this.done(exchange);
            }
        }
    }

    public void setLateResponseStrategy(String value) {
        this.lateResponseStrategy = LateResponseStrategy.valueOf(value);
    }

    public String getLateResponseStrategy() {
        return this.lateResponseStrategy.name();
    }

    public boolean isSupportAllHttpMethods() {
        return this.supportAllHttpMethods;
    }

    public void setSupportAllHttpMethods(boolean supportAllHttpMethods) {
        this.supportAllHttpMethods = supportAllHttpMethods;
    }
}

