/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.jca;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;
import org.jencks.SingletonEndpointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcaConsumerProcessor
extends AbstractJmsProcessor
implements MessageListener {
    private final Logger logger = LoggerFactory.getLogger(JcaConsumerProcessor.class);
    protected Map pendingMessages = new ConcurrentHashMap();
    protected ResourceAdapter resourceAdapter;
    protected MessageEndpointFactory endpointFactory;
    protected ActivationSpec activationSpec;
    protected BootstrapContext bootstrapContext;
    protected TransactionManager transactionManager;
    protected ConnectionFactory connectionFactory;

    public JcaConsumerProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    public void start() throws Exception {
        this.transactionManager = (TransactionManager)this.context.getTransactionManager();
        this.endpointFactory = new SingletonEndpointFactory((MessageListener)this, this.transactionManager);
        this.bootstrapContext = this.endpoint.getBootstrapContext();
        if (this.bootstrapContext == null) {
            throw new IllegalArgumentException("bootstrapContext not set");
        }
        this.connectionFactory = this.endpoint.getConnectionFactory();
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory not set");
        }
        this.activationSpec = this.endpoint.getActivationSpec();
        if (this.activationSpec == null) {
            throw new IllegalArgumentException("activationSpec not set");
        }
        this.resourceAdapter = this.endpoint.getResourceAdapter();
        if (this.resourceAdapter == null) {
            this.resourceAdapter = this.activationSpec.getResourceAdapter();
            if (this.resourceAdapter == null) {
                throw new IllegalArgumentException("resourceAdapter not set");
            }
        } else if (this.activationSpec.getResourceAdapter() == null) {
            this.activationSpec.setResourceAdapter(this.resourceAdapter);
        }
        this.resourceAdapter.start(this.bootstrapContext);
        this.resourceAdapter.endpointActivation(this.endpointFactory, this.activationSpec);
    }

    public void stop() throws Exception {
        this.resourceAdapter.endpointDeactivation(this.endpointFactory, this.activationSpec);
        this.pendingMessages.clear();
    }

    public void onMessage(Message message) {
        try {
            this.logger.debug("Received jms message {}", (Object)message);
            Context context = this.createContext();
            MessageExchange exchange = this.toNMS(message, context);
            if (!(exchange instanceof InOnly)) {
                throw new UnsupportedOperationException("JCA consumer endpoints can only use InOnly MEP");
            }
            exchange.setProperty("javax.jbi.transaction.jta", (Object)this.transactionManager.getTransaction());
            this.pendingMessages.put(exchange.getExchangeId(), context);
            if (this.endpoint.isSynchronous()) {
                this.channel.sendSync(exchange);
                this.process(exchange);
            } else {
                this.endpoint.getServiceUnit().getComponent().prepareExchange(exchange, (Endpoint)this.endpoint);
                this.channel.send(exchange);
            }
        }
        catch (Throwable e) {
            this.logger.error("Error while handling jms message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        Context context = (Context)this.pendingMessages.remove(exchange.getExchangeId());
        Message message = (Message)context.getProperty(Message.class.getName());
        Message response = null;
        Connection connection = null;
        try {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                if (this.endpoint.isRollbackOnError()) {
                    TransactionManager tm = (TransactionManager)this.endpoint.getServiceUnit().getComponent().getComponentContext().getTransactionManager();
                    tm.setRollbackOnly();
                    return;
                }
                if (exchange instanceof InOnly) {
                    this.logger.info("Exchange in error: {}", (Object)exchange, (Object)exchange.getError());
                    return;
                }
                connection = this.connectionFactory.createConnection();
                Session session = connection.createSession(true, 0);
                Exception error = exchange.getError();
                if (error == null) {
                    error = new Exception("Exchange in error");
                }
                response = session.createObjectMessage((Serializable)error);
                MessageProducer producer = session.createProducer(message.getJMSReplyTo());
                if (this.endpoint.isUseMsgIdInResponse()) {
                    response.setJMSCorrelationID(message.getJMSMessageID());
                } else {
                    response.setJMSCorrelationID(message.getJMSCorrelationID());
                }
                producer.send(response);
            } else {
                connection = this.connectionFactory.createConnection();
                Session session = connection.createSession(true, 0);
                response = this.fromNMSResponse(exchange, context, session);
                if (response != null) {
                    MessageProducer producer = session.createProducer(message.getJMSReplyTo());
                    if (this.endpoint.isUseMsgIdInResponse()) {
                        response.setJMSCorrelationID(message.getJMSMessageID());
                    } else {
                        response.setJMSCorrelationID(message.getJMSCorrelationID());
                    }
                    producer.send(response);
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            }
        }
    }
}

