/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;

public class AnonymousAuthenticationHandler
implements AuthenticationHandler {
    public static final String ALLOW_UNAUTHENTICATED = "shindig.allowUnauthenticated";
    public static final String AUTH_UNAUTHENTICATED = "Unauthenticated";
    private final boolean allowUnauthenticated;

    @Inject
    public AnonymousAuthenticationHandler(@Named(value="shindig.allowUnauthenticated") boolean allowUnauthenticated) {
        this.allowUnauthenticated = allowUnauthenticated;
    }

    public String getName() {
        return AUTH_UNAUTHENTICATED;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) {
        if (this.allowUnauthenticated) {
            return new AnonymousSecurityToken();
        }
        return null;
    }

    public String getWWWAuthenticateHeader(String realm) {
        return null;
    }
}

