/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.InjectedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationServletFilter
extends InjectedFilter {
    public static final String AUTH_TYPE_OAUTH = "OAuth";
    private static final String realm = "shindig";
    private List<AuthenticationHandler> handlers;
    private static final Logger logger = Logger.getLogger(AuthenticationServletFilter.class.getName());

    @Inject
    public void setAuthenticationHandlers(List<AuthenticationHandler> handlers) {
        this.handlers = handlers;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Auth filter can only handle HTTP");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            for (AuthenticationHandler handler : this.handlers) {
                SecurityToken token = handler.getSecurityTokenFromRequest(req);
                if (token != null) {
                    new AuthInfo(req).setAuthType(handler.getName()).setSecurityToken(token);
                    chain.doFilter((ServletRequest)req, response);
                    return;
                }
                String authHeader = handler.getWWWAuthenticateHeader(realm);
                if (authHeader == null) continue;
                resp.addHeader("WWW-Authenticate", authHeader);
            }
            chain.doFilter((ServletRequest)req, response);
        }
        catch (AuthenticationHandler.InvalidAuthenticationException iae) {
            logger.log(Level.INFO, iae.getMessage(), iae.getCause());
            if (iae.getAdditionalHeaders() != null) {
                for (Map.Entry<String, String> entry : iae.getAdditionalHeaders().entrySet()) {
                    resp.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (iae.getRedirect() != null) {
                resp.sendRedirect(iae.getRedirect());
            }
            resp.sendError(401, iae.getMessage());
        }
    }
}

