/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class BlobCrypterSecurityToken
implements SecurityToken {
    private static final int MAX_TOKEN_LIFETIME_SECS = 3600;
    private static final String OWNER_KEY = "o";
    private static final String VIEWER_KEY = "v";
    private static final String GADGET_KEY = "g";
    private static final String GADGET_INSTANCE_KEY = "i";
    private static final String TRUSTED_JSON_KEY = "j";
    private final BlobCrypter crypter;
    private final String container;
    private final String domain;
    private String ownerId;
    private String viewerId;
    private String appUrl;
    private long moduleId;
    private String trustedJson;

    public BlobCrypterSecurityToken(BlobCrypter crypter, String container, String domain) {
        this.crypter = crypter;
        this.container = container;
        this.domain = domain;
    }

    static BlobCrypterSecurityToken decrypt(BlobCrypter crypter, String container, String domain, String token) throws BlobCrypterException {
        Map<String, String> values = crypter.unwrap(token, 3600);
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(crypter, container, domain);
        t.setOwnerId(values.get(OWNER_KEY));
        t.setViewerId(values.get(VIEWER_KEY));
        t.setAppUrl(values.get(GADGET_KEY));
        String moduleId = values.get(GADGET_INSTANCE_KEY);
        if (moduleId != null) {
            t.setModuleId(Long.parseLong(moduleId));
        }
        t.setTrustedJson(values.get(TRUSTED_JSON_KEY));
        return t;
    }

    public String encrypt() throws BlobCrypterException {
        HashMap values = Maps.newHashMap();
        if (this.ownerId != null) {
            values.put(OWNER_KEY, this.ownerId);
        }
        if (this.viewerId != null) {
            values.put(VIEWER_KEY, this.viewerId);
        }
        if (this.appUrl != null) {
            values.put(GADGET_KEY, this.appUrl);
        }
        if (this.moduleId != 0L) {
            values.put(GADGET_INSTANCE_KEY, Long.toString(this.moduleId));
        }
        if (this.trustedJson != null) {
            values.put(TRUSTED_JSON_KEY, this.trustedJson);
        }
        return this.container + ':' + this.crypter.wrap(values);
    }

    public String getAppId() {
        return this.appUrl;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(long moduleId) {
        this.moduleId = moduleId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getTrustedJson() {
        return this.trustedJson;
    }

    public void setTrustedJson(String trustedJson) {
        this.trustedJson = trustedJson;
    }

    public String getUpdatedToken() {
        return null;
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public void setViewerId(String viewerId) {
        this.viewerId = viewerId;
    }

    public boolean isAnonymous() {
        return false;
    }
}

