/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlParameterAuthenticationHandler
implements AuthenticationHandler {
    public static final String AUTH_URL_PARAMETER = "SecurityTokenUrlParameter";
    private static final String TOKEN_PARAM = "st";
    private final SecurityTokenDecoder securityTokenDecoder;

    @Inject
    public UrlParameterAuthenticationHandler(SecurityTokenDecoder securityTokenDecoder) {
        this.securityTokenDecoder = securityTokenDecoder;
    }

    @Override
    public String getName() {
        return AUTH_URL_PARAMETER;
    }

    @Override
    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) {
        Map<String, String> parameters = this.getMappedParameters(request);
        try {
            if (parameters.get("token") == null) {
                return null;
            }
            return this.securityTokenDecoder.createToken(parameters);
        }
        catch (SecurityTokenException e) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Malformed security token " + parameters.get("token"), e);
        }
    }

    @Override
    public String getWWWAuthenticateHeader(String realm) {
        return null;
    }

    protected SecurityTokenDecoder getSecurityTokenDecoder() {
        return this.securityTokenDecoder;
    }

    protected Map<String, String> getMappedParameters(HttpServletRequest request) {
        String token = request.getParameter(TOKEN_PARAM);
        return Collections.singletonMap("token", token);
    }
}

