/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.ContainerConfigException;
import org.apache.shindig.common.util.ResourceLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsonContainerConfig
implements ContainerConfig {
    private static final Logger LOG = Logger.getLogger(JsonContainerConfig.class.getName());
    public static final char FILE_SEPARATOR = ',';
    public static final String PARENT_KEY = "parent";
    public static final String CONTAINER_KEY = "gadgets.container";
    private final Map<String, JSONObject> config = Maps.newHashMap();

    @Inject
    public JsonContainerConfig(@Named(value="shindig.containers.default") String containers) throws ContainerConfigException {
        if (containers != null) {
            this.loadContainers(containers);
        }
    }

    @Override
    public Collection<String> getContainers() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    @Override
    public Object getJson(String container, String parameter) {
        JSONObject data = this.config.get(container);
        if (data == null) {
            return null;
        }
        if (parameter == null) {
            return data;
        }
        try {
            for (String param : parameter.split("/")) {
                Object next = data.get(param);
                if (!(next instanceof JSONObject)) {
                    return next;
                }
                data = (JSONObject)next;
            }
            return data;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public String get(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        return data == null ? null : data.toString();
    }

    @Override
    public JSONObject getJsonObject(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        if (data instanceof JSONObject) {
            return (JSONObject)data;
        }
        return null;
    }

    @Override
    public JSONArray getJsonArray(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        if (data instanceof JSONArray) {
            return (JSONArray)data;
        }
        return null;
    }

    private void loadFiles(File[] files) throws ContainerConfigException {
        try {
            for (File file : files) {
                LOG.info("Reading container config: " + file.getName());
                if (file.isDirectory()) {
                    this.loadFiles(file.listFiles());
                    continue;
                }
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".js") || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
                    if (!file.exists()) {
                        throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' doesn't exist.");
                    }
                    this.loadFromString(ResourceLoader.getContent(file));
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest(file.getAbsolutePath() + " doesn't seem to be a JS or JSON file.");
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
    }

    private void loadResources(String[] files) throws ContainerConfigException {
        try {
            for (String entry : files) {
                LOG.info("Reading container config: " + entry);
                String content = ResourceLoader.getContent(entry);
                this.loadFromString(content);
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
    }

    private JSONObject mergeObjects(JSONObject base, JSONObject merge) throws JSONException {
        String[] fields;
        JSONObject clone = new JSONObject(base, JSONObject.getNames((JSONObject)base));
        for (String field : fields = JSONObject.getNames((JSONObject)merge)) {
            Object existing = clone.opt(field);
            Object update = merge.get(field);
            if (existing == null || update == null) {
                clone.put(field, update);
                continue;
            }
            if (update instanceof JSONObject && existing instanceof JSONObject) {
                clone.put(field, (Object)this.mergeObjects((JSONObject)existing, (JSONObject)update));
                continue;
            }
            clone.put(field, update);
        }
        return clone;
    }

    private JSONObject mergeParents(String container) throws ContainerConfigException, JSONException {
        JSONObject base = this.config.get(container);
        if ("default".equals(container)) {
            return base;
        }
        String parent = base.optString(PARENT_KEY, "default");
        if (!this.config.containsKey(parent)) {
            throw new ContainerConfigException("Unable to locate parent '" + parent + "' required by " + base.getString(CONTAINER_KEY));
        }
        return this.mergeObjects(this.mergeParents(parent), base);
    }

    protected void loadFromString(String json) throws ContainerConfigException {
        try {
            JSONObject contents = new JSONObject(json);
            JSONArray containers = contents.getJSONArray(CONTAINER_KEY);
            int j = containers.length();
            for (int i = 0; i < j; ++i) {
                String container = containers.getString(i);
                this.config.put(container, contents);
            }
        }
        catch (JSONException e) {
            throw new ContainerConfigException(e);
        }
    }

    private void loadContainers(String path) throws ContainerConfigException {
        try {
            for (String location : StringUtils.split((String)path, (char)',')) {
                if (location.startsWith("res://")) {
                    location = location.substring(6);
                    LOG.info("Loading resources from: " + location);
                    if (path.endsWith(".txt")) {
                        this.loadResources(ResourceLoader.getContent(location).split("[\r\n]+"));
                        continue;
                    }
                    this.loadResources(new String[]{location});
                    continue;
                }
                LOG.info("Loading files from: " + location);
                File file = new File(location);
                this.loadFiles(new File[]{file});
            }
            HashMap merged = Maps.newHashMapWithExpectedSize((int)this.config.size());
            for (String container : this.config.keySet()) {
                merged.put(container, this.mergeParents(container));
            }
            this.config.putAll(merged);
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
        catch (JSONException e) {
            throw new ContainerConfigException(e);
        }
    }
}

