/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonSerializer {
    private static final int BASE_MULTIPLIER = 256;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private JsonSerializer() {
    }

    public static String serialize(JSONObject object) {
        StringBuilder buf = new StringBuilder(object.length() * 256);
        try {
            JsonSerializer.appendJsonObject(buf, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static String serialize(Map<String, ?> map) {
        StringBuilder buf = new StringBuilder(map.size() * 256);
        try {
            JsonSerializer.appendMap(buf, map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static String serialize(Collection<?> collection) {
        StringBuilder buf = new StringBuilder(collection.size() * 256);
        try {
            JsonSerializer.appendCollection(buf, collection);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static String serialize(Object[] array) {
        StringBuilder buf = new StringBuilder(array.length * 256);
        try {
            JsonSerializer.appendArray(buf, array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static String serialize(JSONArray array) {
        StringBuilder buf = new StringBuilder(array.length() * 256);
        try {
            JsonSerializer.appendJsonArray(buf, array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static void append(Appendable buf, Object value) throws IOException {
        if (value == null) {
            buf.append("null");
        } else if (value instanceof JSONObject) {
            JsonSerializer.appendJsonObject(buf, (JSONObject)value);
        } else if (value instanceof String) {
            JsonSerializer.appendString(buf, (String)value);
        } else if (value instanceof Number || value instanceof Boolean) {
            buf.append(value.toString());
        } else if (value instanceof JSONArray) {
            buf.append(value.toString());
        } else if (value instanceof Map) {
            JsonSerializer.appendMap(buf, (Map)value);
        } else if (value instanceof Collection) {
            JsonSerializer.appendCollection(buf, (Collection)value);
        } else if (value.getClass().isArray()) {
            JsonSerializer.appendArray(buf, (Object[])value);
        } else {
            JsonSerializer.appendString(buf, value.toString());
        }
    }

    public static void appendArray(Appendable buf, Object[] array) throws IOException {
        buf.append('[');
        boolean firstDone = false;
        for (Object o : array) {
            if (firstDone) {
                buf.append(',');
            } else {
                firstDone = true;
            }
            JsonSerializer.append(buf, o);
        }
        buf.append(']');
    }

    public static void appendJsonArray(Appendable buf, JSONArray array) throws IOException {
        buf.append('[');
        boolean firstDone = false;
        int j = array.length();
        for (int i = 0; i < j; ++i) {
            if (firstDone) {
                buf.append(',');
            } else {
                firstDone = true;
            }
            JsonSerializer.append(buf, array.opt(i));
        }
        buf.append(']');
    }

    public static void appendCollection(Appendable buf, Collection<?> collection) throws IOException {
        buf.append('[');
        boolean firstDone = false;
        for (Object o : collection) {
            if (firstDone) {
                buf.append(',');
            } else {
                firstDone = true;
            }
            JsonSerializer.append(buf, o);
        }
        buf.append(']');
    }

    public static void appendMap(Appendable buf, Map<String, ?> map) throws IOException {
        buf.append('{');
        boolean firstDone = false;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (firstDone) {
                buf.append(',');
            } else {
                firstDone = true;
            }
            JsonSerializer.appendString(buf, entry.getKey());
            buf.append(':');
            JsonSerializer.append(buf, entry.getValue());
        }
        buf.append('}');
    }

    public static void appendJsonObject(Appendable buf, JSONObject object) throws IOException {
        buf.append('{');
        Iterator keys = object.keys();
        boolean firstDone = false;
        while (keys.hasNext()) {
            if (firstDone) {
                buf.append(',');
            } else {
                firstDone = true;
            }
            String key = (String)keys.next();
            JsonSerializer.appendString(buf, key);
            buf.append(':');
            JsonSerializer.append(buf, object.opt(key));
        }
        buf.append('}');
    }

    public static void appendString(Appendable buf, CharSequence string) throws IOException {
        if (string == null || string.length() == 0) {
            buf.append("\"\"");
            return;
        }
        char current = '\u0000';
        buf.append('\"');
        int j = string.length();
        block11: for (int i = 0; i < j; ++i) {
            char previous = current;
            current = string.charAt(i);
            switch (current) {
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(current);
                    continue block11;
                }
                case '/': {
                    if (previous == '<') {
                        buf.append('\\');
                    }
                    buf.append(current);
                    continue block11;
                }
                default: {
                    if (current < ' ' || current >= '\u0080' && current < '\u00a0' || current >= '\u2000' && current < '\u2100') {
                        buf.append('\\');
                        switch (current) {
                            case '\b': {
                                buf.append('b');
                                continue block11;
                            }
                            case '\t': {
                                buf.append('t');
                                continue block11;
                            }
                            case '\n': {
                                buf.append('n');
                                continue block11;
                            }
                            case '\f': {
                                buf.append('f');
                                continue block11;
                            }
                            case '\r': {
                                buf.append('r');
                                continue block11;
                            }
                        }
                        buf.append('u');
                        buf.append(HEX_DIGITS[current >> 12 & 0xF]);
                        buf.append(HEX_DIGITS[current >> 8 & 0xF]);
                        buf.append(HEX_DIGITS[current >> 4 & 0xF]);
                        buf.append(HEX_DIGITS[current & 0xF]);
                        continue block11;
                    }
                    buf.append(current);
                }
            }
        }
        buf.append('\"');
    }
}

