/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.Collection;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Check {
    private Check() {
    }

    public static void is(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void is(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static void eq(Object first, Object second, String message) {
        Check.that(first, Matchers.equalTo((Object)second), message);
    }

    public static void eq(Object first, Object second, String message, Object ... args) {
        Check.that(first, Matchers.equalTo((Object)second), String.format(message, args));
    }

    public static <T> void that(T actual, Matcher<T> matcher) {
        Check.that(actual, matcher, "");
    }

    public static <T> void that(T actual, Matcher<T> matcher, String message) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            if (message != null && message.length() > 0) {
                description.appendText(message).appendText(" - ");
            }
            description.appendValue(actual).appendText(" must be ");
            matcher.describeTo((Description)description);
            throw new IllegalStateException(matcher.toString());
        }
    }

    public static <T> void that(T actual, Matcher<T> matcher, String message, Object ... args) {
        Check.that(actual, matcher, String.format(message, args));
    }

    public static void notNull(Object ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
    }

    public static void notNull(Object ref, String message) {
        if (ref == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object ref, String message, Object ... args) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isA(Object ref, Class<?> clazz) {
        if (ref != null && !clazz.isAssignableFrom(ref.getClass())) {
            throw new IllegalArgumentException(String.format("Object must be an instance of %s", clazz));
        }
    }

    public static void isA(Object ref, Class<?> clazz, String message) {
        if (ref != null && !clazz.isAssignableFrom(ref.getClass())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isA(Object ref, Class<?> clazz, String message, Object ... args) {
        if (ref != null && !clazz.isAssignableFrom(ref.getClass())) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("String must be non-empty");
        }
    }

    public static void notEmpty(String string, String message) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String string, String message, Object ... args) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(Object[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array must be non-empty");
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Collection must be non-empty");
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... args) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Map must be non-empty");
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... args) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void noNulls(Object[] array) {
        if (array != null && array.length > 0) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException("Array must contain only non-null elements");
            }
        }
    }

    public static void noNulls(Object[] array, String message) {
        if (array != null && array.length > 0) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNulls(Object[] array, String message, Object ... args) {
        if (array != null && array.length > 0) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(String.format(message, args));
            }
        }
    }

    public static <E> void noNulls(Iterable<E> iterable) {
        if (iterable != null) {
            for (E element : iterable) {
                if (element != null) continue;
                throw new IllegalArgumentException("Iterable must contain only non-null elements");
            }
        }
    }

    public static <E> void noNulls(Iterable<E> iterable, String message) {
        if (iterable != null) {
            for (E element : iterable) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static <E> void noNulls(Iterable<E> iterable, String message, Object ... args) {
        if (iterable != null) {
            for (E element : iterable) {
                if (element != null) continue;
                throw new IllegalArgumentException(String.format(message, args));
            }
        }
    }

    public static <K, V> void noNulls(Map<K, V> map) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) continue;
                throw new IllegalArgumentException("Map must contain only non-null keys and values");
            }
        }
    }

    public static <K, V> void noNulls(Map<K, V> map, String message) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static <K, V> void noNulls(Map<K, V> map, String message, Object ... args) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) continue;
                throw new IllegalArgumentException(String.format(message, args));
            }
        }
    }
}

