/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */


/**
 * @fileoverview Currency code map.
 */

gadgets.i18n = gadgets.i18n || {};

/**
 * The mapping of currency symbol through intl currency code.
 */

gadgets.i18n.CurrencyCodeMap = {
  'USD': '$',
  'ARS': '$',
  'AWG': '\u0192',
  'AUD': '$',
  'BSD': '$',
  'BBD': '$',
  'BEF': '\u20A3',
  'BZD': '$',
  'BMD': '$',
  'BOB': '$',
  'BRL': 'R$',
  'BRC': '\u20A2',
  'GBP': '\u00A3',
  'BND': '$',
  'KHR': '\u17DB',
  'CAD': '$',
  'KYD': '$',
  'CLP': '$',
  'CNY': '\u00A5',
  'COP': '\u20B1',
  'CRC': '\u20A1',
  'CUP': '\u20B1',
  'CYP': '\u00A3',
  'DKK': 'kr',
  'DOP': '\u20B1',
  'XCD': '$',
  'EGP': '\u00A3',
  'SVC': '\u20A1',
  'EUR': '\u20AC',
  'XEU': '\u20A0',
  'FKP': '\u00A3',
  'FJD': '$',
  'FRF': '\u20A3',
  'GIP': '\u00A3',
  'GRD': '\u20AF',
  'GGP': '\u00A3',
  'GYD': '$',
  'NLG': '\u0192',
  'HKD': '$',
  'INR': '\u20A8',
  'IRR': '\uFDFC',
  'IEP': '\u00A3',
  'IMP': '\u00A3',
  'ILS': '\u20AA',
  'ITL': '\u20A4',
  'JMD': '$',
  'JPY': '\u00A5',
  'JEP': '\u00A3',
  'KPW': '\u20A9',
  'KRW': '\u20A9',
  'LAK': '\u20AD',
  'LBP': '\u00A3',
  'LRD': '$',
  'LUF': '\u20A3',
  'MTL': '\u20A4',
  'MUR': '\u20A8',
  'MXN': '$',
  'MNT': '\u20AE',
  'NAD': '$',
  'NPR': '\u20A8',
  'ANG': '\u0192',
  'NZD': '$',
  'OMR': '\uFDFC',
  'PKR': '\u20A8',
  'PEN': 'S/.',
  'PHP': '\u20B1',
  'QAR': '\uFDFC',
  'RUB': '\u0440\u0443\u0431',
  'SHP': '\u00A3',
  'SAR': '\uFDFC',
  'SCR': '\u20A8',
  'SGD': '$',
  'SBD': '$',
  'ZAR': 'R',
  'ESP': '\u20A7',
  'LKR': '\u20A8',
  'SEK': 'kr',
  'SRD': '$',
  'SYP': '\u00A3',
  'TWD': '\u5143',
  'THB': '\u0E3F',
  'TTD': '$',
  'TRY': '\u20A4',
  'TRL': '\u20A4',
  'TVD': '$',
  'UYU': '\u20B1',
  'VAL': '\u20A4',
  'VND': '\u20AB',
  'YER': '\uFDFC',
  'ZWD': '$'
};

